// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

namespace hkVectorPackUtility
{

HK_DETAIL_DIAG_MSVC_PUSH();

//  warning C4723: potential divide by 0
HK_DETAIL_DIAG_MSVC_OFF(4723);

// If the bit set in n is also set in m, this function will return ts. Otherwise it will return 0.
// Note: the 'if' statement is a compile-time 'if' (not a runtime 'if').
HK_INLINE hkUint32 filteredStoreToStream_calcOffset( hkUint32 n, const unsigned int ts, hkVectorComparison::Mask m )
{
    if ( n > ts )
    {
        return (m&n) / (n/ts);
    }
    else
    {
        return (m&n) * (ts/n);
    }
}

HK_DETAIL_DIAG_MSVC_POP();

} // namespace hkVectorPackUtility

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
