// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ANDROID APOLLO_ARM IOS METRO_ARM UWP_ARM NX32 NX64
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#ifndef HK_COMPILER_HAS_INTRINSICS_NEON
#error Cant include this header on non Neon setups..
#endif

HK_INLINE /*static*/ const hkVector4fComparison HK_CALL hkVector4fComparison::convert(const hkVector4fMask& x)
{
    hkVector4fComparison c;
    c.m_mask = x;
    return c;
}

HK_INLINE void hkVector4fComparison::setAnd( hkVector4fComparisonParameter a, hkVector4fComparisonParameter b )
{
    m_mask = vandq_u32( a.m_mask,b.m_mask );
}

HK_INLINE void hkVector4fComparison::setAndNot( hkVector4fComparisonParameter a, hkVector4fComparisonParameter b )
{
    m_mask = vbicq_u32( a.m_mask, b.m_mask ); // a & !b (so bit clear and set bits in b)
}

HK_INLINE void hkVector4fComparison::setXor( hkVector4fComparisonParameter a, hkVector4fComparisonParameter b )
{
    m_mask = veorq_u32( a.m_mask,b.m_mask );
}

HK_INLINE void hkVector4fComparison::setNot( hkVector4fComparisonParameter a )
{
    m_mask = vmvnq_u32(a.m_mask);
}

HK_INLINE void hkVector4fComparison::setOr( hkVector4fComparisonParameter a, hkVector4fComparisonParameter b )
{
    m_mask = vorrq_u32( a.m_mask,b.m_mask );
}

HK_INLINE void hkVector4fComparison::setSelect( hkVector4fComparisonParameter comp, hkVector4fComparisonParameter trueValue, hkVector4fComparisonParameter falseValue )
{
    m_mask = vbslq_u32( comp.m_mask, trueValue.m_mask, falseValue.m_mask );
}

template <> HK_INLINE void hkVector4fComparison::setSelect<hkVector4ComparisonMask::MASK_X>(hkVector4fComparisonParameter trueValue, hkVector4fComparisonParameter falseValue)
{
    m_mask = vsetq_lane_u32(vgetq_lane_u32(trueValue.m_mask, 0), falseValue.m_mask, 0);
}

template <> HK_INLINE void hkVector4fComparison::setSelect<hkVector4ComparisonMask::MASK_XY>(hkVector4fComparisonParameter trueValue, hkVector4fComparisonParameter falseValue)
{
    m_mask = vcombine_u32(vget_low_u32(trueValue.m_mask), vget_high_u32(falseValue.m_mask));
}

template <> HK_INLINE void hkVector4fComparison::setSelect<hkVector4ComparisonMask::MASK_XYZ>(hkVector4fComparisonParameter trueValue, hkVector4fComparisonParameter falseValue)
{
    m_mask = vsetq_lane_u32(vgetq_lane_u32(falseValue.m_mask, 3), trueValue.m_mask, 3);
}

template<hkVector4ComparisonMask::Mask M>
HK_INLINE void hkVector4fComparison::setSelect( hkVector4fComparisonParameter trueValue, hkVector4fComparisonParameter falseValue )
{
    HK_VECTORfCOMPARISON_MASK_CHECK;
    hkVector4fComparison cmp;   cmp.set<M>();
    setSelect(cmp, trueValue, falseValue);
}

HK_INLINE void hkVector4fComparison::set( Mask m )
{
    HK_COMPILE_TIME_ASSERT( hkVector4ComparisonMask::INDEX_X == 0);
    HK_COMPILE_TIME_ASSERT( hkVector4ComparisonMask::MASK_X == 1);
    HK_COMPILE_TIME_ASSERT( hkVector4ComparisonMask::MASK_Y == 2);
    HK_COMPILE_TIME_ASSERT( hkVector4ComparisonMask::MASK_XYZW == 15);

    HK_MATH_ASSERT(0x557dac2a, (m&0xf)==m, "illegal mask value handed in");

    static uint32x4_t maskToComparison[16] =
    {
        HK_NEON_CONSTANT4I(0,  0, 0, 0),
        HK_NEON_CONSTANT4I(~0,  0, 0, 0),
        HK_NEON_CONSTANT4I(0, ~0, 0, 0),
        HK_NEON_CONSTANT4I(~0, ~0, 0, 0),
        HK_NEON_CONSTANT4I(0,  0,~0, 0),
        HK_NEON_CONSTANT4I(~0,  0,~0, 0),
        HK_NEON_CONSTANT4I(0, ~0,~0, 0),
        HK_NEON_CONSTANT4I(~0, ~0,~0, 0),
        HK_NEON_CONSTANT4I(0,  0, 0,~0),
        HK_NEON_CONSTANT4I(~0,  0, 0,~0),
        HK_NEON_CONSTANT4I(0, ~0, 0,~0),
        HK_NEON_CONSTANT4I(~0, ~0, 0,~0),
        HK_NEON_CONSTANT4I(0,  0,~0,~0),
        HK_NEON_CONSTANT4I(~0,  0,~0,~0),
        HK_NEON_CONSTANT4I(0, ~0,~0,~0),
        HK_NEON_CONSTANT4I(~0, ~0,~0,~0),
    };

    m_mask = maskToComparison[m];
}

template <hkVector4ComparisonMask::Mask M>
HK_INLINE void hkVector4fComparison::set()
{
    HK_VECTORfCOMPARISON_MASK_CHECK;

    static uint32x4_t maskToComparison[16] =
    {
        HK_NEON_CONSTANT4I(0,  0, 0, 0),
        HK_NEON_CONSTANT4I(~0,  0, 0, 0),
        HK_NEON_CONSTANT4I(0, ~0, 0, 0),
        HK_NEON_CONSTANT4I(~0, ~0, 0, 0),
        HK_NEON_CONSTANT4I(0,  0,~0, 0),
        HK_NEON_CONSTANT4I(~0,  0,~0, 0),
        HK_NEON_CONSTANT4I(0, ~0,~0, 0),
        HK_NEON_CONSTANT4I(~0, ~0,~0, 0),
        HK_NEON_CONSTANT4I(0,  0, 0,~0),
        HK_NEON_CONSTANT4I(~0,  0, 0,~0),
        HK_NEON_CONSTANT4I(0, ~0, 0,~0),
        HK_NEON_CONSTANT4I(~0, ~0, 0,~0),
        HK_NEON_CONSTANT4I(0,  0,~0,~0),
        HK_NEON_CONSTANT4I(~0,  0,~0,~0),
        HK_NEON_CONSTANT4I(0, ~0,~0,~0),
        HK_NEON_CONSTANT4I(~0, ~0,~0,~0),
    };

    m_mask = maskToComparison[M];
}


HK_INLINE hkVector4ComparisonMask::Mask hkVector4fComparison::getMask() const
{
    // integer unit is much faster (3 times) than vector unit, do this on integer
#if 1
    hkUint32 res;
    res  = 1 & vgetq_lane_u32(m_mask, 0);
    res |= 2 & vgetq_lane_u32(m_mask, 1);
    res |= (4 & vgetq_lane_u32(m_mask, 2)) | (8 & vgetq_lane_u32(m_mask, 3));
    return (hkVector4ComparisonMask::Mask)res;
#else
    uint32x4_t s = HK_NEON_CONSTANT4I(1,2,4,8);
    uint32x4_t spread = vandq_u32( m_mask, s );
    uint32x2_t l = vget_low_u32(spread);
    uint32x2_t h = vget_high_u32(spread);
    uint32x2_t p01_23 = vpadd_u32(l, h); // 0+1,2+3
    uint32x2_t p0123 = vpadd_u32(p01_23, p01_23); // (0+1)+(2+3)

    return (hkVector4ComparisonMask::Mask)vget_lane_u32(p0123, 0);
#endif
}

HK_INLINE hkVector4ComparisonMask::Mask hkVector4fComparison::getMask(Mask m) const
{
    HK_MATH_ASSERT(0x3d2fea61, (m&0xf)==m, "illegal mask value handed in");
    return (hkVector4ComparisonMask::Mask)(getMask() & m);
}

template <hkVector4ComparisonMask::Mask M>
HK_INLINE hkVector4ComparisonMask::Mask hkVector4fComparison::getMask() const
{
    HK_VECTORfCOMPARISON_MASK_CHECK;
    hkUint32 res = (M & 1) ? (1 & vgetq_lane_u32(m_mask, 0)) : 0;
    if (M & 2) res |= 2 & vgetq_lane_u32(m_mask, 1);
    if (M & 4) res |= 4 & vgetq_lane_u32(m_mask, 2);
    if (M & 8) res |= 8 & vgetq_lane_u32(m_mask, 3);
    return (hkVector4ComparisonMask::Mask)res;
}


template <hkVector4ComparisonMask::Mask M>
HK_INLINE hkBool32 hkVector4fComparison::allAreSet() const
{
    HK_VECTORfCOMPARISON_MASK_CHECK;
    hkUint32 res = (M & 1) ? vgetq_lane_u32(m_mask, 0) : hkUint32(~0);
    if (M & 2) res &= vgetq_lane_u32(m_mask, 1);
    if (M & 4) res &= vgetq_lane_u32(m_mask, 2);
    if (M & 8) res &= vgetq_lane_u32(m_mask, 3);
    return res;
}

template <hkVector4ComparisonMask::Mask M>
HK_INLINE hkBool32 hkVector4fComparison::anyIsSet() const
{
    HK_VECTORfCOMPARISON_MASK_CHECK;
    hkUint32 res = (M & 1) ? vgetq_lane_u32(m_mask, 0) : hkUint32(0);
    if (M & 2) res |= vgetq_lane_u32(m_mask, 1);
    if (M & 4) res |= vgetq_lane_u32(m_mask, 2);
    if (M & 8) res |= vgetq_lane_u32(m_mask, 3);
    return res;
}

HK_INLINE hkBool32 hkVector4fComparison::allAreSet( Mask m ) const
{
    HK_MATH_ASSERT(0x71b4006b, (m&0xf)==m, "illegal mask value handed in");
    return (getMask()&m) == m;
}

HK_INLINE hkBool32 hkVector4fComparison::anyIsSet( Mask m ) const
{
    HK_MATH_ASSERT(0x68b44aee, (m&0xf)==m, "illegal mask value handed in");
    return (getMask()&m);
}

HK_INLINE hkBool32 hkVector4fComparison::allAreSet() const
{
    return allAreSet<hkVector4ComparisonMask::MASK_XYZW>();
}

HK_INLINE hkBool32 hkVector4fComparison::anyIsSet() const
{
    return anyIsSet<hkVector4ComparisonMask::MASK_XYZW>();
}

//
//  Horizontal and

template <> HK_INLINE const hkVector4fComparison hkVector4fComparison::horizontalAnd<1>() const
{
    uint32x2_t xy       = vget_low_u32(m_mask);     // [x, y]
    return hkVector4fComparison::convert( vdupq_lane_u32(xy, 0) );
}

template <> HK_INLINE const hkVector4fComparison hkVector4fComparison::horizontalAnd<2>() const
{
    uint32x2_t xy       = vget_low_u32(m_mask);     // [x, y]
    uint32x2_t yx       = vrev64_u32(xy);           // [y, x]
    uint32x2_t xy_xy    = vand_u32(xy, yx);         // [x & y, x & y]

    return hkVector4fComparison::convert( vdupq_lane_u32(xy_xy, 0) );
}

template <> HK_INLINE const hkVector4fComparison hkVector4fComparison::horizontalAnd<3>() const
{
    uint32x2_t xy       = vget_low_u32(m_mask);     // [x, y]
    uint32x2_t yx       = vrev64_u32(xy);           // [y, x]
    uint32x2_t xy_xy    = vand_u32(xy, yx);         // [x & y, x & y]
    uint32x2_t zw       = vget_high_u32(m_mask);    // [z, w]
    uint32x2_t zz       = vdup_lane_u32(zw, 0);     // [z, z]
    uint32x2_t xyz_xyz  = vand_u32(xy_xy, zz);      // [x & y & z, x & y & z]

    return hkVector4fComparison::convert( vdupq_lane_u32(xyz_xyz, 0) );
}

template <> HK_INLINE const hkVector4fComparison hkVector4fComparison::horizontalAnd<4>() const
{
    uint32x2_t lo       = vget_low_u32(m_mask);     // [x, y]
    uint32x2_t hi       = vget_high_u32(m_mask);    // [z, w]
    uint32x2_t xz_yw    = vand_u32(lo, hi);         // [x & z, y & w]
    uint32x2_t yw_xz    = vrev64_u32(xz_yw);        // [y & w, x & z]
    uint32x2_t xyzw     = vand_u32(xz_yw, yw_xz);   // [x & y & z & w, x & y & z & w]

    return hkVector4fComparison::convert( vdupq_lane_u32(xyzw, 0) );
}

template <int N> HK_INLINE const hkVector4fComparison hkVector4fComparison::horizontalAnd() const
{
    HK_VECTORfCOMPARISON_SUBINDEX_CHECK;
    hkVector4fComparison cmp;
    cmp.set<hkVector4ComparisonMask::MASK_NONE>();
    return cmp;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
