// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
//HK_REFLECTION_PARSER_EXCLUDE_FILE

#pragma once

#include <Common/Base/Math/Types/Mx/hkMxMathTypes.h>

#define hkMxSinglefParameter const hkMxSinglef<M>&

/// Long vector for vectorized computing (Mx1 vectors).
///
/// This represents M 4-component vectors which are all the same.
/// Note that although the subvectors are all the same, this vector still has a distinct length
/// as you cannot rely in general on how the storage is optimized for the replicated subvectors.
/// In this documentation we use abcd and following letters to
/// refer to one of the 4-component subvectors.
/// Example M=4: layout of the long vector: abcd abcd abcd abcd
///
/// The purpose of this vector is to implement efficient loop-unrolled algorithms without branching
/// to efficiently use the SIMD processing hardware capabilities.
///
/// \sa hkMxVectorf hkMxRealf
template <int M>
class hkMxSinglef
{
public:

    HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_MATH, hkMxSinglef<M>);

    /// The number of subvectors stored in this vector.
    ///
    /// When coding, this value can be retrieved using the class definition as well as from variable instances.
    /// Example: incrementing a loop counter: i += hkMxSinglef<M>::mxLength;.
    /// Example: declaring an array appropriate with same length as a vector: int array[svec_var.mxLength];
    enum { mxLength = M };

#ifndef HK_DISABLE_MATH_CONSTRUCTORS
    /// Default constructor. Does not initialize.
    HK_INLINE hkMxSinglef() {}

    /// Set self to broadcast \a v: aaaa aaaa aaaa aaaa
    HK_INLINE explicit hkMxSinglef(hkSimdFloat32Parameter v);
    /// Set self to replicate \a v: abcd abcd abcd abcd
    HK_INLINE explicit hkMxSinglef(hkVector4fParameter v);
#endif

    /// Copies all components from \a v. ( self = v )
    HK_INLINE void operator= ( hkMxSinglefParameter v );

    /// Get the replicated subvector: return abcd
    HK_INLINE const hkVector4f& getVector() const;

    /// Set the vector
    HK_INLINE void setVector(hkVector4fParameter r);
    HK_INLINE void setSimdReal(hkSimdFloat32Parameter r );

    /// Set to zero.
    HK_INLINE void setZero();

    template<int C> HK_INLINE void setConstant();


    hkMxSinglefStorage<M> m_single; ///< The replicated subvector.
};

#include <Common/Base/Math/Vector/Mx/hkMxSinglef.inl> 

// convenient shortcut
typedef hkMxSinglef<4> hk4xSinglef;

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
