// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
//HK_REFLECTION_PARSER_EXCLUDE_FILE

#pragma once

#define HK_MXFLOAT_MX_NOT_IMPLEMENTEDf static_assert(M==0, "MXR_NOT_IMPLEMENTEDf_FOR_THIS_VECTOR_LENGTH")

#define hkMxRealfParameter   const hkMxRealf<M>&

template <int M> class hkMxVectorf;
#include <Common/Base/Math/Vector/Mx/hkMxVectorf.h>
#include <Common/Base/Math/Vector/Mx/hkMxSinglef.h>
#include <Common/Base/Math/Vector/Mx/hkMxMaskf.h>

/// Long vector for vectorized computing (M scalars).
///
/// This represents M scalars stored SIMD-friendly. In this documentation we use abcd and following letters to
/// refer to one of the 4-component subscalars.
/// Example M=4: layout of the long vector: aaaa eeee iiii mmmm
///
/// The purpose of this vector is to implement efficient loop-unrolled algorithms without branching
/// to efficiently use the SIMD processing hardware capabilities.
///
/// \sa hkMxVectorf hkMxSinglef
template <int M>
class hkMxRealf
{
public:

    HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_MATH, hkMxRealf<M>);

    /// The number of SIMD-friendly scalars stored in this vector.
    ///
    /// When coding, this value can be retrieved using the class definition as well as from variable instances.
    /// Example: incrementing a loop counter: i += hkMxRealf<M>::mxLength;.
    /// Example: declaring an array appropriate with same length as a vector: int array[realvec_var.mxLength];
    enum { mxLength = M };

#ifndef HK_DISABLE_MATH_CONSTRUCTORS
    /// Default constructor. Does not initialize.
    HK_INLINE hkMxRealf() {}

    /// Set self to broadcast value \a v
    HK_INLINE explicit hkMxRealf(hkFloat32& v);

    /// Set self to broadcast value \a v
    HK_INLINE explicit hkMxRealf(hkSimdFloat32Parameter v);

    /// Set self to broadcast \a v.xyzw to x=aaaa y=eeee z=iiii w=mmmm
    /// \warning [M:1-4 only]
    HK_INLINE explicit hkMxRealf(hkVector4f_ v);
#endif

    /// Copies all components from \a v. ( self = v )
    HK_INLINE void operator= ( hkMxRealfParameter v );

    /// Set self to broadcast \a r: xxxx yyyy zzzz wwww
    HK_INLINE void setBroadcast( hkVector4f_ r );

    /// Set self to broadcast \a r: xxxx xxxx xxxx xxxx
    HK_INLINE void setBroadcast( hkSimdFloat32Parameter r );

    /// Read scalars contiguous from memory as aeim and convert to SIMD-friendly storage
    HK_INLINE void load(const hkFloat32* r);
    HK_INLINE void loadNotAligned(const hkFloat32* r);
    /// Convert from SIMD-friendly storage and store contiguous to memory \a rOut = aeim
    HK_INLINE void store(hkFloat32* rOut) const;
    HK_INLINE void storeNotAligned(hkFloat32* rOut) const;

    /// Set to a constant vector.
    template<int vectorConstant> HK_INLINE void setConstant();

    /// Read scalars non-contiguous from memory using addresses \a base + (m * byteAddressIncrement) and convert to SIMD-friendly storage
    template <hkUint32 byteAddressIncrement> HK_INLINE void gather(const hkFloat32* base);
    /// Read scalars non-linear indexed from memory using addresses \a base + ( \a indices[m] * byteAddressIncrement) and convert to SIMD-friendly storage
    template <hkUint32 byteAddressIncrement> HK_INLINE void gather(const hkFloat32* base, const hkUint16* indices);
    /// Read scalars non-linear indexed from memory using addresses \a base + ( \a indices[m] * byteAddressIncrement) and convert to SIMD-friendly storage
    template <hkUint32 byteAddressIncrement> HK_INLINE void gather(const hkFloat32* base, const hkInt32* indices);
    /// Read scalars non-linear from memory using addresses \a base[m] + byteAddressOffset and convert to SIMD-friendly storage
    template <hkUint32 byteAddressOffset>    HK_INLINE void gatherWithOffset(const void* base[M]);
    /// Read scalars non-contiguous from memory using addresses \a base + (m * byteAddressIncrement) and convert to SIMD-friendly storage
    template <hkUint32 byteAddressIncrement> HK_INLINE void gather(const hkHalf16* base);

    /// Convert from SIMD-friendly storage and write scalars non-contiguous to memory using addresses \a base + (m * byteAddressIncrement)
    template <hkUint32 byteAddressIncrement> HK_INLINE void scatter(hkFloat32* base) const;
    /// Convert from SIMD-friendly storage and write scalars non-linear indexed to memory using addresses \a base + ( \a indices[m] * byteAddressIncrement)
    template <hkUint32 byteAddressIncrement> HK_INLINE void scatter(hkFloat32* base, const hkUint16* indices) const;
    /// Convert from SIMD-friendly storage and write scalars non-linear indexed to memory using addresses \a base + ( \a indices[m] * byteAddressIncrement)
    template <hkUint32 byteAddressIncrement> HK_INLINE void scatter(hkFloat32* base, const hkInt32* indices) const;
    /// Convert from SIMD-friendly storage and write scalars non-linear to memory using addresses \a base[m] + byteAddressOffset
    template <hkUint32 byteAddressOffset>    HK_INLINE void scatterWithOffset(void* base[M]) const;


    // comparisons
    HK_INLINE void less(hkMxVectorfParameter v, hkMxMaskf<M>& mask) const;
    HK_INLINE void less(hkMxSinglefParameter v, hkMxMaskf<M>& mask) const;
    HK_INLINE void less(hkMxRealfParameter v, hkMxMaskf<M>& mask) const;
    HK_INLINE void lessEqual(hkMxVectorfParameter v, hkMxMaskf<M>& mask) const;
    HK_INLINE void lessEqual(hkMxSinglefParameter v, hkMxMaskf<M>& mask) const;
    HK_INLINE void lessEqual(hkMxRealfParameter v, hkMxMaskf<M>& mask) const;
    HK_INLINE void greater(hkMxVectorfParameter v, hkMxMaskf<M>& mask) const;
    HK_INLINE void greater(hkMxSinglefParameter v, hkMxMaskf<M>& mask) const;
    HK_INLINE void greater(hkMxRealfParameter v, hkMxMaskf<M>& mask) const;
    HK_INLINE void greaterEqual(hkMxVectorfParameter v, hkMxMaskf<M>& mask) const;
    HK_INLINE void greaterEqual(hkMxSinglefParameter v, hkMxMaskf<M>& mask) const;
    HK_INLINE void greaterEqual(hkMxRealfParameter v, hkMxMaskf<M>& mask) const;

    HK_INLINE void setSelect(hkMxMaskParameterf mask, hkMxRealfParameter trueValue, hkMxRealfParameter falseValue );
    HK_INLINE void setSelect(hkMxMaskParameterf mask, hkMxSinglefParameter trueValue, hkMxRealfParameter falseValue ); // bad interface !
    HK_INLINE void setSelect(hkMxMaskParameterf mask, hkMxRealfParameter trueValue, hkMxSinglefParameter falseValue ); // bad interface !

    // no operands
    HK_INLINE void sqrt(); // 23 bit, sqrt set 0
    template <hkMathAccuracyMode A, hkMathNegSqrtMode S> HK_INLINE void sqrt();


    // one operand
    HK_INLINE void add(hkMxRealfParameter r);
    HK_INLINE void sub(hkMxRealfParameter r);
    HK_INLINE void mul(hkMxRealfParameter r);
    HK_INLINE void div(hkMxRealfParameter r); // 23 bit, div 0 ignore
    template <hkMathAccuracyMode A, hkMathDivByZeroMode D> HK_INLINE void div(hkMxRealfParameter r);
    HK_INLINE void setNeg(hkMxRealfParameter r);

    HK_INLINE void setReciprocal(hkMxRealfParameter r); // 23 bit, div 0 ignore
    template <hkMathAccuracyMode A, hkMathDivByZeroMode D> HK_INLINE void setReciprocal(hkMxRealfParameter r);

    template <hkMathAccuracyMode A, hkMathNegSqrtMode S> HK_INLINE void setSqrtInverse(hkMxRealfParameter r);

    // Zero I-th scalar if the corresponding mask is set.
    HK_INLINE void zeroIfTrue(hkMxMaskParameterf mask);
    // Zero I-th scalar if the corresponding mask is not set.
    HK_INLINE void zeroIfFalse(hkMxMaskParameterf mask);

    // two operands
    HK_INLINE void setAdd(hkMxRealfParameter v0, hkMxRealfParameter v1);
    HK_INLINE void setSub(hkMxRealfParameter v0, hkMxRealfParameter v1);
    HK_INLINE void setMul(hkMxRealfParameter v0, hkMxRealfParameter v1);
    HK_INLINE void setDiv(hkMxRealfParameter v0, hkMxRealfParameter v1); // 23 bit, div 0 ignore
    template <hkMathAccuracyMode A, hkMathDivByZeroMode D> HK_INLINE void setDiv(hkMxRealfParameter v0, hkMxRealfParameter v1);
    HK_INLINE void setMax(hkMxRealfParameter v0, hkMxRealfParameter v1);
    HK_INLINE void setMin(hkMxRealfParameter v0, hkMxRealfParameter v1);

    // mixed operands
    template <int N> HK_INLINE void setDot(hkMxVectorfParameter v0, hkMxVectorfParameter v1);
    template <int N> HK_INLINE void setDot(hkMxSinglefParameter s, hkMxVectorfParameter v);
    HK_INLINE void setDot4xyz1(hkMxVectorfParameter v0, hkMxVectorfParameter v1);
    HK_INLINE void setDot4xyz1(hkMxSinglefParameter s, hkMxVectorfParameter v);

    /// Return the I-th scalar by broadcasting it to \a vOut = [i=0]aaaa [i=1]eeee [i=2]iiii [i=3]mmmm
    template <int I> HK_INLINE void getAsBroadcast(hkVector4f& vOut) const;
    /// Return the I-th scalar broadcasted as [i=0]aaaa [i=1]eeee [i=2]iiii [i=3]mmmm
    template <int I> HK_INLINE const hkVector4f getAsBroadcast() const;

    /// Return the I-th scalar in a SIMD-friendly way.
    template <int I> HK_ALWAYS_INLINE const hkSimdFloat32 getReal() const;
    /// Set the I-th subscalar to \a r.
    template <int I> HK_ALWAYS_INLINE void setReal(hkSimdFloat32Parameter r);

    /// Special store method to write to \a vOut = aeim.
    /// Excess components of \a vOut are undefined.
    /// \warning [M:1-4 only]
    HK_INLINE void storePacked(hkVector4f& vOut) const;



    hkMxRealfStorage<M> m_real; ///< The SIMD-friendly scalars.
};

#include <Common/Base/Math/Vector/Mx/hkMxRealf.inl> 

// convenient shortcut
typedef hkMxRealf<4>   hk4xRealf;

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
