// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
//HK_REFLECTION_PARSER_EXCLUDE_FILE

#pragma once

#define hkMxQuaternionfParameter const hkMxQuaternionf<M>&

#include <Common/Base/Math/Vector/Mx/hkMxVectorf.h>
#include <Common/Base/Math/Quaternion/hkQuaternionUtil.h>

/// Long vector for vectorized computing (M quaternions).
///
/// This represents M quaternions. In this documentation we use abcd and following letters to
/// refer to one of the 4-component subquaternions.
/// Example M=4: layout of the long vector: abcd efgh ijkl mnop
///
/// The purpose of this vector is to implement efficient loop-unrolled algorithms without branching
/// to efficiently use the SIMD processing hardware capabilities.
///
/// \sa hkMxVectorf
template <int M>
class hkMxQuaternionf : public hkMxVectorf<M>
{
public:

    HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_MATH, hkMxQuaternionf<M>);

    /// Set each subquaternion to the inverse of the corresponding subquaternion in \a p.
    HK_INLINE void setInverse(hkMxQuaternionfParameter p);

    /// Set each subquaternion to the multiply each subquaternion in \a p with the corresponding subquaternion in \a q.
    HK_INLINE void setMulQ(hkMxQuaternionfParameter p, hkMxQuaternionfParameter q);

    /// Set each subquaternion to the multiply each subquaternion in \a p with the corresponding inverse subquaternion in \a q.
    HK_INLINE void setMulInverseQ(hkMxQuaternionfParameter p, hkMxQuaternionfParameter q);

    /// Set each subquaternion to the multiply each inverse subquaternion in \a p with the corresponding subquaternion in \a q.
    HK_INLINE void setInverseMulQ(hkMxQuaternionfParameter p, hkMxQuaternionfParameter q);

    /// Return the I-th subquaternion. [i=0]abcd [i=1]efgh [i=2]ijkl [i=3]mnop
    template <int I> HK_INLINE const hkQuaternionf& getQuaternion() const;

    /// Read subquaternions non-contiguous from memory using addresses \a base + (m * byteAddressIncrement)
    template <hkUint32 byteAddressIncrement> HK_INLINE void gather(const hkQuaternionf* base);

    /// Write subquaternions non-contiguous to memory using addresses \a base + (m * byteAddressIncrement)
    template <hkUint32 byteAddressIncrement> HK_INLINE void scatter(hkQuaternionf* base) const;

    /// Convert subquaternions to rotations and write to non-contiguous to memory using addresses \a base + (m * byteAddressIncrement)
    template <hkUint32 byteAddressIncrement> HK_INLINE void convertAndScatter(hkRotationf* base) const;
};

#include <Common/Base/Math/Vector/Mx/hkMxQuaternionf.inl> 

// convenient shortcut
typedef hkMxQuaternionf<4>    hk4xQuaternionf;

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
