// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
//HK_REFLECTION_PARSER_EXCLUDE_FILE

#pragma once

#define hkMxMaskParameterd  const hkMxMaskd<M>&

#include <Common/Base/Math/Vector/Mx/hkMxVectord.h>

/// Long mask vector for vectorized computing (M masks).
///
/// This represents M masks for vector compares. Using this class is central for avoiding
/// branching instructions. The masks are employed by the select() methods of the data vectors.
///
/// The purpose of this mask vector is to implement efficient loop-unrolled algorithms without branching
/// to efficiently use the SIMD processing hardware capabilities.
///
/// \sa hkMxVectord hkMxReald
template <int M>
class hkMxMaskd
{
public:

    HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_MATH, hkMxMaskd<M>);

    /// The number of masks.
    enum { mxLength = M };

    typedef hkVector4ComparisonMask::Mask Mask; ///< The mask values.

    /// Set all masks to the template MASK argument.
    template <hkVector4ComparisonMask::Mask MASK> HK_INLINE void setAll();
    /// Set the I-th submask to \a a.
    template <int I> HK_INLINE void set( hkVector4dComparisonParameter a );
    /// Get the I-th submask.
    template <int I> HK_INLINE const hkVector4dComparison&  get() const;

    /// Set masks of self to the logical AND of respective masks in \a a and \a b.
    HK_INLINE void setAnd(hkMxMaskParameterd a, hkMxMaskParameterd b);
    /// Set masks of self to the logical OR of respective masks in \a a and \a b.
    HK_INLINE void setOr(hkMxMaskParameterd a, hkMxMaskParameterd b);

    /// Returns true if any bit in any mask in self is set.
    HK_INLINE hkBool32 anyIsSet() const;

    /// Logical AND of bits within each submask. Unused submasks are assumed zero.
    /// \a andOut = xyzw with x=a&b&c&d, y=e&f&g&h, z=i&j&k&l, w=m&n&o&p
    /// \warning [M:1-4 only]
    HK_INLINE void horizontalAnd4( hkVector4dComparison& andOut ) const;


    hkMxMaskdStorage<M> m_comp; ///< The masks.
};

#include <Common/Base/Math/Vector/Mx/hkMxMaskd.inl> 

// convenient shortcut
typedef hkMxMaskd<4>      hk4xMaskd;

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
