// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/Math/Vector/hkVector2.h>

namespace hkVector2Util
{
    //
    /// Returns if two edges (a1,a2) and (b1,b2) are intersecting
    //
    HK_EXPORT_COMMON hkBool HK_CALL edgesIntersect(const hkVector2d& a1, const hkVector2d& a2, const hkVector2d& b1, const hkVector2d& b2);
    HK_EXPORT_COMMON hkBool HK_CALL edgesIntersect(const hkVector2f& a1, const hkVector2f& a2, const hkVector2f& b1, const hkVector2f& b2);

    HK_EXPORT_COMMON void HK_CALL convexHullSimplePolyline(const hkArrayBase<hkVector2d>& polyline, hkArray<int>& indicesOut);
    HK_EXPORT_COMMON void HK_CALL convexHullSimplePolyline(const hkArrayBase<hkVector2f>& polyline, hkArray<int>& indicesOut);

    //
    /// Computes the convex hull of a planar set of points and returns the points
    //
    HK_EXPORT_COMMON void HK_CALL convexHullVertices(const hkArrayBase<hkVector2d>& points, hkArray<hkVector2d>& hullOut);
    HK_EXPORT_COMMON void HK_CALL convexHullVertices(const hkArrayBase<hkVector2f>& points, hkArray<hkVector2f>& hullOut);

    //
    /// Computes the convex hull of a planar set of points and returns the indices to the input array
    //
    HK_EXPORT_COMMON hkResult HK_CALL convexHullIndices(const hkArrayBase<hkVector2d>& points, hkArrayBase<int>& indicesOut);
    HK_EXPORT_COMMON hkResult HK_CALL convexHullIndices(const hkArrayBase<hkVector2f>& points, hkArrayBase<int>& indicesOut);

    //
    /// Computes the center and axes of the OBB of the points, and returns the area.
    /// The hkResult is used to indicate that all memory allocations succeeded.
    //
    HK_EXPORT_COMMON hkDouble64 HK_CALL computeObb(const hkArrayBase<hkVector2d>& points, hkVector2d& centerOut, hkVector2d& e0Out, hkVector2d& e1Out, hkResult& resOut);
    HK_EXPORT_COMMON hkFloat32 HK_CALL computeObb(const hkArrayBase<hkVector2f>& points, hkVector2f& centerOut, hkVector2f& e0Out, hkVector2f& e1Out, hkResult& resOut);

    //
    /// Helper to get the number of bytes allocated on stack for hull generation
    //
    template<typename TVector2>
    HK_INLINE int HK_CALL getStackSizeInBytesRequiredForConvexHullIndices(int inputPointsSize)
    {
        return inputPointsSize *
            (sizeof(TVector2) +     //hkLocalBuffer<TVector2> points( NPOINT );
                sizeof(int) +       // hkLocalBuffer<int> originalIndices( NPOINT );
                sizeof(TVector2)    // hkLocalArray<TVector2> pointsOut( NPOINT );
                );
    }
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
