// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

namespace hkPack
{
    // This class is used to define an int with a specified storage in bits.
    // It is useful with Pack and Unpack to pack/unpack values into
    // user-specified number of bits.
    // By design, it will allow you to construct from any size int but will
    // assert if the value is too big for the hkPackInt.
    // And it will not allow you to *assign* from an int who's value can't
    // be stored in the hkPackInt.
    // Eg.
    //  hkPackInt<4> i4 = 1; // this compiles because it uses ctor.
    //  hkPackInt<4> i4; i4 = 1; // this won't because it uses assignment and 1 will be an int32.
    template<int BITS>
    struct hkPackInt
    {
        HK_DECLARE_CLASS( hkPackInt, NewOpaque, Pod );

        hkUint64 m_value : BITS;
        HK_ALWAYS_INLINE static unsigned int numBits() { return BITS; }
        HK_ALWAYS_INLINE static hkPackInt maxValue() { return hkPackInt( hkBitmask64( BITS ) ); }
        HK_ALWAYS_INLINE static hkUint64 mask() { return hkBitmask64( BITS ); }

#define CHECK_CAST( fromBits, toBits ) \
    static_assert( toBits >= fromBits, "INVALID_ANY_INT_CAST" )
#define EXTRACT_VAL( i ) \
    ( hkUint64( i ) & mask() )

        HK_ALWAYS_INLINE hkPackInt() {}
        HK_ALWAYS_INLINE hkPackInt( hkInt8 i ) { operator=( hkUint64( i ) ); }
        HK_ALWAYS_INLINE hkPackInt( hkInt16 i ) { operator=( hkUint64( i ) ); }
        HK_ALWAYS_INLINE hkPackInt( hkInt32 i ) { operator=( hkUint64( i ) ); }
        HK_ALWAYS_INLINE hkPackInt( hkInt64 i ) { operator=( hkUint64( i ) ); }
        HK_ALWAYS_INLINE hkPackInt( hkUint8 i ) { operator=( hkUint64( i ) ); }
        HK_ALWAYS_INLINE hkPackInt( hkUint16 i ) { operator=( hkUint64( i ) ); }
        HK_ALWAYS_INLINE hkPackInt( hkUint32 i ) { operator=( hkUint64( i ) ); }
        HK_ALWAYS_INLINE hkPackInt( hkUint64 i ) { operator=( hkUint64( i ) ); }
        template <int OTHERBITS> HK_ALWAYS_INLINE hkPackInt( const hkPackInt<OTHERBITS>& i ) { operator=( hkUint64( i ) ); }
        HK_ALWAYS_INLINE operator bool() const { return m_value != 0; }
        HK_ALWAYS_INLINE operator hkInt8() const { CHECK_CAST( BITS, 8 ); return hkInt8( EXTRACT_VAL( m_value ) ); }
        HK_ALWAYS_INLINE operator hkUint8() const { CHECK_CAST( BITS, 8 ); return hkUint8( EXTRACT_VAL( m_value ) ); }
        HK_ALWAYS_INLINE operator hkInt16() const { CHECK_CAST( BITS, 16 ); return hkInt16( EXTRACT_VAL( m_value ) ); }
        HK_ALWAYS_INLINE operator hkUint16() const { CHECK_CAST( BITS, 16 ); return hkUint16( EXTRACT_VAL( m_value ) ); }
        HK_ALWAYS_INLINE operator hkInt32() const { CHECK_CAST( BITS, 32 ); return hkInt32( EXTRACT_VAL( m_value ) ); }
        HK_ALWAYS_INLINE operator hkUint32() const { CHECK_CAST( BITS, 32 ); return hkUint32( EXTRACT_VAL( m_value ) ); }
        HK_ALWAYS_INLINE operator hkInt64() const { return hkInt64( EXTRACT_VAL( m_value ) ); }
        HK_ALWAYS_INLINE operator hkUint64() const { return hkUint64( EXTRACT_VAL( m_value ) ); }
        HK_ALWAYS_INLINE hkPackInt operator =( bool val ) { operator=( hkUint64( val ) ); return *this; }
        HK_ALWAYS_INLINE hkPackInt operator =( hkInt8 val ) { CHECK_CAST( 8, BITS ); return operator=( hkUint64( val ) ); }
        HK_ALWAYS_INLINE hkPackInt operator =( hkUint8 val ) { CHECK_CAST( 8, BITS ); return operator=( hkUint64( val ) ); }
        HK_ALWAYS_INLINE hkPackInt operator =( hkInt16 val ) { CHECK_CAST( 16, BITS ); return operator=( hkUint64( val ) ); }
        HK_ALWAYS_INLINE hkPackInt operator =( hkUint16 val ) { CHECK_CAST( 16, BITS ); return operator=( hkUint64( val ) ); }
        HK_ALWAYS_INLINE hkPackInt operator =( hkInt32 val ) { CHECK_CAST( 32, BITS ); return operator=( hkUint64( val ) ); }
        HK_ALWAYS_INLINE hkPackInt operator =( hkUint32 val ) { CHECK_CAST( 32, BITS ); return operator=( hkUint64( val ) ); }
        HK_ALWAYS_INLINE hkPackInt operator =( hkInt64 val ) { m_value = hkUint64( val ); return operator=( hkUint64( val ) ); }
        HK_ALWAYS_INLINE hkPackInt operator =( hkUint64 val )
        {
            HK_ASSERT( 0x22441191, ( val & mask() ) == val, "i is too large" );
            setValueUnchecked( val );
            return *this;
        }
        HK_ALWAYS_INLINE void setValueUnchecked( hkUint64 val )
        {
            m_value = val;
        }
        template<int OTHERBITS> HK_ALWAYS_INLINE hkPackInt operator =( const hkPackInt<OTHERBITS>& val )
        {
            CHECK_CAST( OTHERBITS, BITS );
            m_value = val;
            return *this;
        }
        HK_ALWAYS_INLINE bool operator ==( bool val ) const { return operator==( hkUint64( val ) ); }
        HK_ALWAYS_INLINE bool operator ==( hkInt8 val ) const { return operator==( hkUint64( val ) ); }
        HK_ALWAYS_INLINE bool operator ==( hkUint8 val ) const { return operator==( hkUint64( val ) ); }
        HK_ALWAYS_INLINE bool operator ==( hkInt16 val ) const { return operator==( hkUint64( val ) ); }
        HK_ALWAYS_INLINE bool operator ==( hkUint16 val ) const { return operator==( hkUint64( val ) ); }
        HK_ALWAYS_INLINE bool operator ==( hkInt32 val ) const { return operator==( hkUint64( val ) ); }
        HK_ALWAYS_INLINE bool operator ==( hkUint32 val ) const { return operator==( hkUint64( val ) ); }
        HK_ALWAYS_INLINE bool operator ==( hkInt64 val ) const { return operator==( hkUint64( val ) ); }
        HK_ALWAYS_INLINE bool operator ==( hkUint64 val ) const { return m_value == val; }
        template<int OTHERBITS> HK_ALWAYS_INLINE bool operator==( const hkPackInt<OTHERBITS>& val ) const { return m_value == val.m_value; }
        HK_ALWAYS_INLINE bool operator !=( bool val ) const { return operator!=( hkUint64( val ) ); }
        HK_ALWAYS_INLINE bool operator !=( hkInt8 val ) const { return operator!=( hkUint64( val ) ); }
        HK_ALWAYS_INLINE bool operator !=( hkUint8 val ) const { return operator!=( hkUint64( val ) ); }
        HK_ALWAYS_INLINE bool operator !=( hkInt16 val ) const { return operator!=( hkUint64( val ) ); }
        HK_ALWAYS_INLINE bool operator !=( hkUint16 val ) const { return operator!=( hkUint64( val ) ); }
        HK_ALWAYS_INLINE bool operator !=( hkInt32 val ) const { return operator!=( hkUint64( val ) ); }
        HK_ALWAYS_INLINE bool operator !=( hkUint32 val ) const { return operator!=( hkUint64( val ) ); }
        HK_ALWAYS_INLINE bool operator !=( hkInt64 val ) const { return operator!=( hkUint64( val ) ); }
        HK_ALWAYS_INLINE bool operator !=( hkUint64 val ) const { return m_value != val; }
        template<int OTHERBITS> HK_ALWAYS_INLINE bool operator!=( const hkPackInt<OTHERBITS>& val ) const { return m_value != val.m_value; }

#undef CHECK_CAST
#undef EXTRACT_VAL
    };

#define DEFINE_PACK_INT_TYPE( BITS ) typedef hkPackInt<BITS> hkPackInt##BITS;
    DEFINE_PACK_INT_TYPE( 1 );
    DEFINE_PACK_INT_TYPE( 2 );
    DEFINE_PACK_INT_TYPE( 3 );
    DEFINE_PACK_INT_TYPE( 4 );
    DEFINE_PACK_INT_TYPE( 5 );
    DEFINE_PACK_INT_TYPE( 6 );
    DEFINE_PACK_INT_TYPE( 7 );
    DEFINE_PACK_INT_TYPE( 8 );
    DEFINE_PACK_INT_TYPE( 9 );
    DEFINE_PACK_INT_TYPE( 10 );
    DEFINE_PACK_INT_TYPE( 11 );
    DEFINE_PACK_INT_TYPE( 12 );
    DEFINE_PACK_INT_TYPE( 13 );
    DEFINE_PACK_INT_TYPE( 14 );
    DEFINE_PACK_INT_TYPE( 15 );
    DEFINE_PACK_INT_TYPE( 16 );
    DEFINE_PACK_INT_TYPE( 17 );
    DEFINE_PACK_INT_TYPE( 18 );
    DEFINE_PACK_INT_TYPE( 19 );
    DEFINE_PACK_INT_TYPE( 20 );
    DEFINE_PACK_INT_TYPE( 21 );
    DEFINE_PACK_INT_TYPE( 22 );
    DEFINE_PACK_INT_TYPE( 23 );
    DEFINE_PACK_INT_TYPE( 24 );
    DEFINE_PACK_INT_TYPE( 25 );
    DEFINE_PACK_INT_TYPE( 26 );
    DEFINE_PACK_INT_TYPE( 27 );
    DEFINE_PACK_INT_TYPE( 28 );
    DEFINE_PACK_INT_TYPE( 29 );
    DEFINE_PACK_INT_TYPE( 30 );
    DEFINE_PACK_INT_TYPE( 31 );
    DEFINE_PACK_INT_TYPE( 32 );
    DEFINE_PACK_INT_TYPE( 33 );
    DEFINE_PACK_INT_TYPE( 34 );
    DEFINE_PACK_INT_TYPE( 35 );
    DEFINE_PACK_INT_TYPE( 36 );
    DEFINE_PACK_INT_TYPE( 37 );
    DEFINE_PACK_INT_TYPE( 38 );
    DEFINE_PACK_INT_TYPE( 39 );
    DEFINE_PACK_INT_TYPE( 40 );
    DEFINE_PACK_INT_TYPE( 41 );
    DEFINE_PACK_INT_TYPE( 42 );
    DEFINE_PACK_INT_TYPE( 43 );
    DEFINE_PACK_INT_TYPE( 44 );
    DEFINE_PACK_INT_TYPE( 45 );
    DEFINE_PACK_INT_TYPE( 46 );
    DEFINE_PACK_INT_TYPE( 47 );
    DEFINE_PACK_INT_TYPE( 48 );
    DEFINE_PACK_INT_TYPE( 49 );
    DEFINE_PACK_INT_TYPE( 50 );
    DEFINE_PACK_INT_TYPE( 51 );
    DEFINE_PACK_INT_TYPE( 52 );
    DEFINE_PACK_INT_TYPE( 53 );
    DEFINE_PACK_INT_TYPE( 54 );
    DEFINE_PACK_INT_TYPE( 55 );
    DEFINE_PACK_INT_TYPE( 56 );
    DEFINE_PACK_INT_TYPE( 57 );
    DEFINE_PACK_INT_TYPE( 58 );
    DEFINE_PACK_INT_TYPE( 59 );
    DEFINE_PACK_INT_TYPE( 60 );
    DEFINE_PACK_INT_TYPE( 61 );
    DEFINE_PACK_INT_TYPE( 62 );
    DEFINE_PACK_INT_TYPE( 63 );
    DEFINE_PACK_INT_TYPE( 64 );
#undef DEFINE_PACK_INT_TYPE

    namespace Detail
    {
        //
        // BitSizeOf( ... )
        // Returns the total size of all parameters in bits.
        //
        template<typename Ret, typename Head>
        struct BitSizeOfImpl
        {
            static Ret value()
            {
                
                HK_ASSERT( 0x22441302, hkBitmask64( hkBitSizeOf( Ret ) ) >= hkBitSizeOf( Head ), "BIT_SIZE_OVERFLOW" );
                Ret r = Ret( hkBitSizeOf( Head ) );
                return r;
            }
        };
        template<typename Ret, int I>
        struct BitSizeOfImpl<Ret, hkPackInt<I>>
        {
            static Ret value()
            {
                
                HK_ASSERT( 0x22441303, hkBitmask64( hkBitSizeOf( Ret ) ) >= I, "BIT_SIZE_OVERFLOW" );
                Ret r = Ret( hkPackInt<I>::numBits() );
                return r;
            }
        };
    }

    template <typename Ret, typename Head>
    Ret BitSizeOf( const Head& head )
    {
        Ret r = Detail::BitSizeOfImpl<Ret, Head>::value();
        return r;
    }

#ifdef HK_VARIADIC_TEMPLATES
    template <typename Ret, typename Head, typename... Tail>
    Ret BitSizeOf( const Head& head, const Tail&... tail )
    {
        Ret sh = Detail::BitSizeOfImpl<Ret, Head>::value();
        Ret st = BitSizeOf<Ret>( tail... );
        Ret r = sh + st;
        return r;
    }
#else
    template <typename Ret, typename Head, typename T0>
    Ret BitSizeOf( const Head& head, const T0& tail0 )
    {
        Ret sh = Detail::BitSizeOfImpl<Ret, Head>::value();
        Ret st0 = Detail::BitSizeOfImpl<Ret, T0>::value();
        Ret r = sh + st0;
        return r;
    }
    template <typename Ret, typename Head, typename T0, typename T1>
    Ret BitSizeOf( const Head& head, const T0& tail0, const T1& tail1 )
    {
        Ret sh = Detail::BitSizeOfImpl<Ret, Head>::value();
        Ret st0 = Detail::BitSizeOfImpl<Ret, T0>::value();
        Ret st1 = Detail::BitSizeOfImpl<Ret, T1>::value();
        Ret r = sh + st0 + st1;
        return r;
    }
    template <typename Ret, typename Head, typename T0, typename T1, typename T2>
    Ret BitSizeOf( const Head& head, const T0& tail0, const T1& tail1, const T2& tail2 )
    {
        Ret sh = Detail::BitSizeOfImpl<Ret, Head>::value();
        Ret st0 = Detail::BitSizeOfImpl<Ret, T0>::value();
        Ret st1 = Detail::BitSizeOfImpl<Ret, T1>::value();
        Ret st2 = Detail::BitSizeOfImpl<Ret, T2>::value();
        Ret r = sh + st0 + st1 + st2;
        return r;
    }
    template <typename Ret, typename Head, typename T0, typename T1, typename T2, typename T3>
    Ret BitSizeOf( const Head& head, const T0& tail0, const T1& tail1, const T2& tail2, const T3& tail3 )
    {
        Ret sh = Detail::BitSizeOfImpl<Ret, Head>::value();
        Ret st0 = Detail::BitSizeOfImpl<Ret, T0>::value();
        Ret st1 = Detail::BitSizeOfImpl<Ret, T1>::value();
        Ret st2 = Detail::BitSizeOfImpl<Ret, T2>::value();
        Ret st3 = Detail::BitSizeOfImpl<Ret, T3>::value();
        Ret r = sh + st0 + st1 + st2 + st3;
        return r;
    }
#endif

    //
    // Pack( ... )
    // Packs the arguments from right to left and will assert on overflow.
    // hkPackInts are useful here, consider this example:
    //  hkUint64 packed = Pack( hkInt4( 2 ), bodyId.index(), hkInt1( true ) );
    //  hkInt4 aSmallInt;
    //  int bodyIdx;
    //  hkInt1 isTrue;
    //  Unpack( packed, aSmallInt, bodyIdx, isTrue );
    //

#ifdef HK_VARIADIC_TEMPLATES
    namespace Detail
    {
        template<typename Ret, typename Head, typename... Tail>
        struct PackImpl
        {
            static Ret shift( const Head& head, const Tail&... tail )
            {
                Ret by = BitSizeOf<Ret>( tail... );
                
                HK_ASSERT( 0x22441298, hkBitSizeOf( Ret ) >= ( BitSizeOf<Ret>( head ) + by ), "PACK_OVERFLOW" );
                Ret r = Ret( head ) << by;
                return r;
            }
        };
    }
    template <typename Ret, typename Head>
    Ret Pack( const Head& head )
    {
        
        HK_ASSERT( 0x22441299, hkBitSizeOf( Ret ) >= BitSizeOf<Ret>( head ), "PACK_OVERFLOW" );
        Ret r = Ret( head );
        return r;
    }
    template <typename Ret, typename Head, typename... Tail>
    Ret Pack( const Head& head, const Tail&... tail )
    {
        Ret ph = Detail::PackImpl<Ret, Head, Tail...>::shift( head, tail... );
        Ret pt = Pack<Ret>( tail... );
        Ret r = ph + pt;
        return r;
    }
#else
    namespace Detail
    {
        template<typename Ret, typename Head, typename T0 = void, typename T1 = void, typename T2 = void, typename T3 = void>
        struct PackImpl
        {
            static Ret shift( const Head& head, const T0& tail0, const T1& tail1, const T2& tail2, const T3& tail3 )
            {
                Ret by = BitSizeOf<Ret>( tail0 );
                by += BitSizeOf<Ret>( tail1 );
                by += BitSizeOf<Ret>( tail2 );
                by += BitSizeOf<Ret>( tail3 );
                Ret r = Ret( head ) << by;
                return r;
            }
        };
        template<typename Ret, typename Head>
        struct PackImpl<Ret, Head, void, void, void, void>
        {
            static Ret shift( const Head& head )
            {
                return Ret( head );
            }
        };
        template<typename Ret, typename Head, typename T0>
        struct PackImpl<Ret, Head, T0, void, void, void>
        {
            static Ret shift( const Head& head, const T0& tail0 )
            {
                Ret by = BitSizeOf<Ret>( tail0 );
                Ret r = Ret( head ) << by;
                return r;
            }
        };
        template<typename Ret, typename Head, typename T0, typename T1>
        struct PackImpl<Ret, Head, T0, T1, void, void>
        {
            static Ret shift( const Head& head, const T0& tail0, const T1& tail1 )
            {
                Ret by = BitSizeOf<Ret>( tail0 );
                by += BitSizeOf<Ret>( tail1 );
                Ret r = Ret( head ) << by;
                return r;
            }
        };
        template<typename Ret, typename Head, typename T0, typename T1, typename T2>
        struct PackImpl<Ret, Head, T0, T1, T2, void>
        {
            static Ret shift( const Head& head, const T0& tail0, const T1& tail1, const T2& tail2 )
            {
                Ret by = BitSizeOf<Ret>( tail0 );
                by += BitSizeOf<Ret>( tail1 );
                by += BitSizeOf<Ret>( tail2 );
                Ret r = Ret( head ) << by;
                return r;
            }
        };
    }
    template <typename Ret, typename Head>
    Ret Pack( const Head& head )
    {
        return Detail::PackImpl<Ret, Head>::shift( head );
    }
    template <typename Ret, typename Head, typename T0>
    Ret Pack( const Head& head, const T0& tail0 )
    {
        Ret ph = Detail::PackImpl<Ret, Head, T0>::shift( head, tail0 );
        Ret pt0 = Detail::PackImpl<Ret, T0>::shift( tail0 );
        Ret r = ph + pt0;
        return r;
    }
    template <typename Ret, typename Head, typename T0, typename T1>
    Ret Pack( const Head& head, const T0& tail0, const T1& tail1 )
    {
        Ret ph = Detail::PackImpl<Ret, Head, T0, T1>::shift( head, tail0, tail1 );
        Ret pt0 = Detail::PackImpl<Ret, T0, T1>::shift( tail0, tail1 );
        Ret pt1 = Detail::PackImpl<Ret, T1>::shift( tail1 );
        Ret r = ph + pt0 + pt1;
        return r;
    }
    template <typename Ret, typename Head, typename T0, typename T1, typename T2>
    Ret Pack( const Head& head, const T0& tail0, const T1& tail1, const T2& tail2 )
    {
        Ret ph = Detail::PackImpl<Ret, Head, T0, T1, T2>::shift( head, tail0, tail1, tail2 );
        Ret pt0 = Detail::PackImpl<Ret, T0, T1, T2>::shift( tail0, tail1, tail2 );
        Ret pt1 = Detail::PackImpl<Ret, T1, T2>::shift( tail1, tail2 );
        Ret pt2 = Detail::PackImpl<Ret, T2>::shift( tail2 );
        Ret r = ph + pt0 + pt1 + pt2;
        return r;
    }
    template <typename Ret, typename Head, typename T0, typename T1, typename T2, typename T3>
    Ret Pack( const Head& head, const T0& tail0, const T1& tail1, const T2& tail2, const T3& tail3 )
    {
        Ret ph = Detail::PackImpl<Ret, Head, T0, T1, T2, T3>::shift( head, tail0, tail1, tail2, tail3 );
        Ret pt0 = Detail::PackImpl<Ret, T0, T1, T2, T3>::shift( tail0, tail1, tail2, tail3 );
        Ret pt1 = Detail::PackImpl<Ret, T1, T2, T3>::shift( tail1, tail2, tail3 );
        Ret pt2 = Detail::PackImpl<Ret, T2, T3>::shift( tail2, tail3 );
        Ret pt3 = Detail::PackImpl<Ret, T3>::shift( tail3 );
        Ret r = ph + pt0 + pt1 + pt2 + pt3;
        return r;
    }
#endif

    //
    // See Pack for more information.
    //

#ifdef HK_VARIADIC_TEMPLATES
    namespace Detail
    {
        template<typename Pack, typename Head, typename... Tail>
        struct UnpackImpl
        {
            static void mask( const Pack& pack, Head& head, Tail&... tail )
            {
                Pack tailBits = BitSizeOf<Pack>( tail... );
                Pack headAndTailBits = ( BitSizeOf<Pack>( head ) + tailBits );
                
                HK_ASSERT( 0x22441300, BitSizeOf<Pack>( pack ) >= headAndTailBits, "PACK_OVERFLOW" );
                Pack mask = Pack( hkBitmask64( int( headAndTailBits ) ) );
                head = Head( ( pack & mask ) >> tailBits );
            }
        };
    }
    
    template <typename Pack, typename Head>
    void Unpack( const Pack& pack, Head& head )
    {
        
        HK_ASSERT( 0x22441301, BitSizeOf<Pack>( pack ) >= BitSizeOf<Pack>( head ), "PACK_OVERFLOW" );
        head = Head( pack );
    }
    template <typename Pack, int I>
    void Unpack( const Pack& pack, hkPackInt<I>& head )
    {
        
        HK_ASSERT( 0x22441301, BitSizeOf<Pack>( pack ) >= BitSizeOf<Pack>( head ), "PACK_OVERFLOW" );
        // This is an intentional clamp, avoid clamp assert in hkPackInt
        head.setValueUnchecked( hkUint64( pack ) );
    }
    template <typename Pack, typename Head, typename... Tail>
    void Unpack( const Pack& pack, Head& head, Tail&... tail )
    {
        Detail::UnpackImpl<Pack, Head, Tail...>::mask( pack, head, tail... );
        Unpack<Pack>( pack, tail... );
    }
#else
    namespace Detail
    {
        template<typename Pack, typename Head, typename T0 = void, typename T1 = void, typename T2 = void, typename T3 = void>
        struct UnpackImpl
        {
            static void mask( const Pack& pack, Head& head, T0& tail0, T1& tail1, T2& tail2, T3& tail3 )
            {
                Pack tailBits = BitSizeOf<Pack>( tail0, tail1, tail2, tail3 );
                Pack headAndTailBits = ( BitSizeOf<Pack>( head ) + tailBits );
                Pack mask = Pack( hkBitmask64( int( headAndTailBits ) ) );
                head = Head( ( pack & mask ) >> tailBits );
            }
        };
        template<typename Pack, typename Head>
        struct UnpackImpl<Pack, Head, void, void, void, void>
        {
            static void mask( const Pack& pack, Head& head )
            {
                Pack headAndTailBits = BitSizeOf<Pack>( head );
                Pack mask = Pack( hkBitmask64( int( headAndTailBits ) ) );
                head = Head( pack & mask );
            }
        };
        template<typename Pack, typename Head, typename T0>
        struct UnpackImpl<Pack, Head, T0, void, void, void>
        {
            static void mask( const Pack& pack, Head& head, T0& tail0 )
            {
                Pack tailBits = BitSizeOf<Pack>( tail0 );
                Pack headAndTailBits = ( BitSizeOf<Pack>( head ) + tailBits );
                Pack mask = Pack( hkBitmask64( int( headAndTailBits ) ) );
                head = Head( ( pack & mask ) >> tailBits );
            }
        };
        template<typename Pack, typename Head, typename T0, typename T1>
        struct UnpackImpl<Pack, Head, T0, T1, void, void>
        {
            static void mask( const Pack& pack, Head& head, T0& tail0, T1& tail1 )
            {
                Pack tailBits = BitSizeOf<Pack>( tail0, tail1 );
                Pack headAndTailBits = ( BitSizeOf<Pack>( head ) + tailBits );
                Pack mask = Pack( hkBitmask64( int( headAndTailBits ) ) );
                head = Head( ( pack & mask ) >> tailBits );
            }
        };
        template<typename Pack, typename Head, typename T0, typename T1, typename T2>
        struct UnpackImpl<Pack, Head, T0, T1, T2, void>
        {
            static void mask( const Pack& pack, Head& head, T0& tail0, T1& tail1, T2& tail2 )
            {
                Pack tailBits = BitSizeOf<Pack>( tail0, tail1, tail2 );
                Pack headAndTailBits = ( BitSizeOf<Pack>( head ) + tailBits );
                Pack mask = Pack( hkBitmask64( int( headAndTailBits ) ) );
                head = Head( ( pack & mask ) >> tailBits );
            }
        };
    }
    template <typename Pack, typename Head>
    void Unpack( const Pack& pack, Head& head )
    {
        Detail::UnpackImpl<Pack, Head>::mask( pack, head );
    }
    template <typename Pack, typename Head, typename T0>
    void Unpack( const Pack& pack, Head& head, T0& tail0 )
    {
        Detail::UnpackImpl<Pack, Head, T0>::mask( pack, head, tail0 );
        Detail::UnpackImpl<Pack, T0>::mask( pack, tail0 );
    }
    template <typename Pack, typename Head, typename T0, typename T1>
    void Unpack( const Pack& pack, Head& head, T0& tail0, T1& tail1 )
    {
        Detail::UnpackImpl<Pack, Head, T0, T1>::mask( pack, head, tail0, tail1 );
        Detail::UnpackImpl<Pack, T0, T1>::mask( pack, tail0, tail1 );
        Detail::UnpackImpl<Pack, T1>::mask( pack, tail1 );
    }
    template <typename Pack, typename Head, typename T0, typename T1, typename T2>
    void Unpack( const Pack& pack, Head& head, T0& tail0, T1& tail1, T2& tail2 )
    {
        Detail::UnpackImpl<Pack, Head, T0, T1, T2>::mask( pack, head, tail0, tail1, tail2 );
        Detail::UnpackImpl<Pack, T0, T1, T2>::mask( pack, tail0, tail1, tail2 );
        Detail::UnpackImpl<Pack, T1, T2>::mask( pack, tail1, tail2 );
        Detail::UnpackImpl<Pack, T2>::mask( pack, tail2 );
    }
    template <typename Pack, typename Head, typename T0, typename T1, typename T2, typename T3>
    void Unpack( const Pack& pack, Head& head, T0& tail0, T1& tail1, T2& tail2, T3& tail3 )
    {
        Detail::UnpackImpl<Pack, Head, T0, T1, T2, T3>::mask( pack, head, tail0, tail1, tail2, tail3 );
        Detail::UnpackImpl<Pack, T0, T1, T2, T3>::mask( pack, tail0, tail1, tail2, tail3 );
        Detail::UnpackImpl<Pack, T1, T2, T3>::mask( pack, tail1, tail2, tail3 );
        Detail::UnpackImpl<Pack, T2, T3>::mask( pack, tail2, tail3 );
        Detail::UnpackImpl<Pack, T3>::mask( pack, tail3 );
    }
#endif

}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
