// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

template <typename FT>
hkConvertCSImpl<FT>::hkConvertCSImpl(ConversionType type)
{
    setConversionType(type);
}

template <typename FT>
void hkConvertCSImpl<FT>::setConversionType (ConversionType type)
{
    typename hkFloatTypes<FT>::Rotation rotation;
    typename hkFloatTypes<FT>::Vector c0 = hkFloatTypes<FT>::Vector::template getConstant<HK_QUADREAL_1000>();
    typename hkFloatTypes<FT>::Vector c1 = hkFloatTypes<FT>::Vector::template getConstant<HK_QUADREAL_0100>();
    typename hkFloatTypes<FT>::Vector c2 = hkFloatTypes<FT>::Vector::template getConstant<HK_QUADREAL_0010>();

    switch (type)
    {
    case CT_IDENTITY:
        {
            // Do nothing
            break;
        }
    case CT_FLIP_X:
        {
            c0.template setNeg<4>(c0);
            break;
        }
    case CT_FLIP_Y:
        {
            c1.template setNeg<4>(c1);
            break;
        }
    case CT_FLIP_Z:
        {
            c2.template setNeg<4>(c2);
            break;
        }
    case CT_SWITCH_YZ:
        {
            c1 = c2;
            c2 = hkFloatTypes<FT>::Vector::template getConstant<HK_QUADREAL_0100>();
            break;
        }
    default:
        HK_ASSERT(0x74224073, 0, "Unknown Coordinate System Conversion Type");
        return;
    }
    rotation.setCols(c0,c1,c2);

    setConversionRotation(rotation);
}

template <typename FT>
void hkConvertCSImpl<FT>::setConversionRotation (const typename hkFloatTypes<FT>::Rotation& rotation)
{
    m_conversionRotation = rotation;

    // We calculate the determinant
    typename hkFloatTypes<FT>::Vector r0;
    r0.setCross(rotation.template getColumn<1>(), rotation.template getColumn<2>());
    const typename hkFloatTypes<FT>::Scalar determinant = rotation.template getColumn<0>().template dot<3>(r0);

    HK_ASSERT(0x2e6d8741, hkMath::fabs(hkMath::fabs(determinant.getReal()) -1) < typename hkFloatTypes<FT>::Float(1e-2f), "Matrix (rotation) for conversion has scale!");

    // If determinant is (close to) -1, we are doing a handedness conversion
    typename hkFloatTypes<FT>::Scalar absDet;
    absDet.setAbs(determinant + hkFloatTypes<FT>::Scalar::template getConstant<HK_QUADREAL_1>());
    m_flippingC = absDet.less( hkFloatTypes<FT>::Scalar::fromFloat(typename hkFloatTypes<FT>::Float(1e-2f)) );
    m_flipping  = m_flippingC.anyIsSet();
}

template <typename FT>
void hkConvertCSImpl<FT>::convertVector (typename hkFloatTypes<FT>::Vector& vectorInOut) const
{
    vectorInOut._setRotatedDir(m_conversionRotation, vectorInOut);
}

template <typename FT>
void hkConvertCSImpl<FT>::convertQuaternion (typename hkFloatTypes<FT>::Quaternion& quaternionInOut) const
{
    // First we transform the axis of rotation
    typename hkFloatTypes<FT>::Vector imag;
    imag._setRotatedDir(m_conversionRotation, quaternionInOut.getImag());

    // Second, if the transformation is a "flipping" one (one that changes handedness) we also flip the sign
    typename hkFloatTypes<FT>::Scalar realPart;
    realPart.setFlipSign(quaternionInOut.getRealPart(), m_flippingC);

    quaternionInOut.m_vec.setXYZ_W(imag,realPart);
}

template <typename FT>
void hkConvertCSImpl<FT>::convertRotation (typename hkFloatTypes<FT>::Rotation& rotationInOut) const
{
    rotationInOut.changeBasis(m_conversionRotation);
}

template <typename FT>
void hkConvertCSImpl<FT>::convertTransform (typename hkFloatTypes<FT>::Transform& transformInOut) const
{
    convertRotation(transformInOut.getRotation());

    typename hkFloatTypes<FT>::Vector t = transformInOut.getTranslation();
    convertVector(t);
    transformInOut.setTranslation(t);
}

template <typename FT>
void hkConvertCSImpl<FT>::convertQTransform (typename hkFloatTypes<FT>::QTransform& transformInOut) const
{
    typename hkFloatTypes<FT>::Quaternion r = transformInOut.getRotation();
    convertQuaternion(r);
    transformInOut.setRotation(r);

    typename hkFloatTypes<FT>::Vector t = transformInOut.getTranslation();
    convertVector(t);
    transformInOut.setTranslation(t);
}

template <typename FT>
void hkConvertCSImpl<FT>::convertQsTransform (typename hkFloatTypes<FT>::QsTransform& transformInOut) const
{
    typename hkFloatTypes<FT>::Quaternion r = transformInOut.getRotation();
    convertQuaternion(r);
    transformInOut.setRotation(r);

    typename hkFloatTypes<FT>::Vector t = transformInOut.getTranslation();
    convertVector(t);
    transformInOut.setTranslation(t);

    // no need to change the scale
}


template <typename FT>
void hkConvertCSImpl<FT>::convertRotationAngle (typename hkFloatTypes<FT>::Float& angle) const
{
    if (m_flipping)
    {
        angle = -angle;
    }
}

template <typename FT>
void hkConvertCSImpl<FT>::convertMinMaxAngles (typename hkFloatTypes<FT>::Float& minAngle, typename hkFloatTypes<FT>::Float& maxAngle) const
{
    convertRotationAngle(minAngle);
    convertRotationAngle(maxAngle);
    if (minAngle>maxAngle)
    {
        hkMath::swap(minAngle, maxAngle);
    }
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
