// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

/// A 3x3 symmetric matrix stored as [m00, m11, m22] [m01, m12, m20], i.e. as the diagonal and off-diagonal vectors.
template <typename FT>
class hkSymmetricMatrix3Impl
{
public:

    typedef hkSymmetricMatrix3Impl<FT> ThisType;
    HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_MATH, ThisType);

public:

    /// Sets this = scale * mtx
    HK_INLINE void setMul(typename hkFloatTypes<FT>::Scalar_ scale, const ThisType& mtx);

    /// Sets this *= scale
    HK_INLINE void mul(typename hkFloatTypes<FT>::Scalar_ scale);

    /// Sets this = ta + tb
    HK_INLINE void setAdd(const ThisType& ta, const ThisType& tb);

    /// Sets this += ta
    HK_INLINE void add(const ThisType& ta);

    /// Sets this = ta - tb
    HK_INLINE void setSub(const ThisType& ta, const ThisType& tb);

    /// Sets this -= ta
    HK_INLINE void sub(const ThisType& ta);

    /// Sets this -= u * ta
    HK_INLINE void subMul(typename hkFloatTypes<FT>::Scalar_ u, const ThisType& ta);

    /// Sets this += Diag(a), where Diag(a) is a diagonal matrix with diagonal elements a.
    HK_INLINE void addDiag(typename hkFloatTypes<FT>::Vec4_ diagA);
    HK_INLINE void addDiag(typename hkFloatTypes<FT>::Scalar_ diagA);

    /// Sets this tensor from the given matrix m. The matrix is assumed to be symmetric
    HK_INLINE void setFromSymmetricMatrix(const typename hkFloatTypes<FT>::Matrix3& m);

    /// Gets the 3x3 matrix equivalent to this tensor
    HK_INLINE void getMatrix(typename hkFloatTypes<FT>::Matrix3& m) const;

    /// Sets this = Diagonal(v)
    HK_INLINE void setDiagonal(typename hkFloatTypes<FT>::Vec4_ v);
    HK_INLINE void setDiagonal(typename hkFloatTypes<FT>::Scalar_ v);

    /// Sets all entries to zero
    HK_INLINE void setZero();

    /// Sets this = min(ta, tb) component-wise.
    HK_INLINE void setMin(const ThisType& ta, const ThisType& tb);

public:

    typename hkFloatTypes<FT>::Vector m_diag;       ///< Diagonal elements, i.e. [m00, m11, m22]
    typename hkFloatTypes<FT>::Vector m_offDiag;    ///< Off-diagonal elements, i.e. [m01, m12, m20]
};

#include <Common/Base/Math/SymmetricMatrix/hkSymmetricMatrix3.inl>

# if defined(HK_REAL_IS_DOUBLE)
    typedef hkSymmetricMatrix3d hkSymmetricMatrix3;
#else
    typedef hkSymmetricMatrix3f hkSymmetricMatrix3;
#endif

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
