// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

HK_ALWAYS_INLINE hkRadians::hkRadians(hkReal radians)
    : m_radians(radians)
{
}

HK_ALWAYS_INLINE hkRadians::operator hkReal () const
{
    return m_radians;
}

HK_INLINE hkReal hkRadians::getDegrees() const
{
    return m_radians * HK_REAL_RAD_TO_DEG;
}

HK_INLINE void hkRadians::setDegrees(hkReal degrees)
{
    m_radians = degrees * HK_REAL_DEG_TO_RAD;
}

HK_ALWAYS_INLINE hkRadians hkRadians::operator + (hkRadians b) const
{
    return hkRadians(m_radians + b.m_radians);
}

HK_ALWAYS_INLINE hkRadians hkRadians::operator - (hkRadians b) const
{
    return hkRadians(m_radians - b.m_radians);
}

HK_ALWAYS_INLINE hkRadians hkRadians::operator * (hkReal b) const
{
    return hkRadians(m_radians * b);
}

HK_ALWAYS_INLINE hkRadians hkRadians::operator / (hkReal b) const
{
    return hkRadians(m_radians / b);
}

HK_ALWAYS_INLINE hkRadians& hkRadians::operator += (hkRadians b)
{
    m_radians += b.m_radians;
    return *this;
}

HK_ALWAYS_INLINE hkRadians& hkRadians::operator -= (hkRadians b)
{
    m_radians -= b.m_radians;
    return *this;
}

HK_ALWAYS_INLINE hkRadians& hkRadians::operator *= (hkReal b)
{
    m_radians *= b;
    return *this;
}

HK_ALWAYS_INLINE hkRadians& hkRadians::operator /= (hkReal b)
{
    m_radians /= b;
    return *this;
}

HK_ALWAYS_INLINE bool hkRadians::operator==(const hkRadians& rhs) const
{
    return m_radians == rhs.m_radians;
}

HK_ALWAYS_INLINE bool hkRadians::operator!=(const hkRadians& rhs) const
{
    return m_radians != rhs.m_radians;
}

HK_ALWAYS_INLINE bool hkRadians::operator<(const hkRadians& rhs) const
{
    return m_radians < rhs.m_radians;
}

HK_ALWAYS_INLINE bool hkRadians::operator>(const hkRadians& rhs) const
{
    return m_radians > rhs.m_radians;
}

HK_ALWAYS_INLINE hkRadians hkRadians::operator-() const
{
    return hkRadians(-m_radians);
}

HK_ALWAYS_INLINE hkRadians hkRadians::fromDegrees(hkReal degrees)
{
    return hkRadians(degrees * HK_REAL_DEG_TO_RAD);
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
