// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

class HK_EXPORT_COMMON hkRadians
{
public:
    HK_DECLARE_CLASS(hkRadians, New, Reflect, Pod);

    HK_ALWAYS_INLINE hkRadians() { }
    HK_ALWAYS_INLINE hkRadians(hkReal radians);

    HK_ALWAYS_INLINE operator hkReal () const;

    HK_INLINE hkReal getDegrees() const;
    HK_INLINE void setDegrees(hkReal degrees);

    HK_ALWAYS_INLINE hkRadians operator + (hkRadians b) const;
    HK_ALWAYS_INLINE hkRadians operator - (hkRadians b) const;
    HK_ALWAYS_INLINE hkRadians operator * (hkReal b) const;
    HK_ALWAYS_INLINE hkRadians operator / (hkReal b) const;

    HK_ALWAYS_INLINE hkRadians& operator += (hkRadians b);
    HK_ALWAYS_INLINE hkRadians& operator -= (hkRadians b);
    HK_ALWAYS_INLINE hkRadians& operator *= (hkReal b);
    HK_ALWAYS_INLINE hkRadians& operator /= (hkReal b);

    HK_ALWAYS_INLINE bool operator == (const hkRadians& rhs) const;
    HK_ALWAYS_INLINE bool operator != (const hkRadians& rhs) const;

    // Simple < check for sorting values, no wrap around is done
    HK_ALWAYS_INLINE bool operator < (const hkRadians& rhs) const;
    // Simple < check for sorting values, no wrap around is done
    HK_ALWAYS_INLINE bool operator > (const hkRadians& rhs) const;

    HK_ALWAYS_INLINE hkRadians operator - () const;

    HK_ALWAYS_INLINE static hkRadians fromDegrees (hkReal degrees);

private:
    hkReal m_radians;
};

#include <Common/Base/Math/Radians/hkRadians.inl>

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
