// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

// construction

HK_INLINE const hkVector4f& hkQuaternionf::getImag() const
{
    return m_vec;
}

HK_INLINE void hkQuaternionf::setImag(hkVector4fParameter i)
{
    m_vec.setXYZ(i);
}


HK_INLINE hkFloat32 hkQuaternionf::getReal() const
{
    return m_vec(3);
}

HK_INLINE void hkQuaternionf::setReal(hkFloat32 r)
{
    m_vec(3) = r;
}

HK_INLINE const hkSimdFloat32 hkQuaternionf::getRealPart() const
{
    return m_vec.getComponent<3>();
}

HK_INLINE void hkQuaternionf::setRealPart(hkSimdFloat32Parameter r)
{
    m_vec.setComponent<3>(r);
}

#ifndef HK_DISABLE_MATH_CONSTRUCTORS
HK_INLINE hkQuaternionf::hkQuaternionf(const hkRotationf& r)
{
    set(r);
}

HK_INLINE hkQuaternionf::hkQuaternionf(hkFloat32 x, hkFloat32 y, hkFloat32 z, hkFloat32 w)
{
    set(x,y,z,w);
}

HK_INLINE hkQuaternionf::hkQuaternionf(hkSimdFloat32Parameter x, hkSimdFloat32Parameter y, hkSimdFloat32Parameter z, hkSimdFloat32Parameter w)
{
    set(x,y,z,w);
}

HK_INLINE hkQuaternionf::hkQuaternionf(hkVector4fParameter axis, hkFloat32 angle)
{
    setAxisAngle(axis,angle);
}
#endif

HK_INLINE void hkQuaternionf::operator= (const hkQuaternionf& q)
{
    m_vec = q.m_vec;
}

HK_INLINE void hkQuaternionf::set(hkFloat32 x, hkFloat32 y, hkFloat32 z, hkFloat32 w)
{
    m_vec.set(x,y,z,w);
    HK_MATH_ASSERT(0x1adaad0e,  isOk(), "hkQuaternionf components were not normalized." );
}

HK_INLINE void hkQuaternionf::set(hkSimdFloat32Parameter x, hkSimdFloat32Parameter y, hkSimdFloat32Parameter z, hkSimdFloat32Parameter w)
{
    m_vec.set(x,y,z,w);
    HK_MATH_ASSERT(0x1adaad0e,  isOk(), "hkQuaternionf components were not normalized." );
}

HK_INLINE void hkQuaternionf::setIdentity()
{
    m_vec = hkVector4f::getConstant<HK_QUADREAL_0001>();
}

HK_INLINE /*static*/ const hkQuaternionf& HK_CALL hkQuaternionf::getIdentity()
{
    union { const hkQuadFloat32* r; const hkQuaternionf* q; } r2q;
    r2q.r = g_vectorfConstants + HK_QUADREAL_0001;
    return *r2q.q;
}

HK_INLINE void hkQuaternionf::setMul(hkSimdFloat32Parameter r, hkQuaternionfParameter q)
{
    m_vec.setMul(q.m_vec, r);
}

HK_INLINE void hkQuaternionf::addMul(hkSimdFloat32Parameter r, hkQuaternionfParameter q)
{
    m_vec.addMul(r,q.m_vec);
}

HK_INLINE void hkQuaternionf::setMul(hkQuaternionfParameter q0, hkQuaternionfParameter q1)
{
    const hkVector4f q0Imag = q0.getImag();
    const hkVector4f q1Imag = q1.getImag();
    const hkSimdFloat32 q0Real = q0.getRealPart();
    const hkSimdFloat32 q1Real = q1.getRealPart();

    hkVector4f vec;
    vec.setCross(q0Imag, q1Imag);
    vec.addMul(q0Real, q1Imag);
    vec.addMul(q1Real, q0Imag);
    const hkSimdFloat32 w = (q0Real * q1Real) - q0Imag.dot<3>(q1Imag);
    m_vec.setXYZ_W(vec, w);
}


HK_INLINE void hkQuaternionf::mul(hkQuaternionfParameter q)
{
    const hkVector4f thisImag = getImag();
    const hkVector4f qImag = q.getImag();
    const hkSimdFloat32 thisReal = getRealPart();
    const hkSimdFloat32 qReal = q.getRealPart();

    hkVector4f vec;
    vec.setCross(thisImag, qImag);
    vec.addMul(thisReal, qImag);
    vec.addMul(qReal, thisImag);
    const hkSimdFloat32 w = (thisReal * qReal) - thisImag.dot<3>(qImag);
    m_vec.setXYZ_W(vec, w);
}

HK_INLINE void hkQuaternionf::setMulInverse(hkQuaternionfParameter q0, hkQuaternionfParameter q1)
{
    const hkVector4f q0Imag = q0.getImag();
    const hkVector4f q1Imag = q1.getImag();

    hkVector4f xyz;
    xyz.setCross(q1Imag, q0Imag);
    xyz.subMul(q0.getRealPart(), q1Imag);
    xyz.addMul(q1.getRealPart(), q0Imag);
    const hkSimdFloat32 w = q0Imag.dot<4>(q1Imag);
    m_vec.setXYZ_W(xyz, w);
}

HK_INLINE void hkQuaternionf::setInverseMul(hkQuaternionfParameter q0, hkQuaternionfParameter q1)
{
    const hkVector4f q0Imag = q0.getImag();
    const hkVector4f q1Imag = q1.getImag();

    hkVector4f xyz;
    xyz.setCross(q1Imag, q0Imag);
    xyz.addMul(q0.getRealPart(), q1Imag);
    xyz.subMul(q1.getRealPart(), q0Imag);
    const hkSimdFloat32 w = q0Imag.dot<4>(q1Imag);
    m_vec.setXYZ_W(xyz,w);
}

HK_INLINE void hkQuaternionf::estimateAngleTo(hkQuaternionfParameter to, hkVector4f& angleOut) const
{
    const hkVector4f fromImag = getImag();
    const hkVector4f toImag = to.getImag();

    hkVector4f angle;
    angle.setCross(fromImag, toImag);
    angle.subMul(to.getRealPart(), fromImag);
    angle.addMul(   getRealPart(), toImag);
    angle.add(angle);
    angleOut.setFlipSign( angle, toImag.dot<4>(fromImag) );
}


HK_INLINE void hkQuaternionf::setInverse( hkQuaternionfParameter q )
{
    m_vec.setNeg<3>( q.getImag() );
}

HK_INLINE const hkFloat32& hkQuaternionf::operator()(int i) const
{
    return m_vec(i);
}

template <int I>
HK_INLINE const hkSimdFloat32 hkQuaternionf::getComponent() const
{
    return m_vec.getComponent<I>(); // has asserts
}

HK_INLINE hkFloat32 hkQuaternionf::getAngle() const
{
    return getAngleSr().getReal();
}

HK_INLINE hkBool32 hkQuaternionf::hasValidAxis() const
{
    return m_vec.lengthSquared<3>().isGreater(hkSimdFloat32::getConstant<HK_QUADREAL_EPS_SQRD>());
}

HK_INLINE void hkQuaternionf::getAxis(hkVector4f &axisOut) const
{
    hkVector4f axisTmp = m_vec;

    HK_MATH_ASSERT(0x266e2bd7, hasValidAxis(), "Cannot extract axis from a Quaternion representing (within numerical tolerance) the Identity rotation (or Quaternion may not be normalized).");
    axisTmp.normalize<3>();

#if (HK_CONFIG_SIMD == HK_CONFIG_SIMD_ENABLED)
    const hkVector4fComparison wLessZero = m_vec.getComponent<3>().lessZero();
    axisOut.setFlipSign(axisTmp, wLessZero);
#else
    if(m_vec(3) < hkFloat32(0))
    {
        axisOut.setNeg<4>(axisTmp);
    }
    else
    {
        axisOut = axisTmp;
    }
#endif
}

//
//  Sets the quaternion to the given quaternion, eventually transforming it so they are in the same hemisphere

HK_INLINE void hkQuaternionf::setClosest(hkQuaternionfParameter q, hkQuaternionfParameter qReference)
{
    m_vec.setFlipSign(q.m_vec, qReference.m_vec.dot<4>(q.m_vec));
}

template <hkMathAccuracyMode A, hkMathNegSqrtMode S>
HK_INLINE void hkQuaternionf::normalize()
{
    m_vec.normalize<4,A,S>();
}

HK_INLINE void hkQuaternionf::normalize()
{
    m_vec.normalize<4,HK_ACC_MID,HK_SQRT_IGNORE>();
}


template <hkMathAccuracyMode A, hkMathNegSqrtMode S>
HK_INLINE void hkQuaternionf::setAndNormalize(const hkRotationf& r)
{
    set(r);
    normalize<A, S>();
    HK_MATH_ASSERT(0x70dc41cc, isOk(), "hkRotationf used for hkQuaternionf construction is invalid.");
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
