// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#ifndef HK_MATH_MATH_H
#   error Please include Common/Base/hkBase.h instead of this file.
#endif

class hkQsTranformFInverse;

    /// An hkQTransformf represents a T*R transformation where translation is
    /// represented with a vector4 and rotation is represented with a quaternion.
    /// When applied to a point (hkVector4f::setTransformedPos()), the point is first rotated and
    /// then translated.
class hkQTransformf
{
public:

    HK_DECLARE_CLASS(hkQTransformf, New, Pod);
    HK_DETAIL_DECLARE_REFLECT_EXPORT(hkQTransformf, HK_EXPORT_COMMON);
    HK_RECORD_ATTR(hk::Default({ 0, 0, 0, 1 }, { 0, 0, 0, 0 }));
    typedef hkAlignedQuad<float> ReflectDefaultType[2];

    

    /// Default constructor - all elements are uninitialized.
    HK_INLINE hkQTransformf() { }

    /// Creates a new hkQTransformf using the rotation quaternion q and translation t.
    HK_INLINE hkQTransformf(hkQuaternionfParameter q, hkVector4f_ t);

    /// Copy constructor
    HK_INLINE hkQTransformf(const hkQTransformf& qt);

    /// Sets the hkQTransformf's values using the rotation quaternion q and translation t.
    HK_INLINE void set(hkQuaternionfParameter q, hkVector4f_ t);

    /// Sets the hkQTransformf's values from a hkTransformf.
    HK_INLINE void set(const hkTransformf& otherTransform);

    /// Sets this hkQTransformf to be the identity transform.
    HK_INLINE void setIdentity();

    /// Sets this hkQTransformf to zero
    HK_INLINE void setZero();

    /// Sets this += qa. The rotations are added as vectors, no attempt is made to re-normalize the quaternion.
    HK_INLINE void add(const hkQTransformf& qa);

    /// Returns a global identity transform.
    HK_INLINE static const hkQTransformf& HK_CALL getIdentity();

    /// Gets the translation component.
    HK_INLINE const hkVector4f& getTranslation() const;

    /// Sets the translation component.
    HK_INLINE void setTranslation(hkVector4f_ t);

    /// Gets the rotation component.
    HK_INLINE const hkQuaternionf& getRotation() const;

    /// Sets the rotation component (using a hkQuaternionf).
    HK_INLINE void setRotation(hkQuaternionfParameter q);

    /// Sets the rotation component (using a hkRotationf).
    HK_INLINE void setRotation(const hkRotationf& rotation);

    /// Sets this transform to be the inverse of the given transform qt.
    HK_EXPORT_COMMON void setInverse(const hkQTransformf& qt);

    /// Sets this transform to be the inverse of the given transform qt.
    HK_INLINE void _setInverse(const hkQTransformf& qt);

    /// Sets this transform to be the product of qt1 and qt2. (this = qt1 * qt2)
    HK_EXPORT_COMMON void setMul(const hkQTransformf& qt1, const hkQTransformf& qt2) HK_ATTR(hk::Reflect);

    /// Inlined. Sets this transform to be the product of qt1 and qt2. (this = qt1 * qt2)
    HK_INLINE void _setMul(const hkQTransformf& qt1, const hkQTransformf& qt2);

    /// Sets this transform to be the product of t1 and qt2. (this = t1 * qt2)
    HK_EXPORT_COMMON void setMul(const hkTransformf& t1, const hkQTransformf& qt2);

    /// Sets this transform to be the product of t1 and t2. (this = t1 * t2)
    HK_EXPORT_COMMON void setMul(const hkTransformf& t1, const hkTransformf& t2);

    /// Sets this transform to be the product of qt1 and t2. (this = qt1 * t2)
    HK_EXPORT_COMMON void setMul(const hkQTransformf& qt1, const hkTransformf& t2);

    /// Sets this transform to be the product of the inverse of qt1 by qt2. (this = qt1^-1 * qt2)
    HK_EXPORT_COMMON void setMulInverseMul(const hkQTransformf& qt1, const hkQTransformf& qt2);

    /// Sets this transform to be the product of the inverse of t1 by qt2. (this = t1^-1 * qt2)
    HK_EXPORT_COMMON void setMulInverseMul(const hkTransformf& t1, const hkQTransformf& qt2);

    /// Sets this transform to be the product of the inverse of qt1 by t2. (this = qt1^-1 * t2)
    HK_EXPORT_COMMON void setMulInverseMul(const hkQTransformf& qt1, const hkTransformf& t2);

    /// Sets this transform to be the product of the inverse of t1 by t2. (this = t1^-1 * t2)
    HK_EXPORT_COMMON void setMulInverseMul(const hkTransformf& t1, const hkTransformf& t2);

    /// Sets this transform to be the product of the inverse of qt1 by qt2. (this = qt1^-1 * qt2)
    HK_INLINE void _setMulInverseMul(const hkQTransformf& qt1, const hkQTransformf& qt2);

    /// Sets this transform to be the product of qt1 and the inverse of qt2. (this = qt1 * qt2^-1)
    HK_EXPORT_COMMON void setMulMulInverse(const hkQTransformf &qt1, const hkQTransformf &qt2);

    /// Sets this transform to be the product of qt1 and the inverse of qt2. (this = qt1 * qt2^-1)
    HK_INLINE void _setMulMulInverse(const hkQTransformf &qt1, const hkQTransformf &qt2);

    /// Checks if this transform is equal to the other within an optional epsilon.
    HK_EXPORT_COMMON bool isApproximatelyEqual( const hkQTransformf& other, hkFloat32 epsilon=hkFloat32(1e-3f) ) const;

    /// Checks if this transform is equal to the other within an epsilon.
    HK_INLINE bool _isApproximatelyEqual( const hkQTransformf& other, hkSimdFloat32Parameter epsilon) const;

    /// Sets this transform to a linear interpolation of the transforms qtA and qtB.
    /// Quaternions are checked for polarity and the resulting rotation is normalized
    HK_EXPORT_COMMON void setInterpolate4(const hkQTransformf& qtA, const hkQTransformf& qtB, hkSimdFloat32Parameter t);

    /// Checks for bad values (denormals or infinities)
    HK_EXPORT_COMMON bool isOk() const;

    const hkQsTranformFInverse& inverted() const { return reinterpret_cast<const hkQsTranformFInverse&>(*this); }

    HK_ALWAYS_INLINE hkVector4f operator*( hkVector4f_ a ) const { hkVector4f r; r.setTransformedPos( *this, a ); return r; }

public:

        /// The rotation part
    hkQuaternionf m_rotation;

        /// The translation part
    hkVector4f m_translation;   //+overridetype( hkVector4f )
};


class hkQsTranformFInverse : protected hkQTransformf
{
    public:
    HK_ALWAYS_INLINE hkVector4f operator*( hkVector4f_ a ) const { hkVector4f r; r.setTransformedInversePos( *this, a ); return r; }
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
