// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

HK_INLINE hkVector4d& hkTransformd::getColumn(int x)
{
    return m_rotation.getColumn(x);
}

HK_INLINE const hkVector4d& hkTransformd::getColumn(int x) const
{
    return m_rotation.getColumn(x);
}

template <int I>
HK_INLINE const hkVector4d& hkTransformd::getColumn() const
{
    return m_rotation.getColumn<I>();
}

template <int I>
HK_INLINE void hkTransformd::setColumn(hkVector4dParameter v)
{
    m_rotation.setColumn<I>(v);
}

HK_INLINE void hkTransformd::setTranslation(hkVector4dParameter t)
{
    m_translation = t;
}

HK_INLINE hkRotationd& hkTransformd::getRotation()
{
    return m_rotation;
}

HK_INLINE const hkRotationd& hkTransformd::getRotation() const
{
    return m_rotation;
}

HK_INLINE void hkTransformd::setRotation(const hkRotationd& rotation)
{
    m_rotation = rotation;
}

HK_INLINE void hkTransformd::setRotation(hkQuaterniondParameter quatRotation)
{
    m_rotation.set(quatRotation);
}

#ifndef HK_DISABLE_MATH_CONSTRUCTORS
HK_INLINE hkTransformd::hkTransformd(const hkTransformd& t)
{
    const hkVector4d r0 = t.getColumn<0>();
    const hkVector4d r1 = t.getColumn<1>();
    const hkVector4d r2 = t.getColumn<2>();
    const hkVector4d r3 = t.getColumn<3>();
    setColumn<0>(r0);
    setColumn<1>(r1);
    setColumn<2>(r2);
    setColumn<3>(r3);
}

HK_INLINE hkTransformd::hkTransformd(hkQuaterniondParameter q, hkVector4dParameter t)
    :   m_translation(t)
{
    m_rotation.set(q);
}


HK_INLINE hkTransformd::hkTransformd(const hkRotationd& r, hkVector4dParameter t)
    :   m_rotation(r),
        m_translation(t)
{
}
#endif

HK_INLINE hkDouble64& hkTransformd::operator() (int r, int c)
{
    return m_rotation(r,c);
}

HK_INLINE const hkDouble64& hkTransformd::operator() (int r, int c) const
{
    return m_rotation(r,c);
}

template <int ROW, int COL>
HK_INLINE const hkSimdDouble64 hkTransformd::getElement() const
{
    return m_rotation.getElement<ROW,COL>();
}

template <int ROW, int COL>
HK_INLINE void hkTransformd::setElement(hkSimdDouble64Parameter s)
{
    m_rotation.setElement<ROW,COL>(s);
}

HK_INLINE void hkTransformd::set(hkQuaterniondParameter q, hkVector4dParameter t)
{
    m_rotation.set(q);
    m_translation = t;
}

HK_INLINE void hkTransformd::set(const hkRotationd& r, hkVector4dParameter t)
{
    m_rotation = r;
    m_translation = t;
}

HK_INLINE /*static*/ const hkTransformd& HK_CALL hkTransformd::getIdentity()
{
    union { const hkQuadDouble64* r; const hkTransformd* t; } r2t;
    r2t.r = g_vectordConstants + HK_QUADREAL_1000;
    return *r2t.t;
}

HK_INLINE void hkTransformd::setIdentity()
{
    m_rotation.setIdentity();
    m_translation.setZero();
}

HK_INLINE hkVector4d& hkTransformd::getTranslation()
{
    return m_translation;
}

HK_INLINE const hkVector4d& hkTransformd::getTranslation() const
{
    return m_translation;
}

HK_INLINE void hkTransformd::_setInverse( const hkTransformd &t )
{
    m_rotation._setTranspose( t.getRotation() );

    hkVector4d tr;  tr.setNeg<4>(t.getTranslation());
    m_translation._setRotatedDir( m_rotation, tr);
}



HK_INLINE void hkTransformd::_setMulInverseMul( const hkTransformd& bTa, const hkTransformd &bTc )
{
#if defined(HK_EXPENSIVE_LHS)
    const hkTransformd* HK_RESTRICT pbTa = &bTa;
    const hkTransformd* HK_RESTRICT pbTc = &bTc;
    hkVector4d h; h.setSub(pbTc->m_translation, pbTa->m_translation );

    hkVector4d tmpRot0; tmpRot0._setRotatedInverseDir( pbTa->getRotation(), pbTc->getColumn<0>() );
    hkVector4d tmpRot1; tmpRot1._setRotatedInverseDir( pbTa->getRotation(), pbTc->getColumn<1>() );
    hkVector4d tmpRot2; tmpRot2._setRotatedInverseDir( pbTa->getRotation(), pbTc->getColumn<2>() );
    hkVector4d tmpRot3; tmpRot3._setRotatedInverseDir( pbTa->getRotation(), h);
    setColumn<0>(tmpRot0);
    setColumn<1>(tmpRot1);
    setColumn<2>(tmpRot2);
    setColumn<3>(tmpRot3);
#else
    int i = 3;
    do
    {
        getColumn(i)._setRotatedInverseDir( bTa.getRotation(), bTc.getColumn(i) );
    } while( --i >= 0 );
    hkVector4d h; h.setSub(bTc.m_translation, bTa.m_translation );
    m_translation._setRotatedInverseDir( bTa.m_rotation, h);
#endif
}

HK_INLINE void hkTransformd::setRows4( hkVector4dParameter r0, hkVector4dParameter r1, hkVector4dParameter r2, hkVector4dParameter r3)
{
    hkVector4d c0 = r0;
    hkVector4d c1 = r1;
    hkVector4d c2 = r2;
    hkVector4d c3 = r3;

    HK_TRANSPOSE4d(c0, c1, c2, c3);

    setColumn<0>(c0);
    setColumn<1>(c1);
    setColumn<2>(c2);
    setColumn<3>(c3);
}

/// Sets this to t1 * t2
HK_INLINE void hkTransformd::setMul( const hkTransformDInverse& t1, const hkTransformd& t2 )
{
    setMulInverseMul( (const hkTransformd&)t1, t2 );
}

/// Sets this to t1 * t2
HK_INLINE void hkTransformd::setMul( const hkTransformd& t1, const hkTransformDInverse& t2 )
{
    setMulMulInverse( t1, (const hkTransformd&)t2 );
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
