// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#ifndef HK_MATH_MATH_H
#   error Please include Common/Base/hkBase.h instead of this file.
#endif
class hkTransformDInverse;

HK_ON_REAL_IS_DOUBLE(typedef hkTransformd hkTransform);

/// Stores a rotation and translation.
/// Note that valid hkTransforms always have an orthonormal rotation component.
/// Note that the w component of the columns may not be set correctly. Havok
/// implicitly assumes that the shear components are all 0 and that the w
/// component of the translation is 1. To get a 4x4 matrix suitable for rendering
/// use the get4x4ColumnMajor method.
///
/// The following conventions are adopted:
///     - Internal representation of rotation is column-major
///     - Applying matrix multiplication to a vector is done by premultiplying
///       by the matrix
///
/// IMPORTANT NOTE ON SCALING:
///
/// This class is not designed to represent a full transformation including
/// skewing and scaling components. The assumption is that skewing will not be
/// used and that scaling is not meaningful in a simulation of rigid bodies
/// that only change their position and orientation.
///
/// Do not attempt to put scaling into the rows or columns of the
/// rotation matrix. It must remain orthonormal at all times.
class HK_EXPORT_COMMON hkTransformd
{
    public:

        HK_DECLARE_CLASS(hkTransformd, New, Reflect, Pod);
        HK_REFLECT_AS_ARRAY_FIXED(16, double);
        HK_RECORD_ATTR(hk::Default({1, 0, 0, 0}, {0, 1, 0, 0}, {0, 0, 1, 0}, {0, 0, 0, 1}));
        HK_RECORD_ATTR(hk::IncludeInMgd(false));
        typedef hkAlignedQuad<double> ReflectDefaultType[4];

#ifndef HK_DISABLE_MATH_CONSTRUCTORS
            /// Default constructor - all elements are uninitialized.
        HK_INLINE hkTransformd() { }

            /// Creates a new hkTransformd using the rotation r and translation t.
        HK_INLINE hkTransformd(const hkRotationd& r, hkVector4dParameter t);

            /// Copy constructor
        HK_INLINE hkTransformd(const hkTransformd& r);

            /// Creates a new hkTransformd using the rotation quaternion q and translation t.
        HK_INLINE hkTransformd(hkQuaterniondParameter q, hkVector4dParameter t);
#endif

            /// Read-write access element at (row, column)
        HK_INLINE hkDouble64& operator() (int row, int column);

            /// Read-only access element at (row, column)
        HK_INLINE const hkDouble64& operator() (int row, int column) const;

        template <int ROW, int COL>
        HK_INLINE const hkSimdDouble64 getElement() const;

        template <int ROW, int COL>
        HK_INLINE void setElement(hkSimdDouble64Parameter s);

            /// Sets the hkTransformd's values using the rotation quaternion q and translation t.
        HK_INLINE void set(hkQuaterniondParameter q, hkVector4dParameter t);
        HK_INLINE void set(const hkRotationd& r, hkVector4dParameter t);

            /// Sets this hkTransformd to be the identity transform.
        HK_INLINE void setIdentity();

            /// Returns a global identity transform.
        HK_INLINE static const hkTransformd& HK_CALL getIdentity();

            /// Checks if this transform is the identity within an optional epsilon
        bool isApproximatelyEqual( const hkTransformd& t, const hkDouble64& epsilon=hkDouble64(1e-3f) ) const;

            /// Gets a writable translation component.
        HK_INLINE hkVector4d& getTranslation();

            /// Gets the translation component.
        HK_INLINE const hkVector4d& getTranslation() const;

            /// Sets the translation component.
        HK_INLINE void setTranslation(hkVector4dParameter t);

            /// Gets a writable rotation component.
        HK_INLINE hkRotationd& getRotation();

            /// Gets the rotation component.
        HK_INLINE const hkRotationd& getRotation() const;

            /// Sets the rotation component (using a hkRotationd).
        HK_INLINE void setRotation(const hkRotationd& rotation);

            /// Sets the rotation component (using a hkQuaterniond).
        HK_INLINE void setRotation(hkQuaterniondParameter quatRotation);

            /// Sets this transform to be the inverse of the given transform t.
        void setInverse( const hkTransformd &t );

            /// Sets this transform to be the inverse of the given transform t.
        HK_INLINE void _setInverse( const hkTransformd &t );

            /// Sets this transform to be the product of t1 and t2. (this = t1 * t2) (this is an outof line call, inline call is available in hkTransformdUtil)
        void setMul( const hkTransformd &t1, const hkTransformd &t2 );

            /// Sets this transform to be the product of t1 and t2. (this = t1 * t2)
        void setMul( const hkQsTransformd &t1, const hkTransformd &t2 );

            /// Sets this transform to be the product of the inverse of t1 by t2. (this = t1^-1 * t2)
        void setMulInverseMul( const hkTransformd& bTa, const hkTransformd &bTc );

            /// Sets this transform to be the product of the inverse of t1 by t2. (this = t1^-1 * t2)
        HK_INLINE void _setMulInverseMul( const hkTransformd& bTa, const hkTransformd &bTc );

        /// Sets this transform to be the product of a and the inverse of b. (this = a * b^-1)
        void setMulMulInverse( const hkTransformd &a, const hkTransformd &b );

        /// Sets this to t1 * t2
        HK_INLINE void setMul( const hkTransformDInverse& t1, const hkTransformd& t2 );

        /// Sets this to t1 * t2
        HK_INLINE void setMul( const hkTransformd& t1, const hkTransformDInverse& t2 );

            /// Sets this transform to be the product of itself and the transform b. (this *= b)
        void setMulEq( const hkTransformd& b );

            /// Writes a 4x4 matrix to \a p in column-major order.
            /// The pointer \a p must be suitably aligned, depending on the math lib build.
            /// See the notes for aligned store in hkVector4d.
        void get4x4ColumnMajor(_Out_writes_all_(16) hkFloat32* HK_RESTRICT p) const;
            /// Writes a 4x4 matrix suitable for rendering into \a p. The pointer \a p must be 32-Byte aligned.
        void get4x4ColumnMajor(_Out_writes_all_(16) hkDouble64* HK_RESTRICT p) const;

            /// Reads a 4x4 matrix from \a p in column-major order. The matrix is only valid if there is no scaling present and the rotation is orthonormal.
            /// The pointer \a p must be suitably aligned, depending on the math lib build.
            /// See the notes for aligned load in hkVector4d.
        void set4x4ColumnMajor(_In_reads_(16) const hkFloat32* p);
            /// Reads a 4x4 matrix from \a p. There should be no scaling and the rotation should be orthonormal. The pointer \a p must be 32-Byte aligned.
        void set4x4ColumnMajor(_In_reads_(16) const hkDouble64* p);

            /// Sets all 4 rows at once (including the .w component)
        HK_INLINE void setRows4( hkVector4dParameter r0, hkVector4dParameter r1, hkVector4dParameter r2, hkVector4dParameter r3);


            /// Checks for bad values (denormals or infinities).
        bool isOk() const;

            /// Gets a read-write reference to the i'th column.
        HK_INLINE hkVector4d& getColumn(int i);

            /// Gets a read-only reference to the i'th column.
        HK_INLINE const hkVector4d& getColumn(int i) const;

        template <int I>
        HK_INLINE const hkVector4d& getColumn() const;

        template <int I>
        HK_INLINE void setColumn(hkVector4dParameter v);

            /// return this as flag inverted, to be used with the operator*
        const hkTransformDInverse& inverted() const { return reinterpret_cast<const hkTransformDInverse&>(*this); }

        HK_ALWAYS_INLINE hkVector4d operator*( hkVector4d_ a ) const { hkVector4d r; r._setTransformedPos(*this, a); return r; }

    protected:

        hkRotationd m_rotation;
        hkVector4d m_translation;
};

class hkTransformDInverse: protected hkTransformd
{
    public:
        HK_ALWAYS_INLINE hkVector4d operator*( hkVector4d_ a ) const { hkVector4d r; r._setTransformedInversePos(*this, a); return r; }
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
