// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0


//
//  Sets resultOut to be the product of t1 by the inverse of t2. (resultOut = t1 * Inverse(t2))

template <typename FT>
HK_INLINE void HK_CALL hkTransformUtilImpl<FT>::_computeMulInverse(const typename hkFloatTypes<FT>::Transform& t1, const typename hkFloatTypes<FT>::Transform& t2, typename hkFloatTypes<FT>::Transform& resultOut)
{
    typename hkFloatTypes<FT>::Rotation rot;        rot.setMulInverse(t1.getRotation(), t2.getRotation());
    typename hkFloatTypes<FT>::Vector pos;      pos._setRotatedDir(rot, t2.getTranslation());
    pos.setSub(t1.getTranslation(), pos);
    resultOut.set(rot, pos);
}

//
//  Converts a (hkQuaternion, hkVector) pair to a hkTransform

template <typename FT>
HK_INLINE void HK_CALL hkTransformUtilImpl<FT>::_convert(typename hkFloatTypes<FT>::Quaternion_ fromRot, typename hkFloatTypes<FT>::Vec4_ fromPos, typename hkFloatTypes<FT>::Transform& to)
{
    typename hkFloatTypes<FT>::Rotation rot;
    hkVector4UtilImpl<FT>::convertQuaternionToRotation(fromRot, rot);
    to.set(rot, fromPos);
}

//
//  Converts a hkQTransform to a hkTransform

template <typename FT>
HK_INLINE void HK_CALL hkTransformUtilImpl<FT>::_convert(const typename hkFloatTypes<FT>::QTransform& from, typename hkFloatTypes<FT>::Transform& to)
{
    _convert(from.m_rotation, from.m_translation, to);
}

//
//  Sets this transform to be the product of t1 and t2. (this = t1 * t2)

template <typename FT>
HK_INLINE void hkTransformUtilImpl<FT>::_mulTransformTransform( const typename hkFloatTypes<FT>::Transform& aTb, const typename hkFloatTypes<FT>::Transform& bTc, _Inout_ typename hkFloatTypes<FT>::Transform* HK_RESTRICT tOut )
{
    HK_ASSERT_NO_MSG(0x4763da71,  tOut != &aTb );

    hkVector4UtilImpl<FT>::rotatePoints( aTb.getRotation(), &bTc.getRotation().template getColumn<0>(), 4, &tOut->getRotation().template getColumn<0>() );
    tOut->getTranslation().add( aTb.getTranslation());
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
