// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/Math/Vector/hkVector4Util.h>
#include <Common/Base/Math/Matrix/hkMatrix3Util.h>

/// Miscellaneous operations on hkTransforms
template <typename FT>
class hkTransformUtilImpl
{
public:

    typedef hkTransformUtilImpl<FT> ThisType;
    HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_MATH, ThisType);

    /// Sets resultOut to be the product of t1 by the inverse of t2. (resultOut = t1 * Inverse(t2))
    static HK_INLINE void HK_CALL _computeMulInverse(const typename hkFloatTypes<FT>::Transform& t1, const typename hkFloatTypes<FT>::Transform& t2, typename hkFloatTypes<FT>::Transform& resultOut);

    /// Converts a hkQTransform to a hkTransform
    static HK_INLINE void HK_CALL _convert(const typename hkFloatTypes<FT>::QTransform& from, typename hkFloatTypes<FT>::Transform& to);

    /// Converts a (hkQuaternion, hkVector4) pair to a hkTransform
    static HK_INLINE void HK_CALL _convert(typename hkFloatTypes<FT>::Quaternion_ fromRot, typename hkFloatTypes<FT>::Vec4_ fromPos, typename hkFloatTypes<FT>::Transform& to);

    static HK_INLINE void HK_CALL _mulTransformTransform( const typename hkFloatTypes<FT>::Transform& aTb, const typename hkFloatTypes<FT>::Transform& bTc, _Inout_ typename hkFloatTypes<FT>::Transform* tOut );
};

#include <Common/Base/Math/Matrix/hkTransformUtil.inl>

typedef hkTransformUtilImpl<hkFloat32>  hkTransformfUtil;
typedef hkTransformUtilImpl<hkDouble64> hkTransformdUtil;

#if defined(HK_REAL_IS_DOUBLE)
typedef hkTransformdUtil hkTransformUtil;
#else
typedef hkTransformfUtil hkTransformUtil;
#endif

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
