 // TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#ifndef HK_MATH_MATH_H
#   error Please include Common/Base/hkBase.h instead of this file.
#endif

template<typename FT> struct hkRotationInverse;

/// Stores an orthonormal rotation matrix.
/// This is the fastest way to represent a rotation in Havok.
/// If using an Quaternion is more convenient, it is possible to convert
/// back and forth between an Rotation and an Quaternion.
/// hkRotations are assumed to be orthonormal i.e., that any given Rotation r
/// should satisfy the property transpose(r) = (r^-1)
template<typename FT>
class hkRotationImpl : public hkMatrix3Impl<FT>
{
    public:

        HK_DECLARE_CLASS(hkRotationImpl, New, Reflect, Pod);
        HK_REFLECT_AS_ARRAY_FIXED(12,FT);
        HK_RECORD_ATTR(hk::TypeLayout(hkMath::computeTypeSizeAlign));
        HK_RECORD_ATTR( hk::ReflectDetails(parents=false,fields=false) );
        HK_RECORD_ATTR( hk::Default({1,0,0,0}, {0,1,0,0}, {0,0,1,0}) );
        HK_RECORD_ATTR(hk::IncludeInMgd(false));

        typedef hkAlignedQuad<FT> ReflectDefaultType[3];

        typedef typename hkFloatTypes<FT>::Vec4  Vec4;
        typedef typename hkFloatTypes<FT>::Vec4_ Vec4_;

        typedef typename hkFloatTypes<FT>::Scalar  Scalar;
        typedef typename hkFloatTypes<FT>::Scalar_ Scalar_;     // see hkSimdFloat32

        typedef hkMatrix3Impl<FT>   Matrix3;
        typedef hkRotationImpl<FT>  Rotation;
        typedef typename hkFloatTypes<FT>::Quaternion Quaternion;

        /// Sets/initializes this rotation matrix from the quaternion q.
        HK_EXPORT_COMMON void set(const Quaternion& q);

        /// Sets/initializes this rotation matrix from the given rotation axis and angle.
        HK_EXPORT_COMMON void setAxisAngle(Vec4_ axis, FT angle);
        HK_EXPORT_COMMON void setAxisAngle(Vec4_ axis, Scalar_ angle);

        /// Check if this rotation orthonormal to the given epsilon.
        /// The default epsilon is set so that it passes a rotation constructed from
        /// a quaternion (normalized with normalize() )
        HK_EXPORT_COMMON bool isOrthonormal(FT epsilon = FT(1e-5f)) const;

        /// Returns a global identity matrix3.
        
        HK_INLINE static const Rotation& HK_CALL getIdentity()
        {
            return (hkRotationImpl<FT>&)hkMatrix3Impl<FT>::getIdentity();
        }

        /// Returns how far the matrix differs from an orthonormal matrix.
        HK_EXPORT_COMMON FT orthonormalDeviation() const;

        /// Checks for bad values (denormals or infinities) and orthogonality.
        HK_EXPORT_COMMON bool isOk() const;

        /// Renormalize a drifted rotation.
        HK_EXPORT_COMMON void renormalize();

        /// return this rotation with a flag, saying to should be treated as inverted
        const hkRotationInverse<FT>& inverted() const
        {
            return reinterpret_cast<const hkRotationInverse<FT>&>(*this);
        }
};

#if defined(HK_DYNAMIC_DLL)
/*HK_EXPORT_COMMON_TEMPLATE_SPECIALIZATION*/ template class /*HK_EXPORT_COMMON*/ hkRotationImpl<float>;
/*HK_EXPORT_COMMON_TEMPLATE_SPECIALIZATION*/ template class /*HK_EXPORT_COMMON*/ hkRotationImpl<double>;
#endif

HK_ON_REAL_IS_FLOAT ( typedef hkRotationf hkRotation; )
HK_ON_REAL_IS_DOUBLE( typedef hkRotationd hkRotation; )

template<typename FT>
struct hkRotationInverse: protected hkRotationImpl<FT>
{
    typedef typename hkFloatTypes<FT>::Vec4  Vec4;
    typedef typename hkFloatTypes<FT>::Vec4_ Vec4_;

    HK_ALWAYS_INLINE Vec4 operator*( Vec4_ a ) const { Vec4 r; r._setRotatedInverseDir(*this, a); return r; }
};

#if defined(HK_COMPILER_ARMCC) || defined(HK_COMPILER_GHS)
template<> hkReflect::Detail::TypeData hkRotationImpl<float>::typeData;
template<> hkReflect::Detail::TypeData hkRotationImpl<double>::typeData;
#endif

#include <Common/Base/_Auto/TemplateTypes/hkRotation_Types.inl>

HK_REFLECT_TYPEDEF(HK_EXPORT_COMMON, hkRotationf, hkRotationf_Tag);
HK_REFLECT_TYPEDEF(HK_EXPORT_COMMON, hkRotationd, hkRotationd_Tag);

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
