// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Base/hkBase.h>

HK_DETAIL_DIAG_MSVC_OFF(4661) //  no suitable definition provided for explicit template instantiation request

#include <Common/Base/Math/Vector/hkVector4Util.h>

template<typename FT>
void hkRotationImpl<FT>::set(const Quaternion& qi)
{
    hkVector4UtilImpl<FT>::convertQuaternionToRotation(qi, *this);
}


template<typename FT>
void hkRotationImpl<FT>::setAxisAngle(Vec4_ axis, FT angle)
{
    Quaternion q;
    q.setAxisAngle( axis, angle );
    this->set(q);
}

template<typename FT>
void hkRotationImpl<FT>::setAxisAngle(Vec4_ axis, Scalar_ angle)
{
    Quaternion q;
    q.setAxisAngle( axis, angle );
    this->set(q);
}

template<typename FT>
HK_EXPORT_COMMON FT hkRotationImpl<FT>::orthonormalDeviation() const
{
    // Check length of cols is 1
    Scalar dot0 = this->m_col0.template lengthSquared<3>(); // this-> is needed because of ps4 compiler
    Scalar dot1 = this->m_col1.template lengthSquared<3>();
    Scalar dot2 = this->m_col2.template lengthSquared<3>();

    const Scalar one = Scalar::template getConstant<HK_QUADREAL_1>();
    dot0 -= one;
    dot1 -= one;
    dot2 -= one;
    dot0.setAbs( dot0 );
    dot1.setAbs( dot1 );
    dot2.setAbs( dot2 );

    dot0.setMax( dot0, dot1 );
    dot0.setMax( dot0, dot2 );
    dot0 *= Scalar::template getConstant<HK_QUADREAL_INV_2>();  // because we used the square distance instead of the sqrt, this is OK since dot0 is around 0

    // check for orthogonality
    Vec4 cross01;   cross01.setCross( this->m_col0, this->m_col1 );
    Vec4 cross12;   cross12.setCross( this->m_col1, this->m_col2 );
    Vec4 diff0 = cross01 - this->m_col2;
    Vec4 diff1 = cross12 - this->m_col0;
    diff0.setAbs( diff0 );
    diff1.setAbs( diff1 );
    Scalar dot3 = diff0.template horizontalMax<3>();
    Scalar dot4 = diff1.template horizontalMax<3>();

    dot0.setMax( dot0, dot3 );
    dot0.setMax( dot0, dot4 );

    return dot0.getReal();
}

template<typename FT>
bool hkRotationImpl<FT>::isOrthonormal( FT epsilon ) const
{
    HK_ASSERT_NO_MSG( 0x72abf72, epsilon >= 0.0f );

    FT deviation = orthonormalDeviation();
    return (deviation < epsilon);
}

template<typename FT>
bool hkRotationImpl<FT>::isOk() const
{
    return(isOrthonormal() && Matrix3::isOk());
}

template<typename FT>
void hkRotationImpl<FT>::renormalize()
{
#if 0
    // Graphics Gems I, p464
    // may be faster depending on the number of terms used
    hkMatrix3f correction; correction.setIdentity();
    hkMatrix3f residual; residual.setMulInverse( *this, *this );
    residual.sub( correction );
    const float factors[] = { 1.0f/2, 3.0f/8, 5.0f/16, 35.0f/128, -65.0f/256, 231.0f/1024, -429/2048 };
    const int numFactors = sizeof(factors)/sizeof(float);
    for( int i = 0; i < numFactors; ++i )
    {
        correction.addMul( factors[i], residual );
        residual.mul(residual);
    }
    this->mul(correction);
#endif
    Quaternion q; q.setAndNormalize(*this);
    this->set(q);
}

template class hkRotationImpl<float>;
template class hkRotationImpl<double>;

HK_COMPILE_TIME_ASSERT(HK_ALIGN_OF(hkRotationf) == HK_FLOAT_ALIGNMENT);
HK_COMPILE_TIME_ASSERT(HK_ALIGN_OF(hkRotationd) == HK_DOUBLE_ALIGNMENT);

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
