// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/Math/Matrix/hkMatrix6f.h>
#include <Common/Base/Math/Matrix/hkMatrix6d.h>

# if defined(HK_REAL_IS_DOUBLE)
    typedef hkMatrix6d hkMatrix6;
    typedef hkVector8d hkVector8;
#else
    typedef hkMatrix6f hkMatrix6;
    typedef hkVector8f hkVector8;
#endif

# if defined(HK_REAL_IS_DOUBLE)
    extern "C"
    {
        HK_INLINE void HK_CALL hkMatrix6Add(hkMatrix6d& aOut, const hkMatrix6d& b) { hkMatrix6dAdd(aOut, b);  }
        HK_INLINE void HK_CALL hkMatrix6Sub(hkMatrix6d& aOut, const hkMatrix6d& b) { hkMatrix6dSub(aOut, b);  }
        HK_INLINE void HK_CALL hkMatrix6SetMul(hkMatrix6d& out, const hkMatrix6d&a, const hkMatrix6d&b ) { hkMatrix6dSetMul(out, a, b);  }
        HK_INLINE void HK_CALL hkMatrix6SetMulV(hkVector8d& out, const hkMatrix6d&a, const hkVector8d& b) { hkMatrix6dSetMulV(out, a, b);  }
        HK_INLINE void HK_CALL hkMatrix6SetTranspose(hkMatrix6d& out, const hkMatrix6d&in ) { hkMatrix6dSetTranspose(out, in);  }
        HK_INLINE void HK_CALL hkMatrix6SetInvert(hkMatrix6d& out, const hkMatrix6d& in ) { hkMatrix6dSetInvert(out, in);  }
    }
# else
    extern "C"
    {
        HK_INLINE void HK_CALL hkMatrix6Add(hkMatrix6f& aOut, const hkMatrix6f& b) { hkMatrix6fAdd(aOut, b);  }
        HK_INLINE void HK_CALL hkMatrix6Sub(hkMatrix6f& aOut, const hkMatrix6f& b) { hkMatrix6fSub(aOut, b);  }
        HK_INLINE void HK_CALL hkMatrix6SetMul(hkMatrix6f& out, const hkMatrix6f&a, const hkMatrix6f&b ) { hkMatrix6fSetMul(out, a, b);  }
        HK_INLINE void HK_CALL hkMatrix6SetMulV(hkVector8f& out, const hkMatrix6f&a, const hkVector8f& b) { hkMatrix6fSetMulV(out, a, b);  }
        HK_INLINE void HK_CALL hkMatrix6SetTranspose(hkMatrix6f& out, const hkMatrix6f&in ) { hkMatrix6fSetTranspose(out, in);  }
        HK_INLINE void HK_CALL hkMatrix6SetInvert(hkMatrix6f& out, const hkMatrix6f& in ) { hkMatrix6fSetInvert(out, in);  }
    }
# endif

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
