// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

template<typename FT> HK_INLINE const typename hkMatrix4Impl<FT>::Vec4& hkMatrix4Impl<FT>::getColumn(int x) const
{
#ifdef HK_COMPILER_GHS
    return ((Vec4*)this)[x];
#else
    return (&m_col0)[x];
#endif
}

template<typename FT> HK_INLINE typename hkMatrix4Impl<FT>::Vec4& hkMatrix4Impl<FT>::getColumn(int x)
{
#ifdef HK_COMPILER_GHS
    return ((Vec4*)this)[x];
#else
    return (&m_col0)[x];
#endif
}

template<typename FT>
template <int N>
HK_ALWAYS_INLINE const typename hkMatrix4Impl<FT>::Vec4& hkMatrix4Impl<FT>::getColumn() const
{
#ifdef HK_COMPILER_GHS
    return ((Vec4*)this)[N];
#else
    return (&m_col0)[N];
#endif
}

template<typename FT>
template <int N>
HK_ALWAYS_INLINE typename hkMatrix4Impl<FT>::Vec4& hkMatrix4Impl<FT>::getColumn()
{
#ifdef HK_COMPILER_GHS
    return ((Vec4*)this)[N];
#else
    return (&m_col0)[N];
#endif
}


template<typename FT>
template <int N>    HK_INLINE void hkMatrix4Impl<FT>::setColumn(Vec4_ c)
{
#ifdef HK_COMPILER_GHS
    ((Vec4*)this)[N] = c;
#else
    (&m_col0)[N] = c;
#endif
}

template<typename FT> void hkMatrix4Impl<FT>::setColumn(int x, Vec4_ c)
{
#ifdef HK_COMPILER_GHS
    ((hkVector4f*)this)[x] = c;
#else
    (&m_col0)[x] = c;
#endif
}


template<typename FT> HK_INLINE FT& hkMatrix4Impl<FT>::operator() (int r, int c)
{
    return (&m_col0)[c](r);
}

template<typename FT> HK_INLINE const FT& hkMatrix4Impl<FT>::operator() (int r, int c) const
{
    return getColumn(c)(r);
}

template<typename FT>
template <int ROW, int COL>
HK_INLINE typename hkMatrix4Impl<FT>::Scalar hkMatrix4Impl<FT>::getElement() const
{
// our reflection parser cannot compile this:   return getColumn<COL>().getComponent<ROW>();
    return (&m_col0)[COL].template getComponent<ROW>();
}

template<typename FT>
template <int ROW, int COL>
HK_INLINE void hkMatrix4Impl<FT>::setElement(Scalar_ element)
{
    (&m_col0)[COL].template setComponent<ROW>(element);
}

template<typename FT>
HK_INLINE void hkMatrix4Impl<FT>::setRows( Vec4_ r0, Vec4_ r1, Vec4_ r2, Vec4_ r3)
{
#if (HK_CONFIG_SIMD == HK_CONFIG_SIMD_ENABLED)
    Vec4 c0 = r0;
    Vec4 c1 = r1;
    Vec4 c2 = r2;
    Vec4 c3 = r3;
    hkMath::transpose(c0, c1, c2, c3);
    m_col0 = c0;
    m_col1 = c1;
    m_col2 = c2;
    m_col3 = c3;
#else
    Vec4 c0; c0.set( r0(0), r1(0), r2(0), r3(0) );
    Vec4 c1; c1.set( r0(1), r1(1), r2(1), r3(1) );
    Vec4 c2; c2.set( r0(2), r1(2), r2(2), r3(2) );
    Vec4 c3; c3.set( r0(3), r1(3), r2(3), r3(3) );

    setColumn<0>(c0);
    setColumn<1>(c1);
    setColumn<2>(c2);
    setColumn<3>(c3);
#endif
}


template<typename FT> HK_INLINE void hkMatrix4Impl<FT>::getRows( Vec4& r0, Vec4& r1, Vec4& r2, Vec4& r3) const
{
#if (HK_CONFIG_SIMD == HK_CONFIG_SIMD_ENABLED)
    Vec4 c0 = getColumn<0>();
    Vec4 c1 = getColumn<1>();
    Vec4 c2 = getColumn<2>();
    Vec4 c3 = getColumn<3>();

    hkMath::transpose(c0,c1,c2,c3);
#else
    Vec4 c0; c0.set( m_col0(0), m_col1(0), m_col2(0), m_col3(0) );
    Vec4 c1; c1.set( m_col0(1), m_col1(1), m_col2(1), m_col3(1) );
    Vec4 c2; c2.set( m_col0(2), m_col1(2), m_col2(2), m_col3(2) );
    Vec4 c3; c3.set( m_col0(3), m_col1(3), m_col2(3), m_col3(3) );
#endif

    r0 = c0;
    r1 = c1;
    r2 = c2;
    r3 = c3;
}

template<typename FT> HK_INLINE void hkMatrix4Impl<FT>::setCols( Vec4_ c0, Vec4_ c1, Vec4_ c2, Vec4_ c3)
{
    m_col0 = c0;
    m_col1 = c1;
    m_col2 = c2;
    m_col3 = c3;
}

template<typename FT> HK_INLINE void hkMatrix4Impl<FT>::operator= ( const Matrix4& a )
{
    m_col0 = a.getColumn<0>();
    m_col1 = a.getColumn<1>();
    m_col2 = a.getColumn<2>();
    m_col3 = a.getColumn<3>();
}

template<typename FT> HK_INLINE void hkMatrix4Impl<FT>::getCols( Vec4& c0, Vec4& c1, Vec4& c2, Vec4& c3) const
{
    c0 = m_col0;
    c1 = m_col1;
    c2 = m_col2;
    c3 = m_col3;
}

template<typename FT> HK_INLINE void hkMatrix4Impl<FT>::getRow( int row, Vec4& r) const
{
    r.set( m_col0(row), m_col1(row), m_col2(row), m_col3(row) );
}

template<typename FT>
template <int I>
HK_INLINE void hkMatrix4Impl<FT>::getRow( Vec4& r ) const
{
    r.set( getElement<I,0>(), getElement<I,1>(), getElement<I,2>(), getElement<I,3>() );
}

template<typename FT> HK_INLINE void hkMatrix4Impl<FT>::setRow( int row, Vec4_ r )
{
    m_col0(row) = r(0);
    m_col1(row) = r(1);
    m_col2(row) = r(2);
    m_col3(row) = r(3);
}

template<typename FT>
template <int I>
HK_INLINE void hkMatrix4Impl<FT>::setRow( Vec4_ r )
{
    setElement<I,0>( r.template getComponent<0>() );
    setElement<I,1>( r.template getComponent<1>() );
    setElement<I,2>( r.template getComponent<2>() );
    setElement<I,3>( r.template getComponent<3>() );
}

template<typename FT> HK_INLINE void hkMatrix4Impl<FT>::setZero()
{
    m_col0.setZero();
    m_col1.setZero();
    m_col2.setZero();
    m_col3.setZero();
}

template<typename FT> HK_INLINE void hkMatrix4Impl<FT>::setDiagonal( FT m00, FT m11, FT m22, FT m33 )
{
    setZero();
    m_col0(0) = m00;
    m_col1(1) = m11;
    m_col2(2) = m22;
    m_col3(3) = m33;
}

template<typename FT> HK_INLINE void hkMatrix4Impl<FT>::setDiagonal( Scalar_ m00, Scalar_ m11, Scalar_ m22, Scalar_ m33 )
{
#if (HK_CONFIG_SIMD == HK_CONFIG_SIMD_ENABLED)
    const Vec4* HK_RESTRICT id = (const Vec4*)(g_vectorfConstants + HK_QUADREAL_1000);
    m_col0.setMul(id[0], m00);
    m_col1.setMul(id[1], m11);
    m_col2.setMul(id[2], m22);
    m_col3.setMul(id[3], m33);
#else
    setZero();
    m_col0(0) = m00.getReal();
    m_col1(1) = m11.getReal();
    m_col2(2) = m22.getReal();
    m_col3(3) = m33.getReal();
#endif
}

template<typename FT> HK_INLINE void hkMatrix4Impl<FT>::setDiagonal( Vec4_ v )
{
#if (HK_CONFIG_SIMD == HK_CONFIG_SIMD_ENABLED)
    const Vec4* HK_RESTRICT id = (const Vec4*)(g_vectorfConstants + HK_QUADREAL_1000);
    m_col0.setMul(id[0], v);
    m_col1.setMul(id[1], v);
    m_col2.setMul(id[2], v);
    m_col3.setMul(id[3], v);
#else
    setZero();
    m_col0(0) = v(0);
    m_col1(1) = v(1);
    m_col2(2) = v(2);
    m_col3(3) = v(3);
#endif
}

template<typename FT> HK_INLINE void hkMatrix4Impl<FT>::getDiagonal( Vec4& v ) const
{
#if (HK_CONFIG_SIMD == HK_CONFIG_SIMD_ENABLED)
    const Vec4* HK_RESTRICT id = (const Vec4*)(g_vectorfConstants + HK_QUADREAL_1000);
    v.setMul(id[0], m_col0);
    v.addMul(id[1], m_col1);
    v.addMul(id[2], m_col2);
    v.addMul(id[3], m_col3);
#else
    v.set(m_col0(0), m_col1(1), m_col2(2), m_col3(3));
#endif
}

template<typename FT> HK_INLINE void hkMatrix4Impl<FT>::setIdentity()
{
    const Vec4* HK_RESTRICT id = (const Vec4*)(g_vectorfConstants + HK_QUADREAL_1000);
    m_col0 = id[0];
    m_col1 = id[1];
    m_col2 = id[2];
    m_col3 = id[3];
}

template<typename FT> HK_INLINE void hkMatrix4Impl<FT>::transformPosition (Vec4_ positionIn, Vec4& positionOut) const
{
    
    //HK_WARN_ON_DEBUG_IF(!isAffineTransformation(),0x872bbf1a, "Trying to transform a position by a 4x4 matrix not representing an affine transformation");    // removing warning (note: there is still Transform)

    Scalar xb = positionIn.template getComponent<0>();
    Scalar yb = positionIn.template getComponent<1>();
    Scalar zb = positionIn.template getComponent<2>();

    Vec4 t0;
    t0.setAddMul( m_col3, m_col0, xb );
    t0.addMul( yb, m_col1 );
    t0.addMul( zb, m_col2 );

    positionOut = t0;
}

template<typename FT> HK_INLINE void hkMatrix4Impl<FT>::multiplyVector (Vec4_ v, Vec4& resultOut) const
{
    Scalar xb = v.template getComponent<0>();
    Scalar yb = v.template getComponent<1>();
    Scalar zb = v.template getComponent<2>();
    Scalar wb = v.template getComponent<3>();

    Vec4 t0;
    t0.setMul( xb, m_col0 );
    t0.addMul( yb, m_col1 );
    t0.addMul( zb, m_col2 );
    t0.addMul( wb, m_col3 );

    resultOut = t0;
}

template<typename FT> HK_INLINE void hkMatrix4Impl<FT>::transformDirection (Vec4_ directionIn, Vec4& directionOut) const
{
    Scalar xb = directionIn.template getComponent<0>();
    Scalar yb = directionIn.template getComponent<1>();
    Scalar zb = directionIn.template getComponent<2>();

    Vec4 t0;
    t0.setMul( xb, m_col0 );
    t0.addMul( yb, m_col1 );
    t0.addMul( zb, m_col2 );

    directionOut = t0;
}

template<typename FT> HK_INLINE void hkMatrix4Impl<FT>::setTranspose( const Matrix4& s )
{
    setRows(s.getColumn<0>(), s.getColumn<1>(), s.getColumn<2>(), s.getColumn<3>());
}

template<typename FT> HK_INLINE void hkMatrix4Impl<FT>::transformInverseDirection (Vec4_ directionIn, Vec4& directionOut) const
{
    Matrix4 t; t.setTranspose(*this);
    t.transformDirection(directionIn,directionOut);
}

template<typename FT> HK_INLINE void hkMatrix4Impl<FT>::setMulAffine ( const Matrix4& a, const Matrix4& b )
{
    HK_WARN_ON_DEBUG_IF(!a.isAffineTransformation(),0x872bbf1d, "Matrix A in setMulAffine() is not an affine transformation");
    HK_WARN_ON_DEBUG_IF(!b.isAffineTransformation(),0x872bbf1e, "Matrix B in setMulAffine() is not an affine transformation");

    // We need to make it alias save
    Vec4 col0; a.transformDirection(b.m_col0, col0);
    Vec4 col1; a.transformDirection(b.m_col1, col1);
    Vec4 col2; a.transformDirection(b.m_col2, col2);
    Vec4 col3; a.transformPosition(b.m_col3, col3);

    m_col0 = col0;
    m_col1 = col1;
    m_col2 = col2;
    m_col3 = col3;
}

template<typename FT> HK_INLINE void hkMatrix4Impl<FT>::mulAffine ( const Matrix4& a )
{
    // SetMul is alias safe
    setMulAffine(*this, a);
}

template<typename FT> HK_INLINE const typename hkMatrix4Impl<FT>::Matrix4& HK_CALL hkMatrix4Impl<FT>::getIdentity()
{
    return reinterpret_cast<const Matrix4&>( g_vectorfConstants[HK_QUADREAL_1000] );
}

template<typename FT> HK_INLINE bool hkMatrix4Impl<FT>::isApproximatelyEqual( const Matrix4& m, Scalar_ epsilon) const
{
    Vec4 epsilon_v; epsilon_v.setAll(epsilon);

    Vec4 t0; t0.setSub(m_col0, m.template getColumn<0>());  t0.setAbs( t0 );
    Vec4 t1; t1.setSub(m_col1, m.template getColumn<1>());  t1.setAbs( t1 );
    Vec4 t2; t2.setSub(m_col2, m.template getColumn<2>());  t2.setAbs( t2 );
    Vec4 t3; t3.setSub(m_col3, m.template getColumn<3>());  t3.setAbs( t3 );

    t0.setMax( t0, t1 );
    t2.setMax( t2, t3 );
    t0.setMax( t0, t2 );
    return t0.lessEqual( epsilon_v ).allAreSet();
}

template<typename FT> HK_INLINE hkBool32 hkMatrix4Impl<FT>::isApproximatelyIdentity( Scalar_ epsilon) const
{
    Vec4 epsilon_v; epsilon_v.setAll(epsilon);
    const Vec4* HK_RESTRICT id = (const Vec4*)(g_vectorfConstants + HK_QUADREAL_1000);

    Vec4 t0; t0.setSub(m_col0, id[0]);  t0.setAbs( t0 );
    Vec4 t1; t1.setSub(m_col1, id[1]);  t1.setAbs( t1 );
    Vec4 t2; t2.setSub(m_col2, id[2]);  t2.setAbs( t2 );
    Vec4 t3; t3.setSub(m_col3, id[3]);  t3.setAbs( t3 );

    t0.setMax( t0, t1 );
    t2.setMax( t2, t3 );
    t0.setMax( t0, t2 );
    return t0.lessEqual( epsilon_v ).allAreSet();
}

template<typename FT> HK_INLINE void hkMatrix4Impl<FT>::setMul( const Matrix4& a, const Matrix4& b )
{
    HK_ASSERT_NO_MSG(0x6d9d1d43,  this != &a );
    HK_ASSERT_NO_MSG(0x64a8df81,  this != &b );

#if (HK_CONFIG_SIMD == HK_CONFIG_SIMD_ENABLED)
    Vec4 col0, col1, col2, col3;

    col0.setMul( b.m_col0.template getComponent<0>(), a.m_col0);
    col1.setMul( b.m_col1.template getComponent<0>(), a.m_col0);
    col2.setMul( b.m_col2.template getComponent<0>(), a.m_col0);
    col3.setMul( b.m_col3.template getComponent<0>(), a.m_col0);

    col0.addMul( b.m_col0.template getComponent<1>(), a.m_col1);
    col1.addMul( b.m_col1.template getComponent<1>(), a.m_col1);
    col2.addMul( b.m_col2.template getComponent<1>(), a.m_col1);
    col3.addMul( b.m_col3.template getComponent<1>(), a.m_col1);

    col0.addMul( b.m_col0.template getComponent<2>(), a.m_col2);
    col1.addMul( b.m_col1.template getComponent<2>(), a.m_col2);
    col2.addMul( b.m_col2.template getComponent<2>(), a.m_col2);
    col3.addMul( b.m_col3.template getComponent<2>(), a.m_col2);

    col0.addMul( b.m_col0.template getComponent<3>(), a.m_col3 );
    col1.addMul( b.m_col1.template getComponent<3>(), a.m_col3 );
    col2.addMul( b.m_col2.template getComponent<3>(), a.m_col3 );
    col3.addMul( b.m_col3.template getComponent<3>(), a.m_col3 );

    m_col0 = col0;
    m_col1 = col1;
    m_col2 = col2;
    m_col3 = col3;

#else
    Matrix4 aTrans = a;
    aTrans.transpose();

    Matrix4& result = *this;

    for (int c=0; c < 4; c++)
    {
        for (int r=0; r < 4; r++)
        {
            result(r,c) = aTrans.getColumn(r).template dot<4>( b.getColumn(c) ).getReal();
        }
    }
#endif
}


template<typename FT> HK_INLINE void hkMatrix4Impl<FT>::mul( const Matrix4& a )
{
    
    Matrix4 temp;
    temp.setMul( *this, a );
    *this = temp;
}

template<typename FT> HK_INLINE void hkMatrix4Impl<FT>::setMul( Scalar_ scale, const Matrix4& a)
{
    m_col0.setMul(a.template getColumn<0>(), scale);
    m_col1.setMul(a.template getColumn<1>(), scale);
    m_col2.setMul(a.template getColumn<2>(), scale);
    m_col3.setMul(a.template getColumn<3>(), scale);
}

template<typename FT> HK_INLINE void hkMatrix4Impl<FT>::mul( Scalar_ scale)
{
    m_col0.mul(scale);
    m_col1.mul(scale);
    m_col2.mul(scale);
    m_col3.mul(scale);
}

template<typename FT> HK_INLINE void hkMatrix4Impl<FT>::resetFourthRow ()
{
    m_col0.template zeroComponent<3>();
    m_col1.template zeroComponent<3>();
    m_col2.template zeroComponent<3>();
    m_col3.template setComponent<3>( Scalar::template getConstant<HK_QUADREAL_1>() );
}

template<typename FT> HK_INLINE void hkMatrix4Impl<FT>::set(const Transform& t)
{
    m_col0.setXYZ_0( t.template getColumn<0>() );
    m_col1.setXYZ_0( t.template getColumn<1>() );
    m_col2.setXYZ_0( t.template getColumn<2>() );
    m_col3.setXYZ_W( t.getTranslation(), Scalar::template getConstant<HK_QUADREAL_1>() ); ;
}

template<typename FT> HK_INLINE void hkMatrix4Impl<FT>::get(Transform& t) const
{
    t.template setColumn<0>(m_col0);
    t.template setColumn<1>(m_col1);
    t.template setColumn<2>(m_col2);
    t.template setColumn<3>(m_col3);
}

template<typename FT> HK_INLINE void hkMatrix4Impl<FT>::_add( const Matrix4& a )
{
    m_col0.add( a.template getColumn<0>() );
    m_col1.add( a.template getColumn<1>() );
    m_col2.add( a.template getColumn<2>() );
    m_col3.add( a.template getColumn<3>() );
}


template<typename FT> HK_INLINE void hkMatrix4Impl<FT>::transformHomogeneousAndNormalize(Vec4_ vectorIn, Vec4& resultOut) const
{
    Vec4 vectorOut; multiplyVector(vectorIn, vectorOut);

    Vec4 v3; v3.setAll(vectorOut.template getComponent<3>());
    resultOut.setDiv(vectorOut, v3);
}

// #if defined(HK_DYNAMIC_DLL)
// HK_EXPORT_COMMON_TEMPLATE_SPECIALIZATION template class HK_EXPORT_COMMON hkMatrix3Impl<float>;
// HK_EXPORT_COMMON_TEMPLATE_SPECIALIZATION template class HK_EXPORT_COMMON hkMatrix3Impl<double>;
// #endif

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
