// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

//
//  Sets this = Transpose(a) * b

template <typename FT>
HK_INLINE void HK_CALL hkMatrix4UtilImpl<FT>::_computeTransposeMul(const typename hkFloatTypes<FT>::Matrix4& a, const typename hkFloatTypes<FT>::Matrix4& b, typename hkFloatTypes<FT>::Matrix4& aTb)
{
    typename hkFloatTypes<FT>::Vector c0;   hkVector4UtilImpl<FT>::dot4_1vs4(b.template getColumn<0>(), a.template getColumn<0>(), a.template getColumn<1>(), a.template getColumn<2>(), a.template getColumn<3>(), c0);
    typename hkFloatTypes<FT>::Vector c1;   hkVector4UtilImpl<FT>::dot4_1vs4(b.template getColumn<1>(), a.template getColumn<0>(), a.template getColumn<1>(), a.template getColumn<2>(), a.template getColumn<3>(), c1);
    typename hkFloatTypes<FT>::Vector c2;   hkVector4UtilImpl<FT>::dot4_1vs4(b.template getColumn<2>(), a.template getColumn<0>(), a.template getColumn<1>(), a.template getColumn<2>(), a.template getColumn<3>(), c2);
    typename hkFloatTypes<FT>::Vector c3;   hkVector4UtilImpl<FT>::dot4_1vs4(b.template getColumn<3>(), a.template getColumn<0>(), a.template getColumn<1>(), a.template getColumn<2>(), a.template getColumn<3>(), c3);

    aTb.setCols(c0, c1, c2, c3);
}

template <typename FT>
HK_INLINE void HK_CALL hkMatrix4UtilImpl<FT>::_setDiagonal( typename hkFloatTypes<FT>::Vec4_ vDiagonal, typename hkFloatTypes<FT>::Matrix4& mtxOut )
{
#if (HK_CONFIG_SIMD == HK_CONFIG_SIMD_ENABLED)
    typename hkFloatTypes<FT>::Vector c0;   c0.setMul(hkFloatTypes<FT>::Vector::template getConstant<HK_QUADREAL_1000>(), vDiagonal);
    typename hkFloatTypes<FT>::Vector c1;   c1.setMul(hkFloatTypes<FT>::Vector::template getConstant<HK_QUADREAL_0100>(), vDiagonal);
    typename hkFloatTypes<FT>::Vector c2;   c2.setMul(hkFloatTypes<FT>::Vector::template getConstant<HK_QUADREAL_0010>(), vDiagonal);
    typename hkFloatTypes<FT>::Vector c3;   c3.setMul(hkFloatTypes<FT>::Vector::template getConstant<HK_QUADREAL_0001>(), vDiagonal);
    mtxOut.setCols(c0, c1, c2, c3);
#else
    mtxOut.setZero();
    mtxOut.template setElement<0, 0>(vDiagonal.template getComponent<0>());
    mtxOut.template setElement<1, 1>(vDiagonal.template getComponent<1>());
    mtxOut.template setElement<2, 2>(vDiagonal.template getComponent<2>());
    mtxOut.template setElement<3, 3>(vDiagonal.template getComponent<3>());
#endif
}

template <typename FT>
HK_INLINE void HK_CALL hkMatrix4UtilImpl<FT>::_setDiagonal(typename hkFloatTypes<FT>::Scalar_ diag, typename hkFloatTypes<FT>::Matrix4& mtxOut)
{
#if (HK_CONFIG_SIMD == HK_CONFIG_SIMD_ENABLED)
    typename hkFloatTypes<FT>::Vector c0;   c0.setMul(hkFloatTypes<FT>::Vector::template getConstant<HK_QUADREAL_1000>(), diag);
    typename hkFloatTypes<FT>::Vector c1;   c1.setMul(hkFloatTypes<FT>::Vector::template getConstant<HK_QUADREAL_0100>(), diag);
    typename hkFloatTypes<FT>::Vector c2;   c2.setMul(hkFloatTypes<FT>::Vector::template getConstant<HK_QUADREAL_0010>(), diag);
    typename hkFloatTypes<FT>::Vector c3;   c3.setMul(hkFloatTypes<FT>::Vector::template getConstant<HK_QUADREAL_0001>(), diag);
    mtxOut.setCols(c0, c1, c2, c3);
#else
    mtxOut.setZero();
    mtxOut.template setElement<0, 0>(diag);
    mtxOut.template setElement<1, 1>(diag);
    mtxOut.template setElement<2, 2>(diag);
    mtxOut.template setElement<3, 3>(diag);
#endif
}

template <typename FT>
HK_INLINE void HK_CALL hkMatrix4UtilImpl<FT>::_setDiagonal3x3( typename hkFloatTypes<FT>::Vec4_ vDiagonal, typename hkFloatTypes<FT>::Matrix4& mtxOut )
{
#if (HK_CONFIG_SIMD == HK_CONFIG_SIMD_ENABLED)
    typename hkFloatTypes<FT>::Vector c0;   c0.setMul(hkFloatTypes<FT>::Vector::template getConstant<HK_QUADREAL_1000>(), vDiagonal);
    typename hkFloatTypes<FT>::Vector c1;   c1.setMul(hkFloatTypes<FT>::Vector::template getConstant<HK_QUADREAL_0100>(), vDiagonal);
    typename hkFloatTypes<FT>::Vector c2;   c2.setMul(hkFloatTypes<FT>::Vector::template getConstant<HK_QUADREAL_0010>(), vDiagonal);
    mtxOut.setCols(c0, c1, c2, hkFloatTypes<FT>::Vector::template getConstant<HK_QUADREAL_0001>());
#else
    mtxOut.setZero();
    mtxOut.template setElement<0, 0>(vDiagonal.template getComponent<0>());
    mtxOut.template setElement<1, 1>(vDiagonal.template getComponent<1>());
    mtxOut.template setElement<2, 2>(vDiagonal.template getComponent<2>());
    mtxOut.template setElement<3, 3>(hkFloatTypes<FT>::Scalar::template getConstant<HK_QUADREAL_1>());
#endif
}

template <typename FT>
HK_INLINE void HK_CALL hkMatrix4UtilImpl<FT>::_setDiagonal3x3(typename hkFloatTypes<FT>::Scalar_ diag, typename hkFloatTypes<FT>::Matrix4& mtxOut)
{
#if (HK_CONFIG_SIMD == HK_CONFIG_SIMD_ENABLED)
    typename hkFloatTypes<FT>::Vector c0;   c0.setMul(hkFloatTypes<FT>::Vector::template getConstant<HK_QUADREAL_1000>(), diag);
    typename hkFloatTypes<FT>::Vector c1;   c1.setMul(hkFloatTypes<FT>::Vector::template getConstant<HK_QUADREAL_0100>(), diag);
    typename hkFloatTypes<FT>::Vector c2;   c2.setMul(hkFloatTypes<FT>::Vector::template getConstant<HK_QUADREAL_0010>(), diag);
    mtxOut.setCols(c0, c1, c2, hkFloatTypes<FT>::Vector::template getConstant<HK_QUADREAL_0001>());
#else
    mtxOut.setZero();
    mtxOut.template setElement<0, 0>(diag);
    mtxOut.template setElement<1, 1>(diag);
    mtxOut.template setElement<2, 2>(diag);
    mtxOut.template setElement<3, 3>(hkFloatTypes<FT>::Scalar::template getConstant<HK_QUADREAL_1>());
#endif
}

template <typename FT>
HK_INLINE void HK_CALL hkMatrix4UtilImpl<FT>::_setMulInverseAffine ( const typename hkFloatTypes<FT>::Matrix4& a, const typename hkFloatTypes<FT>::Matrix4& b, typename hkFloatTypes<FT>::Matrix4& out )
{
    const typename hkFloatTypes<FT>::Scalar eps = hkFloatTypes<FT>::Scalar::template getConstant<HK_QUADREAL_EPS>();
    typename hkFloatTypes<FT>::Matrix4 binverse; binverse.setInverse(b, eps);
    out.setMulAffine(a, binverse);
}

template <typename FT>
HK_INLINE void HK_CALL hkMatrix4UtilImpl<FT>::_setMulInverse ( const typename hkFloatTypes<FT>::Matrix4& a, const typename hkFloatTypes<FT>::Matrix4& b, typename hkFloatTypes<FT>::Matrix4& out )
{
    const typename hkFloatTypes<FT>::Scalar eps = hkFloatTypes<FT>::Scalar::template getConstant<HK_QUADREAL_EPS>();
    typename hkFloatTypes<FT>::Matrix4 binverse; binverse.setInverse( b, eps );
    out.setMul( a, binverse );
}


//
//  Converts a hkMatrix4 to a hkMatrix3

template <typename FT>
HK_INLINE void HK_CALL hkMatrix4UtilImpl<FT>::_getTopLeftBlock(const typename hkFloatTypes<FT>::Matrix4& fromMtx, typename hkFloatTypes<FT>::Matrix3& toMtx)
{
    typename hkFloatTypes<FT>::Vector c0 = fromMtx.template getColumn<0>();     c0.template zeroComponent<3>();
    typename hkFloatTypes<FT>::Vector c1 = fromMtx.template getColumn<1>();     c1.template zeroComponent<3>();
    typename hkFloatTypes<FT>::Vector c2 = fromMtx.template getColumn<2>();     c2.template zeroComponent<3>();
    toMtx.setCols(c0, c1, c2);
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
