// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/Math/Vector/hkVector4Util.h>

/// Utility functions for hkMatrix4
template <typename FT>
class hkMatrix4UtilImpl
{
public:

    typedef hkMatrix4UtilImpl<FT> ThisType;
    HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_MATH, ThisType);

    /// Sets aTb = Transpose(a) * b.
    static HK_INLINE void HK_CALL _computeTransposeMul(const typename hkFloatTypes<FT>::Matrix4& a, const typename hkFloatTypes<FT>::Matrix4& b, typename hkFloatTypes<FT>::Matrix4& aTb);

    /// (Assumes transforms are affine) Sets \a out matrix to be the product of \a a and the inverse of \a b. (out = a * b^-1)
    static HK_INLINE void HK_CALL _setMulInverseAffine ( const typename hkFloatTypes<FT>::Matrix4& a, const typename hkFloatTypes<FT>::Matrix4& b, typename hkFloatTypes<FT>::Matrix4& out );

    /// (Non-affine version - slower) Sets \a out matrix to be the product of \a a and the inverse of \a b. (out = a * b^-1)
    static HK_INLINE void HK_CALL _setMulInverse ( const typename hkFloatTypes<FT>::Matrix4& a, const typename hkFloatTypes<FT>::Matrix4& b, typename hkFloatTypes<FT>::Matrix4& out );

    /// Sets the specified diagonal values, zeroes the non-diagonal values.
    static HK_INLINE void HK_CALL _setDiagonal(typename hkFloatTypes<FT>::Vec4_ vDiagonal, typename hkFloatTypes<FT>::Matrix4& matrixOut);
    static HK_INLINE void HK_CALL _setDiagonal(typename hkFloatTypes<FT>::Scalar_ diag, typename hkFloatTypes<FT>::Matrix4& matrixOut);

    /// Sets the specified diagonal values of the upper 3x3 matrix, zeroes the non-diagonal values, sets last column to <0,0,0,1>
    static HK_INLINE void HK_CALL _setDiagonal3x3(typename hkFloatTypes<FT>::Vec4_ vDiagonal, typename hkFloatTypes<FT>::Matrix4& matrixOut);
    static HK_INLINE void HK_CALL _setDiagonal3x3(typename hkFloatTypes<FT>::Scalar_ diag, typename hkFloatTypes<FT>::Matrix4& matrixOut);

    /// Converts a hkMatrix4 to a hkMatrix3
    static HK_INLINE void HK_CALL _getTopLeftBlock(const typename hkFloatTypes<FT>::Matrix4& fromMtx, typename hkFloatTypes<FT>::Matrix3& toMtx);
};

#include <Common/Base/Math/Matrix/hkMatrix4Util.inl>

typedef hkMatrix4UtilImpl<hkFloat32>  hkMatrix4fUtil;
typedef hkMatrix4UtilImpl<hkDouble64> hkMatrix4dUtil;

HK_ON_REAL_IS_DOUBLE(typedef hkMatrix4dUtil hkMatrix4Util; )
HK_ON_REAL_IS_FLOAT (typedef hkMatrix4fUtil hkMatrix4Util; )

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
