// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

template<hkMatrix4CameraUtil::ClipSpaceDepthRange::Enum sourceRange, hkMatrix4CameraUtil::ClipSpaceDepthRange::Enum destRange>
void hkMatrix4CameraUtil::convertMatrixDepthConvention(hkMatrix4& matrix)
{
    hkVector4 rowX, rowY, rowZ, rowW;
    matrix.getRows(rowX, rowY, rowZ, rowW);
    adjustZandW<sourceRange, destRange>(rowZ, rowW);
    matrix.setRows(rowX, rowY, rowZ, rowW);
}

template<> HK_INLINE void
hkMatrix4CameraUtil::adjustZandW<hkMatrix4CameraUtil::ClipSpaceDepthRange::ZeroToOne, hkMatrix4CameraUtil::ClipSpaceDepthRange::ZeroToOne>(hkVector4& rowZ, hkVector4& rowW)
{
}

template<> HK_INLINE void
hkMatrix4CameraUtil::adjustZandW<hkMatrix4CameraUtil::ClipSpaceDepthRange::MinusOneToOne, hkMatrix4CameraUtil::ClipSpaceDepthRange::MinusOneToOne>(hkVector4& rowZ, hkVector4& rowW)
{
}

template<> HK_INLINE void
hkMatrix4CameraUtil::adjustZandW<hkMatrix4CameraUtil::ClipSpaceDepthRange::ZeroToOne, hkMatrix4CameraUtil::ClipSpaceDepthRange::MinusOneToOne>(hkVector4& rowZ, hkVector4& rowW)
{
    // Map z => 2z - w
    rowZ.add(rowZ);
    rowZ.sub(rowW);
}

template<> HK_INLINE void
hkMatrix4CameraUtil::adjustZandW<hkMatrix4CameraUtil::ClipSpaceDepthRange::MinusOneToOne, hkMatrix4CameraUtil::ClipSpaceDepthRange::ZeroToOne>(hkVector4& rowZ, hkVector4& rowW)
{
    // Map z => (z + w)/2
    rowZ.add(rowW);
    rowZ.mul(hkSimdReal_Half);
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
