// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

class hkAabb;
struct hkPlane;

/// Perspective camera projection matrix setup. Only impls single precision as double would not used by current renderer.

class HK_EXPORT_COMMON hkMatrix4CameraUtil
{
    public:

    struct ClipSpaceDepthRange
    {
        enum Enum
        {
            MinusOneToOne = 0,  /// This is the convention used by OpenGL
            ZeroToOne           /// This is the convention used by Direct3D
        };
    };

    struct ClipSpaceYRange
    {
        enum Enum
        {
            MinusOneToOne = 0,    /// Creates a standard projection matrix.
            OneToMinusOne         /// Creates a projection matrix used to flip the resulting image upside down, such as for RenderToTexture on a platform where we assume different Y origin
        };
    };

    // Calculate a right-handed perspective projection matrix.
    static void HK_CALL setPerspectiveProjection( hkFloat32 viewWidth, hkFloat32 viewHeight, hkFloat32 nearZ, hkFloat32 farZ, ClipSpaceDepthRange::Enum depthRange, ClipSpaceYRange::Enum yRange, hkMatrix4& matrixOut );
    static void HK_CALL setPerspectiveProjection( hkFloat32 left, hkFloat32 right, hkFloat32 bottom, hkFloat32 top, hkFloat32 nearZ, hkFloat32 farZ, ClipSpaceDepthRange::Enum depthRange, ClipSpaceYRange::Enum yRange, hkMatrix4& matrixOut );
    static void HK_CALL setPerspectiveProjectionFromFovX( hkFloat32 fieldOfViewXDegrees, hkFloat32 aspectRatioWidthDivHeight, hkFloat32 nearZ, hkFloat32 farZ, ClipSpaceDepthRange::Enum depthRange, ClipSpaceYRange::Enum yRange, hkMatrix4& matrixOut );
    static void HK_CALL setPerspectiveProjectionFromFovY( hkFloat32 fieldOfViewYDegrees, hkFloat32 aspectRatioWidthDivHeight, hkFloat32 nearZ, hkFloat32 farZ, ClipSpaceDepthRange::Enum depthRange, ClipSpaceYRange::Enum yRange, hkMatrix4& matrixOut );
    static void HK_CALL setOrthographicProjection( hkFloat32 viewWidth, hkFloat32 viewHeight, hkFloat32 nearZ, hkFloat32 farZ, ClipSpaceDepthRange::Enum depthRange, ClipSpaceYRange::Enum yRange, hkMatrix4& matrixOut );
    static void HK_CALL setOrthographicProjection( hkFloat32 left, hkFloat32 right, hkFloat32 bottom, hkFloat32 top, hkFloat32 nearZ, hkFloat32 farZ, ClipSpaceDepthRange::Enum depthRange, ClipSpaceYRange::Enum yRange, hkMatrix4& matrixOut );

    struct ViewHandedness
    {
        enum Enum
        {
            RightHanded = 0,  // eg 3dsMax, Maya (where if z up, and y away going away from you, then x is to the right)
            LeftHanded
        };
    };
    // Note that like the perspective projection functions, these generate camera matrices, so are world->camera (view matrix) not camera->world (viewinv matrix / camera world transform)
    //
    // This is a matrix that maps the vectors (ie, homogeneous vectors with w = 0)
    //  - right to +x
    //  - adjusted up vector to +y
    //  - The vector targetPos - startPos to -z for right-handed and to +z for left-handed matrices.
    //  - The point startPos (with homogeneous w = 1), to (0,0,0,1)
    static void HK_CALL setLookAtView( hkVector4Parameter startPos, hkVector4Parameter targetPos, hkVector4Parameter upDir, hkMatrix4& matrixOut, ViewHandedness::Enum handedness = ViewHandedness::RightHanded );

    // Similar to the above, but camera -> world instead of world -> camera
    static void HK_CALL setLookAtViewInv( hkVector4Parameter startPos, hkVector4Parameter targetPos, hkVector4Parameter upDir, hkMatrix4& matrixOut, ViewHandedness::Enum handedness = ViewHandedness::RightHanded );

    // Converts a projection or view projection matrix between depth range conventions.
    template<hkMatrix4CameraUtil::ClipSpaceDepthRange::Enum sourceRange, hkMatrix4CameraUtil::ClipSpaceDepthRange::Enum destRange>
    HK_INLINE static void convertMatrixDepthConvention(hkMatrix4& matrix);

    // Computes the frustum AABB from given view projection matrix. The matrix should be in [-1, 1] depth range convention.
    static void getFrustumAabb(const hkMatrix4& viewProjection, hkAabb& aabb);

    // Computes the horizontal and vertical field of view from the given perspective projection matrix (angle between frustum planes).
    // Note, returns 0 for orthographic projection matrix (frustum planes are parallel).
    static void getFieldOfView(const hkMatrix4& proj, hkReal& fovX, hkReal& fovY);

    struct FrustumPlaneDirection
    {
        enum Enum
        {
            LeftToRight,
            BottomToTop,
            NearToFar
        };
    };

    // Computes an interpolated frustum plane by using linear interpolation in normalized clip space.
    // t is the interpolation coefficient (usually in the interval [0;1]).
    static void getInterpolatedFrustumPlane(FrustumPlaneDirection::Enum dir, hkReal t, const hkMatrix4& proj, ClipSpaceDepthRange::Enum depthRange, hkPlane& planeOut);

private:

    // Depth convention conversion
    template<hkMatrix4CameraUtil::ClipSpaceDepthRange::Enum sourceRange, hkMatrix4CameraUtil::ClipSpaceDepthRange::Enum destRange> HK_INLINE static void adjustZandW(hkVector4& rowZ, hkVector4& rowW);
};

#include <Common/Base/Math/Matrix/hkMatrix4CameraUtil.inl>

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
