// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL !REFLECT
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#ifndef HK_MATH_LARGE_INT_TYPES_H
#define HK_MATH_LARGE_INT_TYPES_H

//
//  Type shortcuts

class hkInt64Vector4;
class hkInt128Vector4;
typedef const hkInt64Vector4&   hkInt64Vector4Parameter;
typedef const hkInt128Vector4&  hkInt128Vector4Parameter;

#include <Common/Base/Math/Vector/hkIntVector.h>
#include <Common/Base/Math/LargeInt/hkLargeInt.h>
#include <Common/Base/Math/LargeInt/hkInt64Vector4.h>
#include <Common/Base/Math/LargeInt/hkInt128Vector4.h>

#ifndef __HAVOK_PARSER__
#if ( HK_CONFIG_SIMD == HK_CONFIG_SIMD_ENABLED )
#   if defined( HK_COMPILER_HAS_INTRINSICS_IA32 )
#       include <Common/Base/Math/LargeInt/Sse/hkSseInt64Vector4.inl>
#   elif defined(HK_COMPILER_HAS_INTRINSICS_NEON)
#       include <Common/Base/Math/LargeInt/Neon/hkNeonInt64Vector4.inl>
#   else
#       include <Common/Base/Math/LargeInt/Fpu/hkFpuInt64Vector4.inl> 
#   endif
#else
#   include <Common/Base/Math/LargeInt/Fpu/hkFpuInt64Vector4.inl> 
#endif
#endif

#include <Common/Base/Math/LargeInt/hkInt64Vector4.inl>
#include <Common/Base/Math/LargeInt/hkLargeInt.inl>
#include <Common/Base/Math/LargeInt/hkInt128Vector4.inl>

#endif

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
