// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
//HK_REFLECTION_PARSER_EXCLUDE_FILE

//
//  Sets this = Cross[vA, vB]

inline void hkInt64Vector4::setCross(hkIntVectorParameter vA, hkIntVectorParameter vB)
{
    // Shuffle
    hkIntVector a_yzx;  a_yzx.setPermutation<hkVectorPermutation::YZXW>(vA);    // [ay, az, ax]
    hkIntVector a_zxy;  a_zxy.setPermutation<hkVectorPermutation::ZXYW>(vA);    // [az, ax, ay]
    hkIntVector b_yzx;  b_yzx.setPermutation<hkVectorPermutation::YZXW>(vB);    // [by, bz, bx]
    hkIntVector b_zxy;  b_zxy.setPermutation<hkVectorPermutation::ZXYW>(vB);    // [bz, bx, by]

    hkInt64Vector4 abp; abp.setMul(a_yzx, b_zxy);   // [ay bz, az bx, ax by]
    hkInt64Vector4 abn; abn.setMul(a_zxy, b_yzx);   // [az by, ax bz, ay bx]
    setSub(abp, abn);                               // [ay bz - az by, az bx - ax bz, ax by - ay bx]
}

//
//  Sets this = abs(v)

inline void hkInt64Vector4::setAbs(hkInt64Vector4Parameter v)
{
    setFlipSign(v, v.lessZero());
}

//
//  Sets this = sign * v

inline void hkInt64Vector4::setFlipSign(hkInt64Vector4Parameter v, hkVector4fComparisonParameter sign)
{
    hkInt64Vector4 vNeg;    vNeg.setNeg<4>(v);
    setSelect(sign, vNeg, v);
}

//
//  Returns the index of the component with the largest signed value among the first N components.
//  In case of equality, returns the last component index given X,Y,Z,W ordering.

template <>
inline int hkInt64Vector4::getIndexOfMaxComponent<3>() const
{
    hkInt64Vector4 mi;              mi.setAll(horizontalMax<3>());
    hkVector4fComparison isMin      = equal(mi);
    hkVector4fComparison xyzMask;   xyzMask.set<hkVector4ComparisonMask::MASK_XYZ>();

    isMin.setAnd(isMin, xyzMask);
    HK_MATH_ASSERT(0x2842fb1, isMin.getMask() > 0, "inconsistent min value of self");
    HK_MATH_ASSERT(0x2842fb2, (isMin.getMask() & hkVector4ComparisonMask::MASK_W) == 0, "selective compare failed");
    return isMin.getIndexOfFirstComponentSetElseZero();
}

//
//  Returns the dot product between this and v

template <> inline const hkInt128 hkInt64Vector4::dot<3>(hkIntVectorParameter vB) const
{
    hkInt128 a, b, c;
    a.setMul(getComponent<0>(), hkInt64(vB.getComponent<0>()));
    b.setMul(getComponent<1>(), hkInt64(vB.getComponent<1>()));
    c.setMul(getComponent<2>(), hkInt64(vB.getComponent<2>()));
    a.setAdd(a, b);
    a.setAdd(a, c);
    return a;
}

//
//  Counts the leading zeros of the first I components

#ifndef HK_INT64_VECTOR4_countLeadingZeros
#   define HK_INT64_VECTOR4_countLeadingZeros

template <> inline void hkInt64Vector4::countLeadingZeros<1>(hkIntVector& leadingZerosOut) const
{
    leadingZerosOut.setComponent<0>(hkMath::countLeadingZeros<hkUint64>(getComponent<0>()));
}

template <int I> inline void hkInt64Vector4::countLeadingZeros(hkIntVector& leadingZerosOut) const
{
    countLeadingZeros<I - 1>(leadingZerosOut);
    leadingZerosOut.setComponent<I - 1>(hkMath::countLeadingZeros<hkUint64>(getComponent<I - 1>()));
}

#endif

inline void hkInt64Vector4::set(hkIntVectorParameter v)
{
    set( v.getComponent<0>(), v.getComponent<1>(), v.getComponent<2>(), v.getComponent<3>() );
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
