// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL !REFLECT
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#ifndef HK_MATH_LARGE_INT_TYPES_H
#   error Include Common/Base/Math/LargeInt/hkLargeIntTypes.h instead of this file!
#endif

/// A 4-vector of 64-bit integers
class hkInt64Vector4
{
    //+hk.MemoryTracker(ignore=True)
    public:

        HK_DECLARE_CLASS(hkInt64Vector4, New, Pod);

        /// Sets all component of this to i
        inline void setAll(hkInt64 i);

        /// Sets the components of the vector to the given values
        inline void set(hkInt64 x, hkInt64 y, hkInt64 z, hkInt64 w = 0L);

        /// Sets the components of the vector to the given values
        inline void set(hkIntVectorParameter v);

        /// Sets this = 0
        inline void setZero();

        /// Sets the I-th component to the given value
        template <int I> inline void setComponent(hkInt64 value);
        inline void setComponent(int I, hkInt64 value);

        /// Sets this = vA * vB
        inline void setMul(hkIntVectorParameter vA, hkIntVectorParameter vB);

        // Sets this = a / b. Both a and b are assumed to be unsigned!
        inline void setUnsignedDiv(hkInt64Vector4Parameter a, hkInt64Vector4Parameter b);

        /// Sets this = vA - vB
        inline void setSub(hkInt64Vector4Parameter vA, hkInt64Vector4Parameter vB);

        /// Sets this = vA + vB
        inline void setAdd(hkInt64Vector4Parameter vA, hkInt64Vector4Parameter vB);

        /// Sets this = Cross[vA, vB]
        inline void setCross(hkIntVectorParameter vA, hkIntVectorParameter vB);

        /// Returns (this < 0)
        inline hkVector4fComparison lessZero() const;
        template <typename T> inline T lessZero() const;

        /// Returns (this == 0)
        inline hkVector4fComparison equalZero() const;

        /// Returns (this == v)
        inline hkVector4fComparison equal(hkInt64Vector4Parameter v) const;

        /// Sets this = -v
        template <int I>
        inline void setNeg(hkInt64Vector4Parameter v);

        /// Sets this = abs(v)
        inline void setAbs(hkInt64Vector4Parameter v);

        /// Sets this = vA & vB
        inline void setAnd(hkInt64Vector4Parameter vA, hkInt64Vector4Parameter vB);

        /// Sets this = sign * v
        inline void setFlipSign(hkInt64Vector4Parameter v, hkVector4fComparisonParameter sign);

        /// Sets this = cmp ? vTrue : vFalse
        inline void setSelect(hkVector4fComparisonParameter cmp, hkInt64Vector4Parameter vTrue, hkInt64Vector4Parameter vFalse);

        /// Sets this = v << I by component
        template <int I>
        inline void setShiftLeft(hkInt64Vector4Parameter v);
        inline void setShiftLeft(hkInt64Vector4Parameter v, int I);

        /// Sets this = v >> I by component
        template <int I, hkMathValueType Val>
        inline void setShiftRight(hkInt64Vector4Parameter v);

        template <int I>
        inline void setShiftRight(hkInt64Vector4Parameter v);
        template <hkMathValueType Val>
        inline void setShiftRight(hkInt64Vector4Parameter v, int I);

        /// Returns the dot product between this and v
        template <int I>
        inline const hkInt128 dot(hkIntVectorParameter v) const;

        template <int I>
        const hkInt128 dot(hkInt64Vector4Parameter v) const;

        template <int I>
        inline hkInt64 dot_64(hkIntVectorParameter v) const;

        /// Sets this = a permutation of the components of v
        template <hkVectorPermutation::Permutation perm>
        inline void setPermutation(hkInt64Vector4Parameter v);

        /// Returns the I-th component
        template <int I>
        inline hkInt64 getComponent() const;
        inline hkInt64 getComponent(int I) const;

        /// Sets the I-th component to zero
        template <int I>
        inline void zeroComponent();

        /// Returns the maximum component among the first N.
        template <int N>
        inline hkInt64 horizontalMax() const;

        /// Returns the index of the component with the largest signed value among the first N components.
        /// In case of equality, returns the last component index given X,Y,Z,W ordering.
        template <int N>
        inline int getIndexOfMaxComponent() const;

        /// Converts the 4 64-bit ints to doubles
        inline void convertS64ToF64(hkVector4d& vOut) const;

        /// Counts the leading zeros of the first I components
        template <int I>
        inline void countLeadingZeros(hkIntVector& leadingZerosOut) const;

        /// Load values for N components from linear addresses at \a p. Not loaded components are undefined.
        /// See the documentation at the template values for the requested IO mode.
        template <int N, hkMathIoMode A> HK_INLINE void load(_In_reads_(N) const hkUint64* p);

        /// Store values of N components to linear addresses at \a p.
        /// See the documentation at the template values for the requested IO mode.
        template <int N, hkMathIoMode A> HK_INLINE void store(_Out_writes_all_(N) hkUint64* p) const;

    public:

        HK_ALIGN16(hkQuadUlong m_quad);
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
