// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
//HK_REFLECTION_PARSER_EXCLUDE_FILE

//
//  Sets this = [x, y, z, w]

inline void hkInt128Vector4::set(const hkInt128& x, const hkInt128& y, const hkInt128& z, const hkInt128& w)
{
    m_x = x;    m_y = y;    m_z = z;    m_w = w;
}

//
//  Sets all components to the given value

inline void hkInt128Vector4::setAll(int i)
{
    m_x.setFromInt32(i);
    m_y = m_z = m_w = m_x;
}

//
//  Sets this = abs(v)

template <> inline void hkInt128Vector4::setAbs<1>(hkInt128Vector4Parameter v)  {   m_x.setAbs(v.m_x);  }
template <> inline void hkInt128Vector4::setAbs<2>(hkInt128Vector4Parameter v)  {   m_x.setAbs(v.m_x);  m_y.setAbs(v.m_y);  }
template <> inline void hkInt128Vector4::setAbs<3>(hkInt128Vector4Parameter v)  {   m_x.setAbs(v.m_x);  m_y.setAbs(v.m_y);  m_z.setAbs(v.m_z);  }
template <> inline void hkInt128Vector4::setAbs<4>(hkInt128Vector4Parameter v)  {   m_x.setAbs(v.m_x);  m_y.setAbs(v.m_y);  m_z.setAbs(v.m_z);  m_w.setAbs(v.m_w);  }

//
//  Sets this = a & b

template <> inline void hkInt128Vector4::setAnd<1>(hkInt128Vector4Parameter a, hkInt128Vector4Parameter b)  {   m_x.setAnd(a.m_x, b.m_x);   }
template <> inline void hkInt128Vector4::setAnd<2>(hkInt128Vector4Parameter a, hkInt128Vector4Parameter b)  {   m_x.setAnd(a.m_x, b.m_x);   m_y.setAnd(a.m_y, b.m_y);   }
template <> inline void hkInt128Vector4::setAnd<3>(hkInt128Vector4Parameter a, hkInt128Vector4Parameter b)  {   m_x.setAnd(a.m_x, b.m_x);   m_y.setAnd(a.m_y, b.m_y);   m_z.setAnd(a.m_z, b.m_z);   }
template <> inline void hkInt128Vector4::setAnd<4>(hkInt128Vector4Parameter a, hkInt128Vector4Parameter b)  {   m_x.setAnd(a.m_x, b.m_x);   m_y.setAnd(a.m_y, b.m_y);   m_z.setAnd(a.m_z, b.m_z);   m_w.setAnd(a.m_w, b.m_w);   }

namespace hkInt128Vector4Impl
{
    template <int N, int I> struct ShlHelper{};
    template <int I> struct ShlHelper<1, I>
    {
        static inline void exec(hkInt128Vector4Parameter vSrc, hkInt128Vector4& vDst)
        {
            vDst.m_x.setShiftLeft(vSrc.m_x, I);
        }
    };
    template <int I> struct ShlHelper<2, I>
    {
        static inline void exec(hkInt128Vector4Parameter vSrc, hkInt128Vector4& vDst)
        {
            vDst.m_x.setShiftLeft(vSrc.m_x, I);
            vDst.m_y.setShiftLeft(vSrc.m_y, I);
        }
    };
    template <int I> struct ShlHelper<3, I>
    {
        static inline void exec(hkInt128Vector4Parameter vSrc, hkInt128Vector4& vDst)
        {
            vDst.m_x.setShiftLeft(vSrc.m_x, I);
            vDst.m_y.setShiftLeft(vSrc.m_y, I);
            vDst.m_z.setShiftLeft(vSrc.m_z, I);
        }
    };
    template <int I> struct ShlHelper<4, I>
    {
        static inline void exec(hkInt128Vector4Parameter vSrc, hkInt128Vector4& vDst)
        {
            vDst.m_x.setShiftLeft(vSrc.m_x, I);
            vDst.m_y.setShiftLeft(vSrc.m_y, I);
            vDst.m_z.setShiftLeft(vSrc.m_z, I);
            vDst.m_w.setShiftLeft(vSrc.m_w, I);
        }
    };
}

//
//  Sets this = a << I per component

template <int N, int I>
inline void hkInt128Vector4::setShiftLeft(hkInt128Vector4Parameter v)
{
    hkInt128Vector4Impl::ShlHelper<N, I>(v, *this);
}

//
//  Returns this == 0

template <> inline const hkVector4fComparison hkInt128Vector4::equalZero<3>() const
{
    hkVector4fComparison::Mask mask = hkVector4ComparisonMask::MASK_NONE;
    if (m_x.equalZero())
    {
        mask = hkVector4ComparisonMask::Mask(mask | hkVector4ComparisonMask::MASK_X);
    }
    if (m_y.equalZero())
    {
        mask = hkVector4ComparisonMask::Mask(mask | hkVector4ComparisonMask::MASK_Y);
    }
    if (m_z.equalZero())
    {
        mask = hkVector4ComparisonMask::Mask(mask | hkVector4ComparisonMask::MASK_Z);
    }

    hkVector4fComparison cmpXYZ;
    cmpXYZ.set(mask);
    return cmpXYZ;
}

template <> inline const hkVector4fComparison hkInt128Vector4::equalZero<4>() const
{
    hkVector4fComparison::Mask mask = hkVector4ComparisonMask::MASK_NONE;
    if (m_x.equalZero())
    {
        mask = hkVector4ComparisonMask::Mask(mask | hkVector4ComparisonMask::MASK_X);
    }
    if (m_y.equalZero())
    {
        mask = hkVector4ComparisonMask::Mask(mask | hkVector4ComparisonMask::MASK_Y);
    }
    if (m_z.equalZero())
    {
        mask = hkVector4ComparisonMask::Mask(mask | hkVector4ComparisonMask::MASK_Z);
    }
    if (m_w.equalZero())
    {
        mask = hkVector4ComparisonMask::Mask(mask | hkVector4ComparisonMask::MASK_W);
    }

    hkVector4fComparison cmpXYZW;
    cmpXYZW.set(mask);
    return cmpXYZW;
}

//
//  Returns this != 0

template <int N>
inline const hkVector4fComparison hkInt128Vector4::notEqualZero() const
{
    hkVector4fComparison cmpEq; cmpEq.setNot(equalZero<N>());
    return cmpEq;
}

//
//  Sets this = vA * vB

template <> inline void hkInt128Vector4::setMul<3>(hkInt64Vector4Parameter vA, hkInt64Vector4Parameter vB)
{
    m_x.setMul(vA.getComponent<0>(), vB.getComponent<0>());
    m_y.setMul(vA.getComponent<1>(), vB.getComponent<1>());
    m_z.setMul(vA.getComponent<2>(), vB.getComponent<2>());
}

template <> inline void hkInt128Vector4::setMul<4>(hkInt64Vector4Parameter vA, hkInt64Vector4Parameter vB)
{
    m_x.setMul(vA.getComponent<0>(), vB.getComponent<0>());
    m_z.setMul(vA.getComponent<1>(), vB.getComponent<1>());
    m_y.setMul(vA.getComponent<2>(), vB.getComponent<2>());
    m_w.setMul(vA.getComponent<3>(), vB.getComponent<3>());
}

//
//  Sets this = sA * vB

template <> inline void hkInt128Vector4::setMul<1>(const hkInt128& sA, hkInt64Vector4Parameter vB)  {   m_x.setMul(sA, vB.getComponent<0>());   }
template <> inline void hkInt128Vector4::setMul<2>(const hkInt128& sA, hkInt64Vector4Parameter vB)  {   m_x.setMul(sA, vB.getComponent<0>());   m_y.setMul(sA, vB.getComponent<1>());   }
template <> inline void hkInt128Vector4::setMul<3>(const hkInt128& sA, hkInt64Vector4Parameter vB)  {   m_x.setMul(sA, vB.getComponent<0>());   m_y.setMul(sA, vB.getComponent<1>());   m_z.setMul(sA, vB.getComponent<2>());   }
template <> inline void hkInt128Vector4::setMul<4>(const hkInt128& sA, hkInt64Vector4Parameter vB)  {   m_x.setMul(sA, vB.getComponent<0>());   m_y.setMul(sA, vB.getComponent<1>());   m_z.setMul(sA, vB.getComponent<2>());   m_w.setMul(sA, vB.getComponent<3>());   }

//
//  Sets this = vA - vB

template <> inline void hkInt128Vector4::setSub<1>(hkInt128Vector4Parameter vA, hkInt128Vector4Parameter vB)    {   m_x.setSub(vA.m_x, vB.m_x); }
template <> inline void hkInt128Vector4::setSub<2>(hkInt128Vector4Parameter vA, hkInt128Vector4Parameter vB)    {   m_x.setSub(vA.m_x, vB.m_x); m_y.setSub(vA.m_y, vB.m_y); }
template <> inline void hkInt128Vector4::setSub<3>(hkInt128Vector4Parameter vA, hkInt128Vector4Parameter vB)    {   m_x.setSub(vA.m_x, vB.m_x); m_y.setSub(vA.m_y, vB.m_y); m_z.setSub(vA.m_z, vB.m_z); }
template <> inline void hkInt128Vector4::setSub<4>(hkInt128Vector4Parameter vA, hkInt128Vector4Parameter vB)    {   m_x.setSub(vA.m_x, vB.m_x); m_y.setSub(vA.m_y, vB.m_y); m_z.setSub(vA.m_z, vB.m_z); m_w.setSub(vA.m_w, vB.m_w); }

//
//  Sets this -= sa * vB

template <int N>
inline void hkInt128Vector4::subMul(const hkInt128& sA, hkInt64Vector4Parameter vB)
{
    hkInt128Vector4 ab; ab.setMul<N>(sA, vB);
    setSub<N>(*this, ab);
}

//
//  Returns the dot product of this and v using the first I components

template <>
inline const hkInt256 hkInt128Vector4::dot<3>(hkInt64Vector4Parameter v)
{
    hkInt256 vx;    vx.setMul(m_x, v.getComponent<0>());
    hkInt256 vy;    vy.setMul(m_y, v.getComponent<1>());
    hkInt256 vz;    vz.setMul(m_z, v.getComponent<2>());

    vx.setAdd(vx, vy);
    vx.setAdd(vx, vz);
    return vx;
}

template <>
inline const hkInt256 hkInt128Vector4::dot<3>(hkInt128Vector4Parameter v)
{
    hkInt256 ret;
    ret.setMul(m_x, v.m_x);
    ret.addMul(m_y, v.m_y);
    ret.addMul(m_z, v.m_z);
    return ret;
}

//
//  Sets this = Cross[vA, vB]

inline void hkInt128Vector4::setCross(hkInt64Vector4Parameter vA, hkInt64Vector4Parameter vB)
{
    // Permute vectors
    hkInt64Vector4 a_yzx;   a_yzx.setPermutation<hkVectorPermutation::YZXW>(vA);    // [ay, az, ax]
    hkInt64Vector4 a_zxy;   a_zxy.setPermutation<hkVectorPermutation::ZXYW>(vA);    // [az, ax, ay]
    hkInt64Vector4 b_yzx;   b_yzx.setPermutation<hkVectorPermutation::YZXW>(vB);    // [by, bz, bx]
    hkInt64Vector4 b_zxy;   b_zxy.setPermutation<hkVectorPermutation::ZXYW>(vB);    // [bz, bx, by]

    hkInt128Vector4 abp;    abp.setMul<3>(a_yzx, b_zxy);    // [aybz, azbx, axby]
    hkInt128Vector4 abn;    abn.setMul<3>(a_zxy, b_yzx);    // [azby, axbz, aybx]
    setSub<3>(abp, abn);    // [aybz - azby, azbx - axbz, axby - aybx]
}

//
//  Returns the i-th component

inline const hkInt128 hkInt128Vector4::getComponent(int i) const
{
    return reinterpret_cast<const hkInt128*>(this)[i];
}

//
//  Sets this = a / b. Both a and b are assumed to be unsigned!

template <> inline void hkInt128Vector4::setUnsignedDiv<1>(hkInt128Vector4Parameter a, hkInt128Vector4Parameter b)  {   m_x.setUnsignedDiv(a.m_x, b.m_x);   }
template <> inline void hkInt128Vector4::setUnsignedDiv<2>(hkInt128Vector4Parameter a, hkInt128Vector4Parameter b)  {   m_x.setUnsignedDiv(a.m_x, b.m_x);   m_y.setUnsignedDiv(a.m_y, b.m_y);   }
template <> inline void hkInt128Vector4::setUnsignedDiv<3>(hkInt128Vector4Parameter a, hkInt128Vector4Parameter b)  {   m_x.setUnsignedDiv(a.m_x, b.m_x);   m_y.setUnsignedDiv(a.m_y, b.m_y);   m_z.setUnsignedDiv(a.m_z, b.m_z);   }
template <> inline void hkInt128Vector4::setUnsignedDiv<4>(hkInt128Vector4Parameter a, hkInt128Vector4Parameter b)  {   m_x.setUnsignedDiv(a.m_x, b.m_x);   m_y.setUnsignedDiv(a.m_y, b.m_y);   m_z.setUnsignedDiv(a.m_z, b.m_z);   m_w.setUnsignedDiv(a.m_w, b.m_w);   }

//
//  Returns the index of the component with the largest signed value among the first N components.
//  In case of equality, returns the last component index given X,Y,Z,W ordering.

template <> inline int hkInt128Vector4::getIndexOfMaxComponent<3>() const
{
    // Shuffle
    hkInt128Vector4 xxy;    xxy.m_x = m_x;  xxy.m_y = m_x;  xxy.m_z = m_y;  // [x, x, y]
    hkInt128Vector4 yzz;    yzz.m_x = m_y;  yzz.m_y = m_z;  yzz.m_z = m_z;  // [y, z, z]

    // Compare
    const hkVector4fComparison cmp = yzz.less<3>(xxy);  // [*, y > z, x > z, x > y]
    const int mask = (cmp.getMask() & 7) << 1;
    return (0x192A >> mask) & 3;
}

//
//  Returns this < v

template <int N>
inline const hkVector4fComparison hkInt128Vector4::less(hkInt128Vector4Parameter v) const
{
    hkInt128Vector4 amb;    amb.setSub<N>(*this, v);
    return amb.lessZero();
}

inline const hkVector4fComparison hkInt128Vector4::lessZero() const
{
    hkVector4ComparisonMask::Mask mask;
    mask = (hkVector4ComparisonMask::Mask)
        (
        ((m_x.lessZero()) ? hkVector4ComparisonMask::MASK_X : hkVector4ComparisonMask::MASK_NONE) |
        ((m_y.lessZero()) ? hkVector4ComparisonMask::MASK_Y : hkVector4ComparisonMask::MASK_NONE) |
        ((m_z.lessZero()) ? hkVector4ComparisonMask::MASK_Z : hkVector4ComparisonMask::MASK_NONE) |
        ((m_w.lessZero()) ? hkVector4ComparisonMask::MASK_W : hkVector4ComparisonMask::MASK_NONE)
        );
    hkVector4fComparison cmp;
    cmp.set(mask);
    return cmp;
}

template <> inline void hkInt128Vector4::setFlipSign<3>(hkInt128Vector4Parameter v, hkVector4fComparisonParameter signFlip)
{
    hkVector4ComparisonMask::Mask mask = signFlip.getMask();

    if (mask & hkVector4ComparisonMask::MASK_X)
    {
        m_x.setNeg(v.m_x);
    }
    else
    {
        m_x = v.m_x;
    }

    if (mask & hkVector4ComparisonMask::MASK_Y)
    {
        m_y.setNeg(v.m_y);
    }
    else
    {
        m_y = v.m_y;
    }

    if (mask & hkVector4ComparisonMask::MASK_Z)
    {
        m_z.setNeg(v.m_z);
    }
    else
    {
        m_z = v.m_z;
    }
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
