// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

struct hkFloat3;

/// Helper class needed for hkFloat3::operator()
struct  hkFloat3Ref: public hkVector4f
{
    HK_INLINE ~hkFloat3Ref()                        { store<3>((float*)m_target); }
    HK_ALWAYS_INLINE void operator=( hkVector4f_ v)    { ((hkVector4f&)*this) = v; }

    hkFloat3* m_target;
};

/// Storage class to store 3 floats. Note that this class is not meant to be used for calculations, use hkVector4f for
/// temporary variables to avoid the conversion from a SIMD register to a float 3 in memory.
struct hkFloat3
{
    HK_DECLARE_CLASS( hkFloat3, New, Pod );
    HK_DETAIL_DECLARE_REFLECT_EXPORT( hkFloat3, HK_EXPORT_COMMON );


    HK_ALWAYS_INLINE hkFloat3(){ }

    HK_ALWAYS_INLINE        hkFloat3( hkVector4f_ v )           { v.store<3>(&m_x); }
    HK_ALWAYS_INLINE const  hkFloat3& operator=( hkVector4f_ v) { v.store<3>(&m_x); return *this; }

    HK_ALWAYS_INLINE operator const hkVector4f() const          { hkVector4f r; r.load<3>(&m_x); r.zeroComponent<3>(); return r; }
    HK_ALWAYS_INLINE const hkVector4f asVec4() const            { hkVector4f r; r.load<3>(&m_x); r.zeroComponent<3>(); return r; }
    HK_ALWAYS_INLINE hkFloat3Ref operator ()()               { hkFloat3Ref r; r.m_target = this; r.load<3>((float*)this); r.zeroComponent<3>(); return r; }

    HK_ALWAYS_INLINE void operator+=( hkVector4f_   a ) {   hkVector4f r; r.load<3>(&m_x);r+= a;    r.store<3>(&m_x); }
    HK_ALWAYS_INLINE void operator-=( hkVector4f_   a ) {   hkVector4f r; r.load<3>(&m_x);r-= a;    r.store<3>(&m_x);   }
    HK_ALWAYS_INLINE void operator*=( hkVector4f_   a ) {   hkVector4f r; r.load<3>(&m_x);r*= a;    r.store<3>(&m_x);   }
    HK_ALWAYS_INLINE void operator*=( hkSimdFloat32_ a )    {   hkVector4f r; r.load<3>(&m_x);r*= a;    r.store<3>(&m_x);   }
    HK_INLINE        void operator/=( hkVector4f_   a ) {   hkVector4f r; r.load<3>(&m_x);r/= a;    r.store<3>(&m_x);   }
    HK_INLINE        void operator/=( hkSimdFloat32_ a )    {   hkVector4f r; r.load<3>(&m_x);r/= a;    r.store<3>(&m_x);   }

    // simple forward declares to avoid using the operator()
    HK_ALWAYS_INLINE hkVector4f operator+( hkVector4f_   a ) const { hkVector4f r; r.setAdd( asVec4(), a ); return r; } ///< this += a
    HK_ALWAYS_INLINE hkVector4f operator-( hkVector4f_   a ) const { hkVector4f r; r.setSub( asVec4(), a ); return r; } ///< this -= a
    HK_ALWAYS_INLINE hkVector4f operator-(            )   const { hkVector4f r; r.setSub( hkVector4f::getZero(), *this );   return r; } ///< -this
    HK_ALWAYS_INLINE hkVector4f operator*( hkVector4f_   a ) const { hkVector4f r; r.setMul( asVec4(), a ); return r; } ///< this *= a
    HK_ALWAYS_INLINE hkVector4f operator*( hkSimdFloat32_ a ) const { hkVector4f r; r.setMul( asVec4(), a );    return r; } ///< this *= a
    HK_INLINE        hkVector4f operator/( hkVector4f_   a ) const { hkVector4f r; r.setDiv( asVec4(), a ); return r; } ///< this /= a, 23bit accuracy, no division by zero checks
    HK_INLINE        hkVector4f operator/( hkSimdFloat32_ a ) const { hkVector4f r; r.setDiv( asVec4(), a );    return r; } ///< this /= a, 23bit accuracy, no division by zero checks

    float m_x,m_y,m_z;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
