// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL !REFLECT
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

// compile time error checking
#define HK_VECTOR4_SUBINDEX_CHECK           static_assert((I>=0)&&(I<4), "hkVector4 index out of range")
#define HK_VECTOR4_NOT_IMPLEMENTED          static_assert(N==0, "hkVector4 not implemented for this vector length")
#define HK_VECTOR4_UNSUPPORTED_LENGTH_CHECK static_assert((N>0)&&(N<=4), "hkVector4 unsupported vector length")
#define HK_VECTOR4_TEMPLATE_CONFIG_NOT_IMPLEMENTED static_assert(A<0, "hkVector4 template configuration not implemented")
#define HK_VECTOR4_CONSTANT_CHECK           static_assert(((vectorConstant>HK_QUADREAL_BEGIN)&&(vectorConstant<HK_QUADREAL_END)),"hkVector4 unknown constant")
#define HK_MATRIX3_NOT_IMPLEMENTED          static_assert(N==0, "hkMatrix3 func not implemented")

#if defined(HK_PLATFORM_WIIU)
#   include <Common/Base/Math/Types/WiiU/hkWiiuMathTypes.h> // wiiU
#elif HK_CONFIG_SIMD == HK_CONFIG_SIMD_ENABLED
#   if defined(HK_COMPILER_HAS_INTRINSICS_IA32)
#       include <Common/Base/Math/Types/Sse/hkSseMathTypes.h>
#   elif defined(HK_COMPILER_HAS_INTRINSICS_NEON)
#       include <Common/Base/Math/Types/Neon/hkNeonMathTypes.h>
#   else // simd
#       error Unknown platform for SIMD
#   endif
#else // not simd
#   include <Common/Base/Math/Types/Fpu/hkFpuMathTypes.h>
#endif


#ifndef HK_MASK_TO_VECTORf
#define HK_MASK_TO_VECTORf(x) (hkQuadFloat32)x
#endif

#ifndef HK_MASK_TO_VECTORd
#define HK_MASK_TO_VECTORd(x) (hkQuadDouble64)x
#endif


extern HK_EXPORT_COMMON const hkQuadFloat32 g_vectorfConstants[HK_QUADREAL_END];
extern HK_EXPORT_COMMON const hkQuadDouble64 g_vectordConstants[HK_QUADREAL_END];
extern HK_EXPORT_COMMON HK_ALIGN16(const hkUint32 g_intVectorConstants[HK_QUADINT_END][4]);
extern HK_EXPORT_COMMON const unsigned int g_mantissaMaskf[4];
extern HK_EXPORT_COMMON const unsigned long long g_mantissaMaskd[2];

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
