// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL !REFLECT
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

// platform specific implementations
#if defined(HK_PLATFORM_WIIU) && defined(HK_ENABLE_PAIRED_SINGLE_OPTS)
#   include <Common/Base/Math/Vector/WiiU/hkWiiuVector4.inl>
#   include <Common/Base/Math/Vector/WiiU/hkWiiuVector4Comparison.inl>
#   include <Common/Base/Math/Vector/WiiU/hkWiiuSimdReal.inl>
#   include <Common/Base/Math/Vector/Fpu/hkFpuSimdReald.inl> 
#   include <Common/Base/Math/Vector/Fpu/hkFpuVector4d.inl> 
#   include <Common/Base/Math/Vector/Fpu/hkFpuVector4dComparison.inl> 
#elif HK_CONFIG_SIMD == HK_CONFIG_SIMD_ENABLED
#   if defined(HK_COMPILER_HAS_INTRINSICS_IA32)
#           include <Common/Base/Math/Vector/Sse/hkSseVector4.inl>
#           include <Common/Base/Math/Vector/Sse/hkSseVector4Comparison.inl>
#           include <Common/Base/Math/Vector/Sse/hkSseSimdReal.inl>
#if HK_SSE_VERSION >= 0x50
#           include <Common/Base/Math/Vector/Sse/hkSseVector4_D_AVX.inl>
#           include <Common/Base/Math/Vector/Sse/hkSseVector4Comparison_D_AVX.inl>
#else
#           include <Common/Base/Math/Vector/Sse/hkSseVector4_D.inl>
#           include <Common/Base/Math/Vector/Sse/hkSseVector4Comparison_D.inl>
#endif
#           include <Common/Base/Math/Vector/Sse/hkSseSimdReal_D.inl>
#   elif defined(HK_COMPILER_HAS_INTRINSICS_NEON)
#       include <Common/Base/Math/Vector/Neon/hkNeonVector4.inl>
#       include <Common/Base/Math/Vector/Neon/hkNeonVector4Comparison.inl>
#       include <Common/Base/Math/Vector/Neon/hkNeonSimdReal.inl>
#       include <Common/Base/Math/Vector/Fpu/hkFpuSimdReald.inl> 
#       include <Common/Base/Math/Vector/Fpu/hkFpuVector4d.inl> 
#       include <Common/Base/Math/Vector/Fpu/hkFpuVector4dComparison.inl> 
#   else
#       error Dont know how to do simd on this platform
#   endif
#else // no SIMD
#   include <Common/Base/Math/Vector/Fpu/hkFpuVector4.inl>
#   include <Common/Base/Math/Vector/Fpu/hkFpuVector4Comparison.inl> 
#   include <Common/Base/Math/Vector/Fpu/hkFpuSimdReal.inl> 
#endif // HK_CONFIG_SIMD

#include <Common/Base/Math/Vector/hkVector4f.inl>
#include <Common/Base/Math/Vector/hkVector4d.inl>

#include <Common/Base/Math/Vector/hkVector4fComparison.inl>
#include <Common/Base/Math/Vector/hkVector4dComparison.inl>

#include <Common/Base/Math/Vector/hkSimdFloat32.inl>
#include <Common/Base/Math/Vector/hkSimdDouble64.inl>

#include <Common/Base/Math/Matrix/hkMatrix3.inl>
#include <Common/Base/Math/Matrix/hkRotation.inl>

#include <Common/Base/Math/Matrix/hkMatrix4f.inl>

#include <Common/Base/Math/Quaternion/hkQuaternionf.inl>
#include <Common/Base/Math/Quaternion/hkQuaterniond.inl>

#include <Common/Base/Math/Matrix/hkTransformf.inl>
#include <Common/Base/Math/Matrix/hkTransformd.inl>

#include <Common/Base/Math/QsTransform/hkQsTransformf.inl>
#include <Common/Base/Math/QsTransform/hkQsTransformd.inl>

#include <Common/Base/Math/QTransform/hkQTransform.inl>

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
