// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

class hkVector4f;
class hkVector4d;

class hkVector4f;
class hkVector4d;
class hkVector4fComparison;
class hkVector4dComparison;
class hkSimdFloat32;
class hkSimdDouble64;
class hkQuaternionf;
class hkQuaterniond;

template<typename FT> class hkMatrix3Impl;
template<typename FT> class hkMatrix4Impl;
template<typename FT> class hkRotationImpl;

typedef  hkMatrix3Impl<float>  hkMatrix3f;
typedef  hkMatrix3Impl<double> hkMatrix3d;

typedef  hkMatrix4Impl<float>  hkMatrix4f;
typedef  hkMatrix4Impl<double> hkMatrix4d;

typedef hkRotationImpl<float> hkRotationf;
typedef hkRotationImpl<double> hkRotationd;

class hkTransformf;
class hkTransformd;
class hkQTransformf;
class hkQTransformd;
class hkQsTransformf;
class hkQsTransformd;
template <typename FT> class hkSymmetricMatrix3Impl;
typedef hkSymmetricMatrix3Impl<hkFloat32>  hkSymmetricMatrix3f;
typedef hkSymmetricMatrix3Impl<hkDouble64> hkSymmetricMatrix3d;
class hkRotationInverseF;


// Type discriminator for floating point resolution
template <typename POD>
struct HK_EXPORT_COMMON hkFloatTypes
{

};

// Specialization for single precision
template <>
struct HK_EXPORT_COMMON hkFloatTypes<hkFloat32>
{
    enum {ALIGN = 16 };

    typedef hkVector4f                      Vec4;
    typedef hkVector4f_                     Vec4_;
    typedef hkVector4f                      Vector;
    typedef hkQuaternionf                   Quaternion;
    typedef hkQuaternionfParameter          Quaternion_;
    typedef hkSimdFloat32                   Scalar;
    typedef hkSimdFloat32Parameter          Scalar_;
    typedef hkVector4fComparison            Comparison;
    typedef hkVector4fComparisonParameter   Comparison_;
    typedef hkFloat32                       Float;
    typedef hkMatrix3f                      Matrix3;
    typedef hkSymmetricMatrix3f             SymmetricMatrix3;
    typedef hkMatrix4f                      Matrix4;
    typedef hkRotationf                     Rotation;
    typedef hkTransformf                    Transform;
    typedef hkQTransformf                   QTransform;
    typedef hkQsTransformf                  QsTransform;

    static HK_ALWAYS_INLINE float epsilon(){ return HK_FLOAT_EPSILON; }
};

// Specialization for double precision
template <>
struct HK_EXPORT_COMMON hkFloatTypes<hkDouble64>
{
    enum {ALIGN = 32 };

    typedef hkVector4d                      Vec4;
    typedef hkVector4dParameter             Vec4_;
    typedef hkVector4d                      Vector;
    typedef hkQuaterniond                   Quaternion;
    typedef hkQuaterniondParameter          Quaternion_;
    typedef hkSimdDouble64                  Scalar;
    typedef hkSimdDouble64Parameter         Scalar_;
    typedef hkVector4dComparison            Comparison;
    typedef hkVector4dComparisonParameter   Comparison_;
    typedef hkDouble64                      Float;
    typedef hkMatrix3d                      Matrix3;
    typedef hkSymmetricMatrix3d             SymmetricMatrix3;
    typedef hkMatrix4d                      Matrix4;
    typedef hkRotationd                     Rotation;
    typedef hkTransformd                    Transform;
    typedef hkQTransformd                   QTransform;
    typedef hkQsTransformd                  QsTransform;

    static HK_ALWAYS_INLINE double epsilon(){ return HK_DOUBLE_EPSILON; }

};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
