// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

    /// Rigid transform that stores the rotation and translation as 12 hkFloat16 values (i.e. 3
    /// hkFloat16 4-vectors). The matrix is stored in column major format, with the translation
    /// encoded in the vectors' .w components.
class HK_EXPORT_COMMON hkFloat16Transform
{
    public:

        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_MATH, hkFloat16Transform);
        HK_DECLARE_REFLECTION();
        HK_DECLARE_POD_TYPE();
    public:

            /// Inlined. Sets this transform from a hkTransformf.
        template <hkMathRoundingMode R>
        HK_INLINE void _set(const hkTransformf& transformIn);
            /// Inlined. Sets this transform from a hkTransformf.
        template <hkMathRoundingMode R>
        HK_INLINE void _set(const hkTransformd& transformIn);

            /// Sets this transform from a hkTransformf.
        template <hkMathRoundingMode R>
        void set(const hkTransformf& transformIn);

            /// Sets this transform from a hkTransformd.
        template <hkMathRoundingMode R>
        void set(const hkTransformd& transformIn);

            /// Inlined. Converts this to a hkTransformf.
        HK_INLINE void _getTransform(hkTransformf& transformOut) const;

            /// Inlined. Converts this to a hkTransformd.
        HK_INLINE void _getTransform(hkTransformd& transformOut) const;

            /// Converts this to a hkTransformf.
        void getTransform(hkTransformf& transformOut) const;

            /// Converts this to a hkTransformd.
        void getTransform(hkTransformd& transformOut) const;

            /// Read-only access to the columns
        template <int I>
        HK_INLINE _Ret_notnull_ const hkFloat16* getColumn() const { return &m_elements[I << 2]; }

            /// Read-write access to the columns
        template <int I>
        HK_INLINE _Ret_notnull_ hkFloat16* getColumn() { return &m_elements[I << 2]; }

    protected:

            /// The matrix elements
        hkFloat16 m_elements[12];
};

#include <Common/Base/Math/Float16Transform/hkFloat16Transform.inl>

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
