; TKBMS v1.0 -----------------------------------------------------
;
; PLATFORM       : X64 DURANGO METRO_X64 UWP_X64
; PRODUCT        : COMMON
; VISIBILITY     : PUBLIC
;
; ------------------------------------------------------TKBMS v1.0

IFNDEF HK_BUILDING_WITH_ENGINE

; Computes the quotient and remainder of a 128 bit unsigned integer, divided by a 64 bit
; unsigned integer. The quotient must fit in a 64 bit integer.
;
; The arguments are:
; RCX       Low u64
; RDX       High u64
; R8        Divisor (u64)
; R9        *Remainder pointer (u64)
;
; Which corresponds to the C/C++ function with prototype:
;
; extern "C" hkUint64 hkDivModUint128Uint64(hkUint64 uLow, hkUint64 uHigh, hkUint64 v, hkUint64* rOut);

.code
hkDivModUint128Uint64 proc
    mov rax, rcx
    div r8
    mov [r9], rdx
    ret
hkDivModUint128Uint64 endp

; Computes the quotient of a 128 bit unsigned integer, divided by a 64 bit unsigned
; integer. The quotient must fit in a 64 bit integer.
;
; The arguments are:
; RCX       Low u64
; RDX       High u64
; R8        Divisor (u64)
;
; Which corresponds to the C/C++ function with prototype:
;
; extern "C" hkUint64 hkDivUint128Uint64(hkUint64 uLow, hkUint64 uHigh, hkUint64 v);

.code
hkDivUint128Uint64 proc
    mov rax, rcx
    div r8
    ret
hkDivUint128Uint64 endp

ENDIF

END

;
; Havok SDK - Base file, BUILD(#20171210)
; 
; Confidential Information of Microsoft Corporation.
; Not for disclosure or distribution without Microsoft's prior written
; consent.  This software contains code, techniques and know-how which
; is confidential and proprietary to Microsoft.  Product and Trade Secret
; source code contains trade secrets of Microsoft.  Havok Software (C)
; Copyright 1999-2017 Microsoft Corporation.
; All Rights Reserved. Use of this software is subject to the
; terms of an end user license agreement.
; 
; The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
; Title, ownership rights, and intellectual property rights in the Havok
; software remain in Microsoft and/or its suppliers.
; 
; Use of this software for evaluation purposes is subject to and
; indicates acceptance of the End User licence Agreement for this
; product. A copy of the license is included with this software and is
; also available from Havok Support.
; 
;
