// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

inline bool hkAxialTransform::operator == (const hkAxialTransform& b) const
{
    return m_rotation == b.m_rotation && m_translation.allExactlyEqual<3>(b.m_translation);
}

inline void hkAxialTransform::setIdentity()
{
    m_rotation.setIdentity();
    m_translation.setZero();
}

inline const hkVector4& hkAxialTransform::getTranslation() const
{
    return m_translation;
}

inline void hkAxialTransform::setTranslation(hkVector4_ translation)
{
    m_translation = translation;
}

inline void hkAxialTransform::setRotation(const hkAxialRotation& rot)
{
    m_rotation = rot;
}

inline void hkAxialTransform::set(hkVector4_ trans, const hkAxialRotation& rot)
{
    m_translation = trans;
    m_rotation = rot;
}

inline void hkAxialTransform::transformPos(hkVector4& v) const
{
    m_rotation.rotateVector(v);
    v.add(m_translation);
}
inline void hkAxialTransform::transformInversePos(hkVector4& v) const
{
    v.sub(m_translation);
    m_rotation.rotateInverseVector(v);
}

inline void hkAxialTransform::transformDir(hkVector4& v) const
{
    m_rotation.rotateVector(v);
}

inline void hkAxialTransform::transformAabb(hkAabb& aabb) const
{
    m_rotation.rotateAabb(aabb);
    aabb.m_min.add(m_translation);
    aabb.m_max.add(m_translation);
}

inline void hkAxialTransform::transformInverseAabb(hkAabb& aabb) const
{
    aabb.m_min.sub(m_translation);
    aabb.m_max.sub(m_translation);
    m_rotation.rotateInverseAabb(aabb);
}

inline void hkAxialTransform::getTransform(hkTransform& transformOut) const
{
    m_rotation.getRotation(transformOut.getRotation());
    transformOut.setTranslation(m_translation);
}

inline void hkAxialTransform::setMul(const hkAxialTransform& a, const hkAxialTransform& b)
{
    m_rotation.setComposition(a.m_rotation, b.m_rotation);

    hkVector4 rotatedBTranslation = b.m_translation;
    a.m_rotation.rotateVector(rotatedBTranslation);
    m_translation = a.m_translation + rotatedBTranslation;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
