// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Common/Base/Math/AxialTransform/hkAxialRotation.h>
#include <Common/Base/Types/Geometry/Aabb/hkAabb.h>

/// A transform, which preserves the property of being axis aligned.
class HK_EXPORT_COMMON hkAxialTransform
{
public:
    HK_DECLARE_CLASS(hkAxialTransform, New, Reflect);

    hkAxialTransform() { }
    hkAxialTransform(const hkAxialTransform& src)
        : m_rotation(src.m_rotation),
        m_translation(src.m_translation)
    {
    }

    inline bool operator == (const hkAxialTransform& b) const;

    /// Sets this transform to the identity transform.
    inline void setIdentity();

    /// Gets the translation component.
    inline const hkVector4& getTranslation() const;

    /// Sets the translation component.
    inline void setTranslation(hkVector4_ t);

    /// Sets the rotation component.
    inline void setRotation(const hkAxialRotation& rot);

    /// Sets the translation and rotation component.
    inline void set(hkVector4_ trans, const hkAxialRotation& rot);

    /// Applies this transform to the given vector, representing a position.
    inline void transformPos(hkVector4& v) const;

    /// Applies the inverse of this transform to the given vector, representing a position.
    inline void transformInversePos(hkVector4& v) const;

    /// Applies this transform to the given vector, representing a direction.
    inline void transformDir(hkVector4& v) const;

    /// Applies this transform to the given aabb.
    inline void transformAabb(hkAabb& aabb) const;

    /// Applies the inverse of this transform to the given aabb.
    inline void transformInverseAabb(hkAabb& aabb) const;

    /// Convert to a real transform.
    inline void getTransform(hkTransform& transformOut) const;

    inline void setMul(const hkAxialTransform& a, const hkAxialTransform& b);

private:
    hkAxialRotation m_rotation;
    hkVector4 m_translation;
};

#include <Common/Base/Math/AxialTransform/hkAxialTransform.inl>

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
