// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Base/Container/String/hkString.h>
#include <Common/Base/Math/Vector/hkIntVector.h>

inline void hkAxialRotation::setIdentity()
{
    m_tag = HK_AXIAL_ROT_IDENTITY;
}

inline hkAxialRotation hkAxialRotation::getConstant(hkAxialRotationTag tag)
{
    hkAxialRotation ret;
    ret.m_tag = (hkUint8)tag;
    return ret;
}

inline void hkAxialRotation::setComposition(const hkAxialRotation& a, const hkAxialRotation& b)
{
    m_tag = (hkAxialRotationTag)s_multTable[a.m_tag][b.m_tag];
}

inline void hkAxialRotation::setInverse(const hkAxialRotation& a)
{
    m_tag = s_inverseTable[a.m_tag];
}

inline void hkAxialRotation::rotateX90Deg()
{
    m_tag = s_multTable[HK_AXIAL_ROT_X90][m_tag];
}

inline void hkAxialRotation::rotateY90Deg()
{
    m_tag = s_multTable[HK_AXIAL_ROT_Y90][m_tag];
}

inline void hkAxialRotation::rotateZ90Deg()
{
    m_tag = s_multTable[HK_AXIAL_ROT_Z90][m_tag];
}

inline void hkAxialRotation::getRotation(hkRotation& rot) const
{
    rot.setIdentity();
    rotateVector(rot.m_col0);
    rotateVector(rot.m_col1);
    rotateVector(rot.m_col2);
}

inline void hkAxialRotation::rotateVector(hkVector4& v)  const
{
    if(m_tag != 0)
    {
        // Each m_tag corresponds to a certain permutation of v. To get the correct permutation,
        // we take the original permutation v, along with two other permutations perm1 and perm2,
        // such that for each output position i, there's one of v, perm1, perm2, which has the
        // required value at position i
        //
        //  v'[i] = select(m_tag, i, v[i], perm1[i], perm2[i]);
        //
        // The constants assigned to perm1Masks and perm2Masks have a bit set at index 31 - i, iff
        // the value to be selected is the one in perm1 or perm2 respectively. If neither perm1Masks nor
        // perm2Masks have this bit set, the value in v should be used.
        hkVector4 perm1, perm2;
        perm1.setPermutation<hkVectorPermutation::YZXW>(v);
        perm2.setPermutation<hkVectorPermutation::ZXYW>(v);

        hkIntVector perm1Masks, perm2Masks;
        perm1Masks.set(0x016a8300, 0x502ab000, 0x0a2a8c00, 0);
        perm2Masks.set(0x0a154c00, 0x01554300, 0x50157000, 0);

        // Shift the relevant bit to the most significant position.
        perm1Masks.setShiftLeft32(perm1Masks, m_tag);
        perm2Masks.setShiftLeft32(perm2Masks, m_tag);

#if defined(HK_REAL_IS_FLOAT) && (HK_CONFIG_SIMD == HK_CONFIG_SIMD_ENABLED) && defined(HK_COMPILER_HAS_INTRINSICS_IA32) && HK_SSE_VERSION >= 0x41
        // Select according to the most significant bit in perm1Masks/perm2Masks.
        v.m_quad = _mm_blendv_ps(v.m_quad, perm1.m_quad, _mm_castsi128_ps(perm1Masks.m_quad));
        v.m_quad = _mm_blendv_ps(v.m_quad, perm2.m_quad, _mm_castsi128_ps(perm2Masks.m_quad));
#else
        v.setSelect(perm1Masks.lessZeroS32(), perm1, v);
        v.setSelect(perm2Masks.lessZeroS32(), perm2, v);
#endif

        // Similarly, whether we have to apply a sign change is specified by the bit at index i.
        // We first shift everything to the right, to zero out bits to the right of bit i,
        // after that, we shift it all back, to get the relevant bit at the most significant position.
        // We then have a bitmask, we can xor with v, to induce the appropriate sign change.
        hkIntVector signMasks;
        signMasks.set(0xae71e0, 0xb9e306, 0xeb903c, 0);
        signMasks.setShiftRight32(signMasks, m_tag);
        signMasks.setShiftLeft32<31>(signMasks);
#if defined(HK_REAL_IS_FLOAT) && (HK_CONFIG_SIMD == HK_CONFIG_SIMD_ENABLED) && defined(HK_COMPILER_HAS_INTRINSICS_IA32)
        v.m_quad = _mm_castsi128_ps(_mm_xor_si128(_mm_castps_si128(v.m_quad), signMasks.m_quad));
#else
        v.setFlipSign(v, signMasks.lessZeroS32());
#endif
    }
}

inline void hkAxialRotation::rotateInverseVector(hkVector4& v) const
{
    hkAxialRotation inverse; inverse.setInverse(*this);
    inverse.rotateVector(v);
}

inline void hkAxialRotation::rotateAabb(hkAabb& aabb) const
{
    if(m_tag != 0)
    {
        hkAabb tmp = aabb;
        rotateVector(tmp.m_min);
        rotateVector(tmp.m_max);
        aabb.m_min.setMin(tmp.m_min, tmp.m_max);
        aabb.m_max.setMax(tmp.m_min, tmp.m_max);
    }
}

inline void hkAxialRotation::rotateInverseAabb(hkAabb& aabb) const
{
    hkAxialRotation inverse; inverse.setInverse(*this);
    inverse.rotateAabb(aabb);
}

inline hkBool32 hkAxialRotation::operator == (const hkAxialRotation& b) const
{
    return m_tag == b.m_tag;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
