// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/hkBase.h>
#include <Common/Base/Math/AxialTransform/hkAxialRotation.h>

const hkUint8 hkAxialRotation::s_multTable[24][24] =
{
    { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23 },
    { 1, 2, 3, 0, 11, 18, 13, 14, 19, 16, 9, 20, 7, 21, 23, 4, 22, 6, 8, 5, 15, 17, 10, 12 },
    { 2, 3, 0, 1, 20, 8, 21, 23, 5, 22, 16, 15, 14, 17, 12, 11, 10, 13, 19, 18, 4, 6, 9, 7 },
    { 3, 0, 1, 2, 15, 19, 17, 12, 18, 10, 22, 4, 23, 6, 7, 20, 9, 21, 5, 8, 11, 13, 16, 14 },
    { 4, 16, 21, 12, 5, 6, 0, 11, 20, 15, 3, 22, 18, 9, 1, 23, 19, 7, 10, 14, 2, 8, 17, 13 },
    { 5, 19, 8, 18, 6, 0, 4, 22, 2, 23, 12, 17, 10, 15, 16, 13, 14, 11, 3, 1, 21, 20, 7, 9 },
    { 6, 14, 20, 10, 0, 4, 5, 17, 21, 13, 18, 7, 3, 23, 19, 9, 1, 22, 12, 16, 8, 2, 11, 15 },
    { 7, 11, 22, 17, 12, 23, 14, 8, 9, 0, 6, 18, 21, 1, 20, 3, 4, 19, 13, 15, 10, 16, 5, 2 },
    { 8, 18, 5, 19, 21, 2, 20, 9, 0, 7, 14, 13, 16, 11, 10, 17, 12, 15, 1, 3, 6, 4, 23, 22 },
    { 9, 13, 23, 15, 16, 22, 10, 0, 7, 8, 20, 1, 4, 18, 6, 19, 21, 3, 11, 17, 14, 12, 2, 5 },
    { 10, 6, 14, 20, 9, 16, 22, 3, 12, 18, 11, 0, 15, 5, 17, 8, 13, 2, 4, 21, 7, 23, 1, 19 },
    { 11, 22, 17, 7, 18, 13, 1, 20, 15, 4, 0, 10, 8, 16, 2, 12, 5, 14, 9, 23, 3, 19, 6, 21 },
    { 12, 4, 16, 21, 23, 14, 7, 18, 10, 3, 17, 5, 13, 0, 11, 2, 15, 8, 6, 20, 22, 9, 19, 1 },
    { 13, 23, 15, 9, 1, 11, 18, 6, 17, 21, 8, 14, 0, 12, 5, 16, 2, 10, 7, 22, 19, 3, 20, 4 },
    { 14, 20, 10, 6, 7, 12, 23, 19, 16, 1, 13, 8, 17, 2, 15, 0, 11, 5, 21, 4, 9, 22, 18, 3 },
    { 15, 9, 13, 23, 19, 17, 3, 4, 11, 20, 2, 16, 5, 10, 0, 14, 8, 12, 22, 7, 1, 18, 21, 6 },
    { 16, 21, 12, 4, 22, 10, 9, 1, 14, 19, 15, 2, 11, 8, 13, 5, 17, 0, 20, 6, 23, 7, 3, 18 },
    { 17, 7, 11, 22, 3, 15, 19, 21, 13, 6, 5, 12, 2, 14, 8, 10, 0, 16, 23, 9, 18, 1, 4, 20 },
    { 18, 5, 19, 8, 13, 1, 11, 10, 3, 12, 7, 6, 9, 4, 22, 21, 23, 20, 0, 2, 17, 15, 14, 16 },
    { 19, 8, 18, 5, 17, 3, 15, 16, 1, 14, 23, 21, 22, 20, 9, 6, 7, 4, 2, 0, 13, 11, 12, 10 },
    { 20, 10, 6, 14, 8, 21, 2, 15, 4, 11, 1, 9, 19, 22, 3, 7, 18, 23, 16, 12, 0, 5, 13, 17 },
    { 21, 12, 4, 16, 2, 20, 8, 13, 6, 17, 19, 23, 1, 7, 18, 22, 3, 9, 14, 10, 5, 0, 15, 11 },
    { 22, 17, 7, 11, 10, 9, 16, 2, 23, 5, 4, 3, 20, 19, 21, 18, 6, 1, 15, 13, 12, 14, 0, 8 },
    { 23, 15, 9, 13, 14, 7, 12, 5, 22, 2, 21, 19, 6, 3, 4, 1, 20, 18, 17, 11, 16, 10, 8, 0 },
};

const hkUint8 hkAxialRotation::s_inverseTable[24] = { 0, 3, 2, 1, 6, 5, 4, 9, 8, 7, 11, 10, 13, 12, 15, 14, 17, 16, 18, 19, 20, 21, 22, 23 };

// hkAxialRotation::setRotation
//
// Let R and A be the rotation matrices for rot and axialRot respectively. At the beginning
// of each iteration, all columns to the left of i in R must already be reduced (ie. those columns must
// match the corresponding columns in the identity matrix). After each iteration, the column at index
// i will be reduced as well, while maintaining the condition that the product RA doesn't change.

template <int col, hkAxialRotationTag axialFlip>
static HK_INLINE void flipSign(hkRotation& rot, hkAxialRotation& axialRot)
{
    hkVector4& col1 = rot.getColumn<col>();
    hkVector4& col2 = rot.getColumn<col + 1>();

    col1.setNeg<4>(col1);
    col2.setNeg<4>(col2);

    axialRot.setComposition(hkAxialRotation::getConstant(axialFlip), axialRot);
}

template <int col1Idx, int col2Idx, hkAxialRotationTag axialExchange, hkAxialRotationTag invAxialExchange>
static HK_INLINE void exchangeCols(hkRotation& rot, hkAxialRotation& axialRot)
{
    hkVector4& col1 = rot.getColumn<col1Idx>();
    hkVector4& col2 = rot.getColumn<col2Idx>();

    hkMath::swap(col1, col2);

    if(col1.getComponent<col1Idx>().isLessZero())
    {
        col1.setNeg<4>(col1);

        axialRot.setComposition(hkAxialRotation::getConstant(axialExchange), axialRot);
    }
    else
    {
        col2.setNeg<4>(col2);

        axialRot.setComposition(hkAxialRotation::getConstant(invAxialExchange), axialRot);
    }
}

void hkAxialRotation::setRotation(const hkRotation& rot)
{
    hkRotation rest = rot;
    m_tag = HK_AXIAL_ROT_IDENTITY;

    {
        hkVector4 topRow;
        rest.getRow(0, topRow);
        int exhangeColIdx = topRow.getIndexOfMaxAbsComponent<3>();
        if(exhangeColIdx == 0)
        {
            if(topRow.getComponent<0>().isLessZero())
            {
                flipSign<0, HK_AXIAL_ROT_Z180>(rest, *this);
            }
        }
        else if(exhangeColIdx == 1)
        {
            exchangeCols<0, 1, HK_AXIAL_ROT_Z90, HK_AXIAL_ROT_Z270>(rest, *this);
        }
        else
        {
            HK_ASSERT_NO_MSG(0x5ce5605c, exhangeColIdx == 2);

            exchangeCols<0, 2, HK_AXIAL_ROT_Y270, HK_AXIAL_ROT_Y90>(rest, *this);
        }
    }

    hkVector4 row, absRow;
    rest.getRow<1>(row);
    absRow.setAbs(row);

    if(absRow.getComponent<1>() < absRow.getComponent<2>())
    {
        exchangeCols<1, 2, HK_AXIAL_ROT_X90, HK_AXIAL_ROT_X270>(rest, *this);
    }
    else if(rest.getElement<1, 1>().isLessZero())
    {
        flipSign<1, HK_AXIAL_ROT_X180>(rest, *this);
    }
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
