// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Common/Base/System/Io/Socket/hkSocket.h>
#include <Common/Base/DebugUtil/DeterminismUtil/hkCheckDeterminismUtil.h>
#include <Common/Base/Memory/System/hkMemorySystem.h>

class HK_EXPORT_COMMON hkMemoryExceptionTestingUtil
{
    public:
        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_BASE_CLASS, hkMemoryExceptionTestingUtil );
        hkMemoryExceptionTestingUtil();
        ~hkMemoryExceptionTestingUtil();

        static void HK_CALL create();
        static void HK_CALL destroy();
        static hkMemoryExceptionTestingUtil& HK_CALL getInstance();

        static void HK_CALL startNewDemo() { if (s_instance) s_instance->startNewDemoImpl(); }
        static void HK_CALL startFrame()   { if (s_instance) s_instance->startFrameImpl(); }
        static void HK_CALL endFrame()     { if (s_instance) s_instance->endFrameImpl(); }

        static void HK_CALL allowMemoryExceptions(bool allowMemExceptions) { if (s_instance) s_instance->allowMemoryExceptionsImpl(allowMemExceptions); }

        static bool HK_CALL isMemoryAvailable(int id) { if (s_instance) return s_instance->isMemoryAvailableImpl(id); return true; }


        void startNewDemoImpl();
        void startFrameImpl();
        void endFrameImpl();

        void allowMemoryExceptionsImpl(bool allowMemExceptions);

        bool isMemoryAvailableImpl(int id);

        static hkMemoryExceptionTestingUtil* s_instance;

        bool m_outOfMemory;

        int m_frameCounter;
        bool m_allowMemoryExceptions;

        enum{ MAX_CHECK_ID = 50};
        bool m_wasCheckIdThrown[MAX_CHECK_ID];
};

//#define HK_ENABLE_MEMORY_EXCEPTION_UTIL
HK_EXPORT_COMMON extern hkMemoryAllocator::MemoryState hkOutOfMemoryState;

HK_EXPORT_COMMON void HK_CALL hkSetOutOfMemoryState( hkMemoryAllocator::MemoryState state );

HK_INLINE hkMemoryAllocator::MemoryState hkGetOutOfMemoryState()
{
    return  hkOutOfMemoryState;
}

#if ! defined (HK_ENABLE_MEMORY_EXCEPTION_UTIL)
HK_INLINE bool hkMemoryStateIsOutOfMemory(int id)
{
    bool lowOnMem = hkGetOutOfMemoryState() == hkMemoryAllocator::MEMORY_STATE_OUT_OF_MEMORY;
    return lowOnMem;
}

HK_INLINE bool hkHasMemoryAvailable(int id, int size)
{
    bool hasAvailable = hkMemorySystem::getInstance().heapCanAllocTotal(size);
    return hasAvailable;
}
#else
HK_INLINE bool hkMemoryStateIsOutOfMemory(int id)
{
    if ( !hkMemoryExceptionTestingUtil::isMemoryAvailable(id) )
    {
        return true;
    }
    bool lowOnMem = hkGetOutOfMemoryState() == hkMemoryAllocator::MEMORY_STATE_OUT_OF_MEMORY;
    return lowOnMem;
}

HK_INLINE bool hkHasMemoryAvailable(int id, int size)
{
    if ( !hkMemoryExceptionTestingUtil::isMemoryAvailable(id) )
    {
        return false;
    }
    bool hasAvailable = hkMemorySystem::getInstance().heapCanAllocTotal(size);
    return hasAvailable;
}
#endif

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
