// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0


#include <Common/Base/hkBase.h>
#include <Common/Base/Types/hkBaseTypes.h>
#include <Common/Base/DebugUtil/MemoryExceptionTestingUtil/hkMemoryExceptionTestingUtil.h>

hkMemoryExceptionTestingUtil* hkMemoryExceptionTestingUtil::s_instance = HK_NULL;

hkMemoryAllocator::MemoryState hkOutOfMemoryState = hkMemoryAllocator::MEMORY_STATE_OK;

void hkSetOutOfMemoryState( hkMemoryAllocator::MemoryState state )
{
    hkOutOfMemoryState = state;
}


hkMemoryExceptionTestingUtil::hkMemoryExceptionTestingUtil()
{
    m_frameCounter = 0;
    m_frameCounter = 0;
    m_outOfMemory = false;
    m_allowMemoryExceptions = false;
}

hkMemoryExceptionTestingUtil::~hkMemoryExceptionTestingUtil()
{

}

void hkMemoryExceptionTestingUtil::create()
{
    delete s_instance;
    s_instance = new hkMemoryExceptionTestingUtil();
}

void hkMemoryExceptionTestingUtil::destroy()
{
    delete s_instance;
    s_instance = HK_NULL;
}

hkMemoryExceptionTestingUtil& hkMemoryExceptionTestingUtil::getInstance()
{
    return *s_instance;
}

void hkMemoryExceptionTestingUtil::startNewDemoImpl()
{
    m_frameCounter = 0;

    for (int i = 0; i < MAX_CHECK_ID; i++)
    {
        m_wasCheckIdThrown[i] = false;
    }

}


void hkMemoryExceptionTestingUtil::startFrameImpl()
{
    //getInstance().m_idToCauseOutOfMemoryException++;

    // reset out of memory conditions
    m_outOfMemory = false;
    m_frameCounter++;
}

void hkMemoryExceptionTestingUtil::endFrameImpl()
{
    // do nothing
}

void hkMemoryExceptionTestingUtil::allowMemoryExceptionsImpl(bool allowMemExceptions)
{
    m_allowMemoryExceptions = allowMemExceptions;
}

bool hkMemoryExceptionTestingUtil::isMemoryAvailableImpl(int id)
{
    if (m_outOfMemory && m_allowMemoryExceptions)
    {
        return false;
    }

    if (m_frameCounter > 50 && m_frameCounter % 3 == 0 && m_allowMemoryExceptions)
    {
        if (!m_wasCheckIdThrown[id])
        {
            m_wasCheckIdThrown[id] = true;
            m_outOfMemory = true;
            return false;
        }
    }

    return true;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
