// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Base/hkBase.h>
#include <Common/Base/DebugUtil/GlobalProperties/hkGlobalProperties.h>
#include <Common/Base/Thread/CriticalSection/hkCriticalSection.h>
#include <Common/Base/Object/hkSingleton.h>

HK_SINGLETON_IMPLEMENTATION(hkGlobalProperties);

// Used to buffer ::set call before the singleton is properly initialized.
struct hkGlobalProperties_PendingEntry
{
    const void* m_key;
    const void* m_value;
};

static int                              hkGlobalProperties_initialized = 0;
static int                              hkGlobalProperties_numPending = 0;
static hkGlobalProperties_PendingEntry  hkGlobalProperties_pending[32];

//
hkGlobalProperties::hkGlobalProperties()
{
    m_lock = new hkCriticalSection();
    m_data.reserve(1024);

    hkGlobalProperties_initialized = 1;
    for (int i = 0; i < hkGlobalProperties_numPending; ++i)
    {
        set(hkGlobalProperties_pending[i].m_key, hkGlobalProperties_pending[i].m_value);
    }
    hkGlobalProperties_numPending = 0;
}

//
hkGlobalProperties::~hkGlobalProperties()
{
    delete m_lock;
    hkGlobalProperties_initialized = 0;
}

//
void hkGlobalProperties::set(_In_opt_ const void* key, _In_opt_ const void* value)
{
    if (hkGlobalProperties_initialized)
    {
        m_lock->enter();
        m_data.insert(key, value);
        m_lock->leave();
    }
    else
    {
        hkGlobalProperties_PendingEntry& entry = hkGlobalProperties_pending[hkGlobalProperties_numPending++];
        entry.m_key = key;
        entry.m_value = value;
    }
}

//
_Ret_maybenull_ const void* hkGlobalProperties::get(_In_opt_ const void* key, _In_opt_ const void* defaultValue)
{
    if (hkGlobalProperties_initialized)
    {
        m_lock->enter();
        const void* value = m_data.getWithDefault(key, defaultValue);
        m_lock->leave();
        return value;
    }
    else
    {
        return defaultValue;
    }
}

//
void hkGlobalProperties::clear(_In_opt_ const void* key)
{
    if (hkGlobalProperties_initialized)
    {
        m_lock->enter();
        m_data.remove(key);
        m_lock->leave();
    }
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
