// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Common/Base/System/Io/Socket/hkSocket.h>
#include <Common/Base/DebugUtil/DeterminismUtil/hkCheckDeterminismUtil.h>

//#define HK_ENABLE_NETWORKED_DETERMINISM_UTIL

#if defined(HK_ENABLE_NETWORKED_DETERMINISM_UTIL) && !defined(HK_ENABLE_DETERMINISM_CHECKS)
#   error "Must enable HK_ENABLE_DETERMINISM_CHECKS when HK_ENABLE_NETWORKED_DETERMINISM_UTIL is used."
#endif

/// This is a utility that synchronizes one or multiple clients with one server.
/// The utility is plugged into the MenuDemo and synchronizes keyboard and gamePad input from the server to all clients.
/// This utility works in a synchronous way, all clients wait for data from server before processing.
/// And the server waits for clients to catch up.
class HK_EXPORT_COMMON hkNetworkedDeterminismUtil
{
    public:
        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_BASE_CLASS, hkNetworkedDeterminismUtil );
        hkNetworkedDeterminismUtil(_In_z_ const char* hostname, int port);
        ~hkNetworkedDeterminismUtil();

#if defined(HK_PLATFORM_DURANGO)
        static void HK_CALL create(_In_z_ const char* hostname = "127.0.0.1", int port = 57865);
#else
        static void HK_CALL create(_In_z_ const char* hostname = "127.0.0.1", int port = 7865);
#endif

        static void HK_CALL destroy();

        struct Command
        {
            HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE,Command);
            enum Type
            {
                TYPE_CONTROL,
                TYPE_DETERMINISM_DATA
            };

            int m_type;
            hkArray<hkUint8> m_data;
        };

        class Server
        {
            private:
                Server();
            public:
                HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_BASE_CLASS, Server );
                Server(int listeningPort, int maxNumClients);
                ~Server();

                void pollForNewClients();

                void sendCommand(const Command& command);

                void synchronizeWithClients();

            private:
                hkSocket* m_listeningSocket;
                hkArray<hkSocket*> m_clients;

                int m_maxNumClients;
        };

        class Client
        {
            private:
                Client();
            public:
                HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_BASE_CLASS, Client );
                Client(hkSocket* socket);
                ~Client();

                void sendSynchronizationBytes();

                void processCommands(Command::Type expectedCommandType);

            public:
                hkSocket* m_socket;
        };

        struct ControlCommand : public Command
        {
            HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_BASE_CLASS, ControlCommand );
            ControlCommand() { m_type = TYPE_CONTROL; }
            ControlCommand(_In_reads_bytes_(size) const void* data, int size);
            //void utiliseCommand(class hkDemoEnvironment* env) const;
        };

        struct DeterminismDataCommand : public Command
        {
            HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_BASE_CLASS, DeterminismDataCommand );
            DeterminismDataCommand(_In_reads_bytes_(bufferSize) const char* buffer, int bufferSize);
        };


        static bool HK_CALL isServer() { return s_instance ? s_instance->m_server != HK_NULL : false; }
        static bool HK_CALL isClient() { return s_instance ? s_instance->m_client != HK_NULL : false; }

        // The server should simply cache the command here for sending at the end of the step.
        static void HK_CALL startStepDemo(ControlCommand& controlCommand) { if (s_instance) s_instance->startStepDemoImpl(controlCommand); }
        static void HK_CALL endStepDemo() { if (s_instance) s_instance->endStepDemoImpl(); }


        void startStepDemoImpl(ControlCommand& controlCommand);
        void endStepDemoImpl();

    private:

        bool tryToCreateClient();
        void createServer();

        static hkResult HK_CALL readFromSocket(_Inout_ hkSocket* socket, _Out_writes_bytes_(size) void* buffer, int size);
        static hkResult HK_CALL writeToSocket(_Inout_ hkSocket* socket, _In_reads_bytes_(size) const void* buffer, int size);

    private:

        static hkNetworkedDeterminismUtil* s_instance;

        hkStringPtr m_serverAddress;
        int m_serverPort;

        Server* m_server;
        Client* m_client;

        ControlCommand m_controlCommand;


};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
