// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

template <typename ALIGN_OF_TYPE>
typename hkContainerAlignedHeapAllocator<ALIGN_OF_TYPE>::Allocator hkContainerAlignedHeapAllocator<ALIGN_OF_TYPE>::s_alloc;

template <typename ALIGN_OF_TYPE>
void* hkContainerAlignedHeapAllocator<ALIGN_OF_TYPE>::Allocator::blockAlloc(int numBytes)
{
    return hkMemoryRouter::alignedAlloc(hkMemoryRouter::getInstance().heap(), numBytes, HK_ALIGN_OF(ALIGN_OF_TYPE));
}

template <typename ALIGN_OF_TYPE>
void hkContainerAlignedHeapAllocator<ALIGN_OF_TYPE>::Allocator::blockFree(void* p, int numBytes)
{
    hkMemoryRouter::alignedFree(hkMemoryRouter::getInstance().heap(), p);
}

template <typename ALIGN_OF_TYPE>
void* hkContainerAlignedHeapAllocator<ALIGN_OF_TYPE>::Allocator::bufAlloc(int& reqNumBytesInOut)
{
    return hkMemoryRouter::alignedAlloc(hkMemoryRouter::getInstance().heap(), reqNumBytesInOut, HK_ALIGN_OF(ALIGN_OF_TYPE));
}

template <typename ALIGN_OF_TYPE>
void hkContainerAlignedHeapAllocator<ALIGN_OF_TYPE>::Allocator::bufFree(void* p, int numBytes)
{
    hkMemoryRouter::alignedFree(hkMemoryRouter::getInstance().heap(), p);
}

template <typename ALIGN_OF_TYPE>
void* hkContainerAlignedHeapAllocator<ALIGN_OF_TYPE>::Allocator::bufRealloc(void* pold, int oldNumBytes, int& reqNumBytesInOut)
{
    return hkMemoryRouter::alignedRealloc(hkMemoryRouter::getInstance().heap(), pold, oldNumBytes, reqNumBytesInOut, HK_ALIGN_OF(ALIGN_OF_TYPE));
}

template <typename ALIGN_OF_TYPE>
void hkContainerAlignedHeapAllocator<ALIGN_OF_TYPE>::Allocator::getMemoryStatistics(MemoryStatistics& u) const
{
    hkMemoryRouter::getInstance().heap().getMemoryStatistics(u);
}

template <typename ALIGN_OF_TYPE>
int hkContainerAlignedHeapAllocator<ALIGN_OF_TYPE>::Allocator::getAllocatedSize(const void* obj, int nbytes) const
{
    return hkMemoryRouter::getAlignedAllocatedSize(hkMemoryRouter::getInstance().heap(), obj, nbytes);
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
