// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

// These helper classes exist to allow containers to use different allocators
// without necessarily storing the allocator in the container.

    /// Forwards to the temp allocator
struct HK_EXPORT_COMMON hkContainerTempAllocator
{
    HK_DECLARE_CLASS(hkContainerTempAllocator, NewOpaque, Reflect);
    struct Allocator : public hkMemoryAllocator
    {
        HK_DECLARE_CLASS(Allocator, NewOpaque);
        virtual _Ret_notnull_ _Post_writable_byte_size_(numBytes) void* blockAlloc(int numBytes) HK_OVERRIDE;
        virtual void blockFree(_In_opt_bytecount_(numBytes) void* p, int numBytes ) HK_OVERRIDE;
        virtual _Ret_notnull_ _Post_writable_byte_size_(reqNumBytesInOut) void* bufAlloc(int& reqNumBytesInOut) HK_OVERRIDE;
        virtual void bufFree(_In_opt_bytecount_(numBytes) void* p, int numBytes ) HK_OVERRIDE;
        virtual _Ret_notnull_ _Post_writable_byte_size_(reqNumBytesInOut) void* bufRealloc(_In_reads_bytes_(oldNumBytes) void* pold, int oldNumBytes, int& reqNumBytesInOut ) HK_OVERRIDE;
        virtual void getMemoryStatistics( MemoryStatistics& u ) const HK_OVERRIDE;
        virtual int getAllocatedSize(_In_bytecount_(nbytes) const void* obj, int nbytes) const HK_OVERRIDE;
    };
    static Allocator s_alloc;
    hkMemoryAllocator& get(_In_opt_ const void*) { return s_alloc; }
};

    /// Forwards to the heap allocator
struct HK_EXPORT_COMMON hkContainerHeapAllocator
{
    HK_DECLARE_CLASS(hkContainerHeapAllocator, NewOpaque, Reflect);
    hkMemoryAllocator& get(_In_opt_ const void*) { return *hkMemHeapAllocator(); }
};

    /// Forwards to the debug allocator
struct HK_EXPORT_COMMON hkContainerDebugAllocator
{
    HK_DECLARE_CLASS(hkContainerDebugAllocator, NewOpaque, Reflect);
    struct Allocator : public hkMemoryAllocator
    {
        HK_DECLARE_CLASS(Allocator, NewOpaque);
        virtual _Ret_notnull_ _Post_writable_byte_size_(numBytes) void* blockAlloc(int numBytes) HK_OVERRIDE;
        virtual void blockFree(_In_opt_bytecount_(numBytes) void* p, int numBytes ) HK_OVERRIDE;
        virtual _Ret_notnull_ _Post_writable_byte_size_(reqNumBytesInOut) void* bufAlloc(int& reqNumBytesInOut) HK_OVERRIDE;
        virtual void bufFree(_In_opt_bytecount_(numBytes) void* p, int numBytes ) HK_OVERRIDE;
        virtual _Ret_notnull_ _Post_writable_byte_size_(reqNumBytesInOut) void* bufRealloc(_In_reads_bytes_(oldNumBytes) void* pold, int oldNumBytes, int& reqNumBytesInOut ) HK_OVERRIDE;
        virtual void getMemoryStatistics( MemoryStatistics& u ) const HK_OVERRIDE;
        virtual int getAllocatedSize(_In_bytecount_(nbytes) const void* obj, int nbytes) const HK_OVERRIDE;
    };
    static Allocator s_alloc;
    hkMemoryAllocator& get(_In_opt_ const void*) { return s_alloc; }
};

/// Allocator used when generic allocation is required without affecting the
/// other allocators.
struct HK_EXPORT_COMMON hkContainerDefaultMallocAllocator
{
    HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE, hkContainerDefaultMallocAllocator);
    hkMemoryAllocator& get(_In_opt_ const void*);
};

/// An allocator implementation which uses the aligned functions in
/// \ref hkMemoryRouter, passing the heap allocator (that is, the allocator
/// returned by hkMemoryRouter::getInstance().heap()) as the underlying allocator.
template <typename ALIGN_OF_TYPE>
struct hkContainerAlignedHeapAllocator
{
    HK_DECLARE_CLASS(hkContainerAlignedHeapAllocator, NewOpaque, Reflect);
    struct Allocator : public hkMemoryAllocator
    {
        HK_DECLARE_CLASS(Allocator, NewOpaque);
        virtual void* blockAlloc( int numBytes ) HK_OVERRIDE;
        virtual void blockFree( void* p, int numBytes ) HK_OVERRIDE;
        virtual void* bufAlloc( int& reqNumBytesInOut ) HK_OVERRIDE;
        virtual void bufFree( void* p, int numBytes ) HK_OVERRIDE;
        virtual void* bufRealloc( void* pold, int oldNumBytes, int& reqNumBytesInOut ) HK_OVERRIDE;
        virtual void getMemoryStatistics( MemoryStatistics& u ) const HK_OVERRIDE;
        virtual int getAllocatedSize(const void* obj, int nbytes) const HK_OVERRIDE;
    };
    static Allocator s_alloc;
    hkMemoryAllocator& get(const void*) { return s_alloc; }
};

#ifdef HK_MEMORY_TRACKER_ENABLE
    /// True for heap allocator, false for everything else.
template<typename Allocator> struct hkContainerAllocatorIsTracked { enum { result = 0 }; };
template<> struct hkContainerAllocatorIsTracked<hkContainerHeapAllocator> { enum { result = 1 }; };
#endif

#include <Common/Base/Container/hkContainerAllocators.inl>
#include <Common/Base/_Auto/TemplateTypes/hkContainerAllocators_Types.inl>

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
