// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Base/hkBase.h>
#include <Common/Base/Container/hkContainerAllocators.h>
#include <Common/Base/Memory/Allocator/Malloc/hkMallocAllocator.h>

_Ret_notnull_ _Post_writable_byte_size_(numBytes) void* hkContainerTempAllocator::Allocator::blockAlloc( int numBytes ) { return hkMemoryRouter::getInstance().temp().blockAlloc(numBytes); }
void hkContainerTempAllocator::Allocator::blockFree( _In_opt_bytecount_(numBytes) void* p, int numBytes ) { return hkMemoryRouter::getInstance().temp().blockFree(p, numBytes); }
_Ret_notnull_ _Post_writable_byte_size_(reqNumBytesInOut) void* hkContainerTempAllocator::Allocator::bufAlloc(int& reqNumBytesInOut) { return hkMemoryRouter::getInstance().temp().bufAlloc(reqNumBytesInOut); }
void hkContainerTempAllocator::Allocator::bufFree( _In_opt_bytecount_(numBytes) void* p, int numBytes ) { return hkMemoryRouter::getInstance().temp().bufFree(p,numBytes); }
_Ret_notnull_ _Post_writable_byte_size_(reqNumBytesInOut) void* hkContainerTempAllocator::Allocator::bufRealloc(_In_reads_bytes_(oldNumBytes) void* pold, int oldNumBytes, int& reqNumBytesInOut ) { return hkMemoryRouter::getInstance().temp().bufRealloc(pold,oldNumBytes,reqNumBytesInOut); }
void hkContainerTempAllocator::Allocator::getMemoryStatistics( MemoryStatistics& u ) const { return hkMemoryRouter::getInstance().temp().getMemoryStatistics(u); }
int hkContainerTempAllocator::Allocator::getAllocatedSize( _In_bytecount_(nbytes) const void* obj, int nbytes) const { return hkMemoryRouter::getInstance().temp().getAllocatedSize(obj, nbytes); }
hkContainerTempAllocator::Allocator hkContainerTempAllocator::s_alloc;

_Ret_notnull_ _Post_writable_byte_size_(numBytes) void* hkContainerDebugAllocator::Allocator::blockAlloc(int numBytes) { return hkMemoryRouter::getInstance().debug().blockAlloc(numBytes); }
void hkContainerDebugAllocator::Allocator::blockFree(_In_opt_bytecount_(numBytes) void* p, int numBytes ) { return hkMemoryRouter::getInstance().debug().blockFree(p, numBytes); }
_Ret_notnull_ _Post_writable_byte_size_(reqNumBytesInOut) void* hkContainerDebugAllocator::Allocator::bufAlloc(int& reqNumBytesInOut) { return hkMemoryRouter::getInstance().debug().bufAlloc(reqNumBytesInOut); }
void hkContainerDebugAllocator::Allocator::bufFree( _In_opt_bytecount_(numBytes) void* p, int numBytes ) { return hkMemoryRouter::getInstance().debug().bufFree(p,numBytes); }
_Ret_notnull_ _Post_writable_byte_size_(reqNumBytesInOut) void* hkContainerDebugAllocator::Allocator::bufRealloc( _In_reads_bytes_(oldNumBytes) void* pold, int oldNumBytes, int& reqNumBytesInOut ) { return hkMemoryRouter::getInstance().debug().bufRealloc(pold,oldNumBytes,reqNumBytesInOut); }
void hkContainerDebugAllocator::Allocator::getMemoryStatistics( MemoryStatistics& u ) const { return hkMemoryRouter::getInstance().debug().getMemoryStatistics(u); }
int hkContainerDebugAllocator::Allocator::getAllocatedSize(_In_bytecount_(nbytes) const void* obj, int nbytes) const { return hkMemoryRouter::getInstance().debug().getAllocatedSize(obj, nbytes); }
hkContainerDebugAllocator::Allocator hkContainerDebugAllocator::s_alloc;

hkMemoryAllocator& hkContainerDefaultMallocAllocator::get(_In_opt_ const void*) { return *hkMallocAllocator::m_defaultMallocAllocator; }

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
