// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/Algorithm/Hash/hkHash.h>

/// hkMapOperations specializations for hkTuple types.
/// These rely on hkMapOperations<T> being available for each type T that's part of the hkTuple.

template< typename T0 >
struct hkMapOperations< hkTuple<T0> >
{
    typedef hkTuple<T0> Tuple;
    inline static unsigned hash(const Tuple& key, unsigned mod)
    {
        return hkHashValue(key) & mod;
    }
    inline static void invalidate(Tuple& key)
    {
        hkMapOperations<T0>::invalidate(key.m_0);
    }
    inline static hkBool32 isValid(const Tuple& key)
    {
        return hkMapOperations<T0>::isValid(key.m_0);
    }
    inline static hkBool32 equal(const Tuple& key0, const Tuple& key1)
    {
        return key0 == key1;
    }
};

template< typename T0, typename T1 >
struct hkMapOperations< hkTuple<T0, T1> >
{
    typedef hkTuple<T0, T1> Tuple;
    inline static unsigned hash(const Tuple& key, unsigned mod)
    {
        return hkHashValue(key) & mod;
    }
    inline static void invalidate(Tuple& key)
    {
        hkMapOperations<T0>::invalidate(key.m_0);
        hkMapOperations<T1>::invalidate(key.m_1);
    }
    inline static hkBool32 isValid(const Tuple& key)
    {
        return hkMapOperations<T0>::isValid(key.m_0)
            || hkMapOperations<T1>::isValid(key.m_1);
    }
    inline static hkBool32 equal(const Tuple& key0, const Tuple& key1)
    {
        return key0 == key1;
    }
};

template< typename T0, typename T1, typename T2 >
struct hkMapOperations< hkTuple<T0, T1, T2> >
{
    typedef hkTuple<T0, T1, T2> Tuple;
    inline static unsigned hash(const Tuple& key, unsigned mod)
    {
        return hkHashValue(key) & mod;
    }
    inline static void invalidate(Tuple& key)
    {
        hkMapOperations<T0>::invalidate(key.m_0);
        hkMapOperations<T1>::invalidate(key.m_1);
        hkMapOperations<T2>::invalidate(key.m_2);
    }
    inline static hkBool32 isValid(const Tuple& key)
    {
        return hkMapOperations<T0>::isValid(key.m_0)
            || hkMapOperations<T1>::isValid(key.m_1)
            || hkMapOperations<T2>::isValid(key.m_2);
    }
    inline static hkBool32 equal(const Tuple& key0, const Tuple& key1)
    {
        return key0 == key1;
    }
};

template< typename T0, typename T1, typename T2, typename T3 >
struct hkMapOperations< hkTuple<T0, T1, T2, T3> >
{
    typedef hkTuple<T0, T1, T2, T3> Tuple;
    inline static unsigned hash(const Tuple& key, unsigned mod)
    {
        return hkHashValue(key) & mod;
    }
    inline static void invalidate(Tuple& key)
    {
        hkMapOperations<T0>::invalidate(key.m_0);
        hkMapOperations<T1>::invalidate(key.m_1);
        hkMapOperations<T2>::invalidate(key.m_2);
        hkMapOperations<T3>::invalidate(key.m_3);
    }
    inline static hkBool32 isValid(const Tuple& key)
    {
        return hkMapOperations<T0>::isValid(key.m_0)
            || hkMapOperations<T1>::isValid(key.m_1)
            || hkMapOperations<T2>::isValid(key.m_2)
            || hkMapOperations<T3>::isValid(key.m_3);
    }
    inline static hkBool32 equal(const Tuple& key0, const Tuple& key1)
    {
        return key0 == key1;
    }
};

template< typename T0, typename T1, typename T2, typename T3, typename T4 >
struct hkMapOperations< hkTuple<T0, T1, T2, T3, T4> >
{
    typedef hkTuple<T0, T1, T2, T3, T4> Tuple;
    inline static unsigned hash(const Tuple& key, unsigned mod)
    {
        return hkHashValue(key) & mod;
    }
    inline static void invalidate(Tuple& key)
    {
        hkMapOperations<T0>::invalidate(key.m_0);
        hkMapOperations<T1>::invalidate(key.m_1);
        hkMapOperations<T2>::invalidate(key.m_2);
        hkMapOperations<T3>::invalidate(key.m_3);
        hkMapOperations<T4>::invalidate(key.m_4);
    }
    inline static hkBool32 isValid(const Tuple& key)
    {
        return hkMapOperations<T0>::isValid(key.m_0)
            || hkMapOperations<T1>::isValid(key.m_1)
            || hkMapOperations<T2>::isValid(key.m_2)
            || hkMapOperations<T3>::isValid(key.m_3)
            || hkMapOperations<T4>::isValid(key.m_4);
    }
    inline static hkBool32 equal(const Tuple& key0, const Tuple& key1)
    {
        return key0 == key1;
    }
};

template< typename T0, typename T1, typename T2, typename T3, typename T4, typename T5 >
struct hkMapOperations< hkTuple<T0, T1, T2, T3, T4, T5> >
{
    typedef hkTuple<T0, T1, T2, T3, T4, T5> Tuple;
    inline static unsigned hash(const Tuple& key, unsigned mod)
    {
        return hkHashValue(key) & mod;
    }
    inline static void invalidate(Tuple& key)
    {
        hkMapOperations<T0>::invalidate(key.m_0);
        hkMapOperations<T1>::invalidate(key.m_1);
        hkMapOperations<T2>::invalidate(key.m_2);
        hkMapOperations<T3>::invalidate(key.m_3);
        hkMapOperations<T4>::invalidate(key.m_4);
        hkMapOperations<T5>::invalidate(key.m_5);
    }
    inline static hkBool32 isValid(const Tuple& key)
    {
        return hkMapOperations<T0>::isValid(key.m_0)
            || hkMapOperations<T1>::isValid(key.m_1)
            || hkMapOperations<T2>::isValid(key.m_2)
            || hkMapOperations<T3>::isValid(key.m_3)
            || hkMapOperations<T4>::isValid(key.m_4)
            || hkMapOperations<T5>::isValid(key.m_5);
    }
    inline static hkBool32 equal(const Tuple& key0, const Tuple& key1)
    {
        return key0 == key1;
    }
};

template< typename T0, typename T1, typename T2, typename T3, typename T4, typename T5, typename T6 >
struct hkMapOperations< hkTuple<T0, T1, T2, T3, T4, T5, T6> >
{
    typedef hkTuple<T0, T1, T2, T3, T4, T5, T6> Tuple;
    inline static unsigned hash(const Tuple& key, unsigned mod)
    {
        return hkHashValue(key) & mod;
    }
    inline static void invalidate(Tuple& key)
    {
        hkMapOperations<T0>::invalidate(key.m_0);
        hkMapOperations<T1>::invalidate(key.m_1);
        hkMapOperations<T2>::invalidate(key.m_2);
        hkMapOperations<T3>::invalidate(key.m_3);
        hkMapOperations<T4>::invalidate(key.m_4);
        hkMapOperations<T5>::invalidate(key.m_5);
        hkMapOperations<T6>::invalidate(key.m_6);
    }
    inline static hkBool32 isValid(const Tuple& key)
    {
        return hkMapOperations<T0>::isValid(key.m_0)
            || hkMapOperations<T1>::isValid(key.m_1)
            || hkMapOperations<T2>::isValid(key.m_2)
            || hkMapOperations<T3>::isValid(key.m_3)
            || hkMapOperations<T4>::isValid(key.m_4)
            || hkMapOperations<T5>::isValid(key.m_5)
            || hkMapOperations<T6>::isValid(key.m_6);
    }
    inline static hkBool32 equal(const Tuple& key0, const Tuple& key1)
    {
        return key0 == key1;
    }
};

template< typename T0, typename T1, typename T2, typename T3, typename T4, typename T5, typename T6, typename T7 >
struct hkMapOperations< hkTuple<T0, T1, T2, T3, T4, T5, T6, T7> >
{
    typedef hkTuple<T0, T1, T2, T3, T4, T5, T6, T7> Tuple;
    inline static unsigned hash(const Tuple& key, unsigned mod)
    {
        return hkHashValue(key) & mod;
    }
    inline static void invalidate(Tuple& key)
    {
        hkMapOperations<T0>::invalidate(key.m_0);
        hkMapOperations<T1>::invalidate(key.m_1);
        hkMapOperations<T2>::invalidate(key.m_2);
        hkMapOperations<T3>::invalidate(key.m_3);
        hkMapOperations<T4>::invalidate(key.m_4);
        hkMapOperations<T5>::invalidate(key.m_5);
        hkMapOperations<T6>::invalidate(key.m_6);
        hkMapOperations<T7>::invalidate(key.m_7);
    }
    inline static hkBool32 isValid(const Tuple& key)
    {
        return hkMapOperations<T0>::isValid(key.m_0)
            || hkMapOperations<T1>::isValid(key.m_1)
            || hkMapOperations<T2>::isValid(key.m_2)
            || hkMapOperations<T3>::isValid(key.m_3)
            || hkMapOperations<T4>::isValid(key.m_4)
            || hkMapOperations<T5>::isValid(key.m_5)
            || hkMapOperations<T6>::isValid(key.m_6)
            || hkMapOperations<T7>::isValid(key.m_7);
    }
    inline static hkBool32 equal(const Tuple& key0, const Tuple& key1)
    {
        return key0 == key1;
    }
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
