// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/Algorithm/Hash/hkHash.h>

template<
    typename T0 = void,
    typename T1 = void,
    typename T2 = void,
    typename T3 = void,
    typename T4 = void,
    typename T5 = void,
    typename T6 = void,
    typename T7 = void
>
struct hkTuple
{
    HK_DECLARE_CLASS(hkTuple, NewTemplate, Reflect);
    HK_RECORD_ATTR( hk::ToString( &hkTupleDetail::toString ) );
    enum { NUM_ELEM = 8 };
    hkTuple() {}
    hkTuple(const T0& e0, const T1& e1, const T2& e2, const T3& e3, const T4& e4, const T5& e5, const T6& e6, const T7& e7)
        : m_0(e0), m_1(e1), m_2(e2), m_3(e3), m_4(e4), m_5(e5), m_6(e6), m_7(e7) { }
    bool operator==(const hkTuple& t) const { return m_0==t.m_0&&m_1==t.m_1&&m_2==t.m_2&&m_3==t.m_3&&m_4==t.m_4&&m_5==t.m_5&&m_6==t.m_6&&m_7==t.m_7; }

    T0 m_0;
    T1 m_1;
    T2 m_2;
    T3 m_3;
    T4 m_4;
    T5 m_5;
    T6 m_6;
    T7 m_7;
};

template<>
struct HK_EXPORT_COMMON hkTuple<void, void, void, void, void, void, void, void>
{
    HK_DECLARE_CLASS(hkTuple, New, Reflect);
    HK_RECORD_ATTR( hk::ToString( &hkTupleDetail::toString ) );
    enum { NUM_ELEM = 0 };
    HK_ALWAYS_INLINE hkTuple() {}
};

template< typename T0 >
struct hkTuple<T0, void, void, void, void, void, void, void>
{
    HK_DECLARE_CLASS(hkTuple, NewTemplate, Reflect);
    HK_RECORD_ATTR( hk::ToString( &hkTupleDetail::toString ) );
    enum { NUM_ELEM = 1 };
    HK_ALWAYS_INLINE hkTuple() {}
    HK_ALWAYS_INLINE hkTuple(const T0& t0) : m_0(t0) {}
    bool operator==(const hkTuple& t) const { return m_0==t.m_0; }

    T0 m_0;
};
template< typename T0, typename T1 >
struct hkTuple<T0, T1, void, void, void, void, void, void>
{
    HK_DECLARE_CLASS(hkTuple, NewTemplate, Reflect);
    HK_RECORD_ATTR( hk::ToString( &hkTupleDetail::toString ) );
    enum { NUM_ELEM = 2 };
    hkTuple() {}
    hkTuple(const T0& t0, const T1& t1) : m_0(t0), m_1(t1) {}
    bool operator==(const hkTuple& t) const { return m_0==t.m_0&&m_1==t.m_1; }

    T0 m_0;
    T1 m_1;
};
template< typename T0, typename T1, typename T2 >
struct hkTuple<T0, T1, T2, void, void, void, void, void>
{
    HK_DECLARE_CLASS(hkTuple, NewTemplate, Reflect);
    HK_RECORD_ATTR( hk::ToString( &hkTupleDetail::toString ) );
    enum { NUM_ELEM = 3 };
    hkTuple() {}
    hkTuple(const T0& t0, const T1& t1, const T2& t2) : m_0(t0), m_1(t1), m_2(t2) {}
    bool operator==(const hkTuple& t) const { return m_0==t.m_0&&m_1==t.m_1&&m_2==t.m_2; }

    T0 m_0;
    T1 m_1;
    T2 m_2;
};
template< typename T0, typename T1, typename T2, typename T3 >
struct hkTuple<T0, T1, T2, T3, void, void, void, void>
{
    HK_DECLARE_CLASS(hkTuple, NewTemplate, Reflect);
    HK_RECORD_ATTR( hk::ToString( &hkTupleDetail::toString ) );
    enum { NUM_ELEM = 4 };
    hkTuple() {}
    hkTuple(const T0& t0, const T1& t1, const T2& t2, const T3& t3) : m_0(t0), m_1(t1), m_2(t2), m_3(t3) {}
    bool operator==(const hkTuple& t) const { return m_0==t.m_0&&m_1==t.m_1&&m_2==t.m_2&&m_3==t.m_3; }

    T0 m_0;
    T1 m_1;
    T2 m_2;
    T3 m_3;
};
template< typename T0, typename T1, typename T2, typename T3, typename T4 >
struct hkTuple<T0, T1, T2, T3, T4, void, void, void>
{
    HK_DECLARE_CLASS(hkTuple, NewTemplate, Reflect);
    HK_RECORD_ATTR( hk::ToString( &hkTupleDetail::toString ) );
    enum { NUM_ELEM = 5 };
    hkTuple() {}
    hkTuple(const T0& t0, const T1& t1, const T2& t2, const T3& t3, const T4& t4) : m_0(t0), m_1(t1), m_2(t2), m_3(t3), m_4(t4) {}
    bool operator==(const hkTuple& t) const { return m_0==t.m_0&&m_1==t.m_1&&m_2==t.m_2&&m_3==t.m_3&&m_4==t.m_4; }

    T0 m_0;
    T1 m_1;
    T2 m_2;
    T3 m_3;
    T4 m_4;
};
template< typename T0, typename T1, typename T2, typename T3, typename T4, typename T5 >
struct hkTuple<T0, T1, T2, T3, T4, T5, void, void>
{
    HK_DECLARE_CLASS(hkTuple, NewTemplate, Reflect);
    HK_RECORD_ATTR( hk::ToString( &hkTupleDetail::toString ) );
    enum { NUM_ELEM = 6 };
    hkTuple() {}
    hkTuple(const T0& t0, const T1& t1, const T2& t2, const T3& t3, const T4& t4, const T5& t5) : m_0(t0), m_1(t1), m_2(t2), m_3(t3), m_4(t4), m_5(t5) {}
    bool operator==(const hkTuple& t) const { return m_0==t.m_0&&m_1==t.m_1&&m_2==t.m_2&&m_3==t.m_3&&m_4==t.m_4&&m_5==t.m_5; }

    T0 m_0;
    T1 m_1;
    T2 m_2;
    T3 m_3;
    T4 m_4;
    T5 m_5;
};
template< typename T0, typename T1, typename T2, typename T3, typename T4, typename T5, typename T6 >
struct hkTuple<T0, T1, T2, T3, T4, T5, T6, void>
{
    HK_DECLARE_CLASS(hkTuple, NewTemplate, Reflect);
    HK_RECORD_ATTR( hk::ToString( &hkTupleDetail::toString ) );
    enum { NUM_ELEM = 7 };
    hkTuple() {}
    hkTuple(const T0& t0, const T1& t1, const T2& t2, const T3& t3, const T4& t4, const T5& t5, const T6& t6) : m_0(t0), m_1(t1), m_2(t2), m_3(t3), m_4(t4), m_5(t5), m_6(t6) {}
    bool operator==(const hkTuple& t) const { return m_0==t.m_0&&m_1==t.m_1&&m_2==t.m_2&&m_3==t.m_3&&m_4==t.m_4&&m_5==t.m_5&&m_6==t.m_6; }

    T0 m_0;
    T1 m_1;
    T2 m_2;
    T3 m_3;
    T4 m_4;
    T5 m_5;
    T6 m_6;
};

namespace hkTupleT
{
    // Use hkTupleT::make() to easily create hkTuples using template argument deduction.

    inline hkTuple<> make()
    {
        return hkTuple<>();
    }
    template <typename T0>
    inline hkTuple<T0> make(const T0& t0)
    {
        return hkTuple<T0>(t0);
    }
    template <typename T0, typename T1>
    inline hkTuple<T0, T1> make(const T0& t0, const T1& t1)
    {
        return hkTuple<T0, T1>(t0, t1);
    }
    template <typename T0, typename T1, typename T2>
    inline hkTuple<T0, T1, T2> make(const T0& t0, const T1& t1, const T2& t2)
    {
        return hkTuple<T0, T1, T2>(t0, t1, t2);
    }
    template <typename T0, typename T1, typename T2, typename T3>
    inline hkTuple<T0, T1, T2, T3> make(const T0& t0, const T1& t1, const T2& t2, const T3& t3)
    {
        return hkTuple<T0, T1, T2, T3>(t0, t1, t2, t3);
    }
    template <typename T0, typename T1, typename T2, typename T3, typename T4>
    inline hkTuple<T0, T1, T2, T3, T4> make(const T0& t0, const T1& t1, const T2& t2, const T3& t3, const T4& t4)
    {
        return hkTuple<T0, T1, T2, T3, T4>(t0, t1, t2, t3, t4);
    }
    template <typename T0, typename T1, typename T2, typename T3, typename T4, typename T5>
    inline hkTuple<T0, T1, T2, T3, T4, T5> make(const T0& t0, const T1& t1, const T2& t2, const T3& t3, const T4& t4, const T5& t5)
    {
        return hkTuple<T0, T1, T2, T3, T4, T5>(t0, t1, t2, t3, t4, t5);
    }
    template <typename T0, typename T1, typename T2, typename T3, typename T4, typename T5, typename T6>
    inline hkTuple<T0, T1, T2, T3, T4, T5, T6> make(const T0& t0, const T1& t1, const T2& t2, const T3& t3, const T4& t4, const T5& t5, const T6& t6)
    {
        return hkTuple<T0, T1, T2, T3, T4, T5, T6>(t0, t1, t2, t3, t4, t5, t6);
    }
    template <typename T0, typename T1, typename T2, typename T3, typename T4, typename T5, typename T6, typename T7>
    inline hkTuple<T0, T1, T2, T3, T4, T5, T6, T7> make(const T0& t0, const T1& t1, const T2& t2, const T3& t3, const T4& t4, const T5& t5, const T6& t6, const T7& t7)
    {
        return hkTuple<T0, T1, T2, T3, T4, T5, T6, T7>(t0, t1, t2, t3, t4, t5, t6, t7);
    }

    template<unsigned Idx, typename Tuple>
    struct Nth;

    template<typename T0, typename T1, typename T2, typename T3, typename T4, typename T5, typename T6, typename T7>
    struct Nth<0, hkTuple<T0, T1, T2, T3, T4, T5, T6, T7>>
    {
        typedef hkTuple<T0, T1, T2, T3, T4, T5, T6, T7> TupleType;
        typedef T0 Type;

        static Type& get(TupleType& tuple) { return tuple.m_0; }
        static const Type& get(const TupleType& tuple) { return tuple.m_0; }
    };

    template<typename T0, typename T1, typename T2, typename T3, typename T4, typename T5, typename T6, typename T7>
    struct Nth<1, hkTuple<T0, T1, T2, T3, T4, T5, T6, T7>>
    {
        typedef hkTuple<T0, T1, T2, T3, T4, T5, T6, T7> TupleType;
        typedef T1 Type;

        static Type& get(TupleType& tuple) { return tuple.m_1; }
        static const Type& get(const TupleType& tuple) { return tuple.m_1; }
    };

    template<typename T0, typename T1, typename T2, typename T3, typename T4, typename T5, typename T6, typename T7>
    struct Nth<2, hkTuple<T0, T1, T2, T3, T4, T5, T6, T7>>
    {
        typedef hkTuple<T0, T1, T2, T3, T4, T5, T6, T7> TupleType;
        typedef T2 Type;

        static Type& get(TupleType& tuple) { return tuple.m_2; }
        static const Type& get(const TupleType& tuple) { return tuple.m_2; }
    };

    template<typename T0, typename T1, typename T2, typename T3, typename T4, typename T5, typename T6, typename T7>
    struct Nth<3, hkTuple<T0, T1, T2, T3, T4, T5, T6, T7>>
    {
        typedef hkTuple<T0, T1, T2, T3, T4, T5, T6, T7> TupleType;
        typedef T3 Type;

        static Type& get(TupleType& tuple) { return tuple.m_3; }
        static const Type& get(const TupleType& tuple) { return tuple.m_3; }
    };

    template<typename T0, typename T1, typename T2, typename T3, typename T4, typename T5, typename T6, typename T7>
    struct Nth<4, hkTuple<T0, T1, T2, T3, T4, T5, T6, T7>>
    {
        typedef hkTuple<T0, T1, T2, T3, T4, T5, T6, T7> TupleType;
        typedef T4 Type;

        static Type& get(TupleType& tuple) { return tuple.m_4; }
        static const Type& get(const TupleType& tuple) { return tuple.m_4; }
    };

    template<typename T0, typename T1, typename T2, typename T3, typename T4, typename T5, typename T6, typename T7>
    struct Nth<5, hkTuple<T0, T1, T2, T3, T4, T5, T6, T7>>
    {
        typedef hkTuple<T0, T1, T2, T3, T4, T5, T6, T7> TupleType;
        typedef T5 Type;

        static Type& get(TupleType& tuple) { return tuple.m_5; }
        static const Type& get(const TupleType& tuple) { return tuple.m_5; }
    };

    template<typename T0, typename T1, typename T2, typename T3, typename T4, typename T5, typename T6, typename T7>
    struct Nth<6, hkTuple<T0, T1, T2, T3, T4, T5, T6, T7>>
    {
        typedef hkTuple<T0, T1, T2, T3, T4, T5, T6, T7> TupleType;
        typedef T6 Type;

        static Type& get(TupleType& tuple) { return tuple.m_6; }
        static const Type& get(const TupleType& tuple) { return tuple.m_6; }
    };

    template<typename T0, typename T1, typename T2, typename T3, typename T4, typename T5, typename T6, typename T7>
    struct Nth<7, hkTuple<T0, T1, T2, T3, T4, T5, T6, T7>>
    {
        typedef hkTuple<T0, T1, T2, T3, T4, T5, T6, T7> TupleType;
        typedef T7 Type;

        static Type& get(TupleType& tuple) { return tuple.m_7; }
        static const Type& get(const TupleType& tuple) { return tuple.m_7; }
    };

    template<unsigned Idx, typename Tuple>
    typename Nth<Idx, Tuple>::Type& get(Tuple& tuple)
    {
        return Nth<Idx, Tuple>::get(tuple);
    }

    template<unsigned Idx, typename Tuple>
    const typename Nth<Idx, Tuple>::Type& get(const Tuple& tuple)
    {
        return Nth<Idx, Tuple>::get(tuple);
    }
}

template< typename T0 >
inline static hkUint32 hkHashValue(const hkTuple<T0>& key)
{
    using namespace hkHash;
    return hkHashValue(key.m_0);
}

template< typename T0, typename T1 >
inline static hkUint32 hkHashValue(const hkTuple<T0, T1>& key)
{
    using namespace hkHash;
    hkUint32 hash0 = hkHashValue(key.m_0);
    hash0 = combineHashValues(hash0, hkHashValue(key.m_1));
    return hash0;
}

template< typename T0, typename T1, typename T2 >
inline static hkUint32 hkHashValue(const hkTuple<T0, T1, T2>& key)
{
    using namespace hkHash;
    hkUint32 hash0 = hkHashValue(key.m_0);
    hash0 = combineHashValues(hash0, hkHashValue(key.m_1));
    hash0 = combineHashValues(hash0, hkHashValue(key.m_2));
    return hash0;
}

template< typename T0, typename T1, typename T2, typename T3 >
inline static hkUint32 hkHashValue(const hkTuple<T0, T1, T2, T3>& key)
{
    using namespace hkHash;
    hkUint32 hash0 = hkHashValue(key.m_0);
    hash0 = combineHashValues(hash0, hkHashValue(key.m_1));
    hash0 = combineHashValues(hash0, hkHashValue(key.m_2));
    hash0 = combineHashValues(hash0, hkHashValue(key.m_3));
    return hash0;
}

template< typename T0, typename T1, typename T2, typename T3, typename T4 >
inline static hkUint32 hkHashValue(const hkTuple<T0, T1, T2, T3, T4>& key)
{
    using namespace hkHash;
    hkUint32 hash0 = hkHashValue(key.m_0);
    hash0 = combineHashValues(hash0, hkHashValue(key.m_1));
    hash0 = combineHashValues(hash0, hkHashValue(key.m_2));
    hash0 = combineHashValues(hash0, hkHashValue(key.m_3));
    hash0 = combineHashValues(hash0, hkHashValue(key.m_4));
    return hash0;
}

template< typename T0, typename T1, typename T2, typename T3, typename T4, typename T5 >
inline static hkUint32 hkHashValue(const hkTuple<T0, T1, T2, T3, T4, T5>& key)
{
    using namespace hkHash;
    hkUint32 hash0 = hkHashValue(key.m_0);
    hash0 = combineHashValues(hash0, hkHashValue(key.m_1));
    hash0 = combineHashValues(hash0, hkHashValue(key.m_2));
    hash0 = combineHashValues(hash0, hkHashValue(key.m_3));
    hash0 = combineHashValues(hash0, hkHashValue(key.m_4));
    hash0 = combineHashValues(hash0, hkHashValue(key.m_5));
    return hash0;
}

template< typename T0, typename T1, typename T2, typename T3, typename T4, typename T5, typename T6 >
inline static hkUint32 hkHashValue(const hkTuple<T0, T1, T2, T3, T4, T5, T6>& key)
{
    using namespace hkHash;
    hkUint32 hash0 = hkHashValue(key.m_0);
    hash0 = combineHashValues(hash0, hkHashValue(key.m_1));
    hash0 = combineHashValues(hash0, hkHashValue(key.m_2));
    hash0 = combineHashValues(hash0, hkHashValue(key.m_3));
    hash0 = combineHashValues(hash0, hkHashValue(key.m_4));
    hash0 = combineHashValues(hash0, hkHashValue(key.m_5));
    hash0 = combineHashValues(hash0, hkHashValue(key.m_6));
    return hash0;
}

template< typename T0, typename T1, typename T2, typename T3, typename T4, typename T5, typename T6, typename T7 >
inline static hkUint32 hkHashValue(const hkTuple<T0, T1, T2, T3, T4, T5, T6, T7>& key)
{
    using namespace hkHash;
    hkUint32 hash0 = hkHashValue(key.m_0);
    hash0 = combineHashValues(hash0, hkHashValue(key.m_1));
    hash0 = combineHashValues(hash0, hkHashValue(key.m_2));
    hash0 = combineHashValues(hash0, hkHashValue(key.m_3));
    hash0 = combineHashValues(hash0, hkHashValue(key.m_4));
    hash0 = combineHashValues(hash0, hkHashValue(key.m_5));
    hash0 = combineHashValues(hash0, hkHashValue(key.m_6));
    hash0 = combineHashValues(hash0, hkHashValue(key.m_7));
    return hash0;
}

namespace hkTupleDetail
{
    HK_EXPORT_COMMON void toString( const hkReflect::Var& tupleVar, hkStringBuf& out, const hkStringView& extra );
}

#include <Common/Base/_Auto/TemplateTypes/hkTuple_Types.inl>

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
