// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

template <typename T>
inline hkTree<T>::hkTree()
    : m_root(HK_NULL)
{
}

template <typename T>
inline hkTree<T>::~hkTree()
{
    clear();
}

template <typename T>
inline void hkTree<T>::clear()
{
    if( m_root )
    {
        remove(m_root);
        m_root = HK_NULL;
    }
}

template <typename T>
inline typename hkTree<T>::Iter hkTree<T>::appendChild(_In_ Iter iter, const T& value)
{
    Node* newNode = new Node(value);
    newNode->m_parent = iter;

    if( iter != HK_NULL )
    {
        if( Node* n = iter->m_firstChild )
        {
            while( Node* m = n->m_nextSibling )
            {
                n = m;
            }
            n->m_nextSibling = newNode;
        }
        else
        {
            iter->m_firstChild = newNode;
        }
    }
    else if( Node* c = m_root ) // add to existing root
    {
        while( Node* n = c->m_nextSibling )
        {
            c = n;
        }
        c->m_nextSibling = newNode;
    }
    else // new root
    {
        m_root = newNode;
    }
    return newNode;
}

template <typename T>
inline typename hkTree<T>::Iter hkTree<T>::appendSibling(_In_ Iter iter, const T& value)
{
    HK_ASSERT_NO_MSG(0x273481ab, iter != HK_NULL);
    HK_ASSERT_NO_MSG(0x273481ac, iter->m_nextSibling == HK_NULL);
    Node* newNode = new Node();
    newNode->m_value = value;
    newNode->m_parent = iter->m_parent;
    newNode->m_nextSibling = iter->m_nextSibling;
    iter->m_nextSibling = newNode;
    return newNode;
}

template <typename T>
inline void hkTree<T>::remove(_In_ Iter iter)
{
    HK_ASSERT_NO_MSG(0x21d5eb18, iter != HK_NULL );
    if( iter->m_parent ) // unhook node from tree
    {
        HK_ASSERT_NO_MSG(0x1d043145, iter->m_parent->m_firstChild);
        Node* prev = iter->m_parent->m_firstChild;
        if( prev == iter )
        {
            iter->m_parent->m_firstChild = HK_NULL;
        }
        else
        {
            while( prev->m_nextSibling != iter )
            {
                prev = prev->m_nextSibling;
            }
            prev->m_nextSibling = iter->m_nextSibling;
        }
        iter->m_parent = HK_NULL;
    }
    // now destroy
    {
        Iter cur = iter;
        while(cur)
        {
            while( cur->m_firstChild )
            {
                cur = cur->m_firstChild;
            }
            Iter next = cur->m_nextSibling ? cur->m_nextSibling : cur->m_parent;
            if( Node* p = cur->m_parent )
            {
                p->m_firstChild = HK_NULL;
            }
            delete cur;
            cur = next;
        }
    }
}

template <typename T>
inline void hkTree<T>::setValue(_In_ Iter i, const T& t )
{
    HK_ASSERT_NO_MSG(0x273481ab, i != HK_NULL);
    i->m_value = t;
}

template <typename T>
inline T& hkTree<T>::getValue(_In_ Iter i) const
{
    HK_ASSERT_NO_MSG(0x273481ab, i != HK_NULL);
    return i->m_value;
}

template <typename T>
inline int hkTree<T>::getDepth(_In_ Iter i) const
{
    HK_ASSERT_NO_MSG(0x273481ab, i != HK_NULL);
    int d = -1;
    Node* n = i;
    while( n )
    {
        n = n->m_parent;
        d += 1;
    }
    return d;
}

template <typename T>
inline int hkTree<T>::getNumChildren(_In_ Iter i) const
{
    HK_ASSERT_NO_MSG(0x273481ab, i != HK_NULL);
    int c = 0;
    Node* n = i->m_firstChild;
    while( n )
    {
        n = n->m_nextSibling;
        c += 1;
    }
    return c;
}

template <typename T>
inline typename hkTree<T>::Iter hkTree<T>::iterGetFirst() const
{
    return const_cast<Iter>(m_root);
}

template <typename T>
inline typename hkTree<T>::Iter hkTree<T>::iterNext(_In_ Iter i) const
{
    HK_ASSERT_NO_MSG(0x273481ab, i != HK_NULL);
    return i->m_nextSibling;
}

template <typename T>
inline typename hkTree<T>::Iter hkTree<T>::iterParent(_In_ Iter i) const
{
    HK_ASSERT_NO_MSG(0x273481ab, i != HK_NULL);
    return i->m_parent;
}

template <typename T>
inline typename hkTree<T>::Iter hkTree<T>::iterChildren(_In_ Iter i) const
{
    return i ? i->m_firstChild : m_root;
}

template <typename T>
inline typename hkTree<T>::Iter hkTree<T>::iterNextPreOrder(_In_ Iter i) const
{
    HK_ASSERT_NO_MSG(0x273481ab, i != HK_NULL);
    if( i->m_firstChild )
    {
        return i->m_firstChild;
    }
    else
    {
        while( i->m_nextSibling == HK_NULL )
        {
            i = i->m_parent;
            if( i == HK_NULL )
            {
                return HK_NULL;
            }
        }
        return i->m_nextSibling;
    }
}

template <typename T>
inline typename hkTree<T>::Iter hkTree<T>::iterNextPreOrderSkippingChildren(_In_ Iter i) const
{
    HK_ASSERT_NO_MSG(0x273481ab, i != HK_NULL);
    while( i->m_nextSibling == HK_NULL )
    {
        i = i->m_parent;
        if( i == HK_NULL )
        {
            return HK_NULL;
        }
    }
    return i->m_nextSibling;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
